/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.ParserUtil;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.codeless.PackerUtil.CodeLessUtil;
import kd.ebg.egf.common.codeless.PackerUtil.ResponseCode;
import kd.ebg.egf.common.codeless.ParserUtil.ParseUtil;
import kd.ebg.egf.common.codeless.ParserUtil.ParserToMapUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class ParserReceiableUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ParseUtil.class);

    public static List<NoteReceivableInfo> parseReceivable(List<NoteReceivableInfo> receivableInfos, String rspStr) throws Exception {
        logger.info("\u4f4e\u4ee3\u7801\u6846\u67b6\u5f00\u59cb\u8fdb\u884c\u6570\u636e\u89e3\u6790\uff1a");
        ResponseCode responseCode = CodeLessUtil.getResponseCodeNode((String)rspStr);
        logger.info("\u4f4e\u4ee3\u7801\u6846\u67b6\u4ea4\u4e92\u54cd\u5e94\u7801\u89e3\u6790\u5b8c\u6bd5\uff0c" + responseCode.getCode() + "," + responseCode.getMsg());
        String outResult = ParseUtil.getResult((ResponseCode)responseCode, null, null, (String)"NOTE");
        if (StringUtils.isEmpty((String)outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u7a7a\uff0c\u7f6e\u4e3a\u4ea4\u6613\u7ed3\u679c\u672a\u77e5");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.UNKNOWN, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_9", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        if ("SUCCESS".equals(outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u6210\u529f");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.SUCCESS, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u6210\u529f\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_11", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        if ("FAIL".equals(outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u5931\u8d25");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.FAIL, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u5931\u8d25\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_12", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        if ("UNKNOWN".equals(outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u672a\u77e5");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.UNKNOWN, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_9", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        if ("SUBMITED".equals(outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u5904\u7406\u4e2d");
            for (NoteReceivableInfo NoteReceivableInfo2 : receivableInfos) {
                ParserReceiableUtil.reloadData(NoteReceivableInfo2, rspStr);
            }
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.SUBMITED, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u5904\u7406\u4e2d\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_13", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        if ("ERROR".equals(outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u5f02\u5e38");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.UNKNOWN, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_9", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u4e92\u54cd\u5e94\u7801\u5f02\u5e38%1$s %2$s %3$s\u3002", (String)"ParserReceiableUtil_14", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode(), responseCode.getMsg(), outResult));
        }
        if ("MIDDLE".equals(outResult)) {
            return ParserReceiableUtil.getInnerResult(receivableInfos, rspStr);
        }
        logger.error("\u5e94\u6536\u7968\u636e\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a" + outResult);
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a%s\u3002", (String)"ParserReceiableUtil_15", (String)"ebg-note-business", (Object[])new Object[0]), outResult + responseCode.getCode() + "," + responseCode.getMsg()));
    }

    public static List<NoteReceivableInfo> parseReceiableOnlyOutCode(List<NoteReceivableInfo> receivableInfos, String rspStr) throws Exception {
        logger.info("\u4f4e\u4ee3\u7801\u6846\u67b6\u5f00\u59cb\u8fdb\u884c\u6570\u636e\u89e3\u6790\uff1a");
        ResponseCode responseCode = CodeLessUtil.getResponseCodeNode((String)rspStr);
        logger.info("\u4f4e\u4ee3\u7801\u6846\u67b6\u4ea4\u4e92\u54cd\u5e94\u7801\u89e3\u6790\u5b8c\u6bd5\uff0c" + responseCode.getCode() + "," + responseCode.getMsg());
        String outResult = ParseUtil.getResult((ResponseCode)responseCode, null, null, (String)"NOTE");
        if (StringUtils.isEmpty((String)outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u7a7a\uff0c\u7f6e\u4e3a\u4ea4\u6613\u7ed3\u679c\u672a\u77e5");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.UNKNOWN, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_9", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        if ("SUCCESS".equals(outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u6210\u529f");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.SUCCESS, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u6210\u529f\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_11", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        if ("FAIL".equals(outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u5931\u8d25");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.FAIL, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u5931\u8d25\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_12", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        if ("UNKNOWN".equals(outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u672a\u77e5");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.UNKNOWN, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_9", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        if ("SUBMITED".equals(outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u5904\u7406\u4e2d");
            for (NoteReceivableInfo NoteReceivableInfo2 : receivableInfos) {
                ParserReceiableUtil.reloadData(NoteReceivableInfo2, rspStr);
            }
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.SUBMITED, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u5904\u7406\u4e2d\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_13", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        if ("ERROR".equals(outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u5f02\u5e38");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.UNKNOWN, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_9", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u4e92\u54cd\u5e94\u7801\u5f02\u5e38%1$s %2$s %3$s\u3002", (String)"ParserReceiableUtil_14", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode(), responseCode.getMsg(), outResult));
        }
        if ("MIDDLE".equals(outResult)) {
            logger.info("\u4f4e\u4ee3\u7801\u5e73\u53f0\u5904\u7406\u4e2d\u95f4\u72b6\u6001");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.MIDDLE, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u5904\u7406\u4e2d\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_13", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        logger.error("\u5e94\u6536\u7968\u636e\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a" + outResult);
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a%s\u3002", (String)"ParserReceiableUtil_15", (String)"ebg-note-business", (Object[])new Object[0]), outResult));
    }

    private static List<NoteReceivableInfo> getInnerResult(List<NoteReceivableInfo> receivableInfos, String rspStr) throws Exception {
        if (receivableInfos.get(0).getBankBatchCount() == 1 || !ParseUtil.isBatchParser()) {
            logger.info("\u6279\u6b21\u5904\u7406\u4ea4\u6613\u7ed3\u679c");
            return ParserReceiableUtil.dealSingle(receivableInfos, rspStr);
        }
        logger.info("\u660e\u7ec6\u5904\u7406\u4ea4\u6613\u7ed3\u679c");
        return ParserReceiableUtil.dealBatch(receivableInfos, rspStr);
    }

    private static List<NoteReceivableInfo> dealBatch(List<NoteReceivableInfo> receivableInfos, String rspStr) throws Exception {
        logger.info("\u4f4e\u4ee3\u7801\u5e73\u53f0\u6279\u91cf\u89e3\u6790\u5f00\u59cb");
        List eachData = ParseUtil.getRepeaterData((String)rspStr);
        Map map = CodeLessUtil.getNeedParam();
        Map mapMatch = CodeLessUtil.getMatchParam();
        for (NoteReceivableInfo noteReceivableInfo : receivableInfos) {
            Boolean isMatch = false;
            Field[] fields = noteReceivableInfo.getClass().getDeclaredFields();
            Map result = ParserToMapUtil.getCommonMap((Field[])fields, (String)"yyyyMMdd", (Object)noteReceivableInfo);
            for (Map each : eachData) {
                if (!ParseUtil.judgeMatch((Map)mapMatch, (Map)each, (Map)result)) continue;
                String inner_code = (String)each.get(map.get("inner_code"));
                String inner_code2 = (String)each.get(map.get("inner_code2"));
                String inner_code3 = (String)each.get(map.get("inner_code3"));
                String msg = (String)each.get(map.get("inner_msg"));
                ResponseCode responseCode = new ResponseCode();
                responseCode.setCode(inner_code + inner_code2);
                responseCode.setMsg(msg);
                String outResult = ParseUtil.getResult(null, (String)inner_code, (String)inner_code2, (String)"NOTE", (String)inner_code3);
                ParserReceiableUtil.dealSingleResult(noteReceivableInfo, outResult, responseCode);
                ParserReceiableUtil.reloadData(noteReceivableInfo, each, map);
                isMatch = true;
                break;
            }
            if (isMatch.booleanValue()) continue;
            EBGNoteReceivableUtils.setPaymentState(noteReceivableInfo, PaymentState.UNKNOWN, "", String.format(ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u7968\u53f7\u4e3a%s\u7684\u4ea4\u6613\u4fe1\u606f", (String)"ParserReceiableUtil_17", (String)"ebg-note-business", (Object[])new Object[0]), noteReceivableInfo.getBillNo()));
        }
        return receivableInfos;
    }

    private static void dealSingleResult(NoteReceivableInfo noteReceivableInfo, String outResult, ResponseCode responseCode) throws Exception {
        if (StringUtils.isEmpty((String)outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u7a7a\uff0c\u7f6e\u4e3a\u4ea4\u6613\u7ed3\u679c\u672a\u77e5," + noteReceivableInfo.getBankDetailSeqId());
            EBGNoteReceivableUtils.setPaymentState(noteReceivableInfo, PaymentState.UNKNOWN, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_9", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return;
        }
        if ("SUCCESS".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u6210\u529f," + noteReceivableInfo.getBankDetailSeqId());
            EBGNoteReceivableUtils.setPaymentState(noteReceivableInfo, PaymentState.SUCCESS, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u6210\u529f\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_11", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
        } else if ("FAIL".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u5931\u8d25," + noteReceivableInfo.getBankDetailSeqId());
            EBGNoteReceivableUtils.setPaymentState(noteReceivableInfo, PaymentState.FAIL, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u5931\u8d25\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_12", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
        } else if ("UNKNOWN".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u672a\u77e5," + noteReceivableInfo.getBankDetailSeqId());
            EBGNoteReceivableUtils.setPaymentState(noteReceivableInfo, PaymentState.UNKNOWN, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_9", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
        } else if ("SUBMITED".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u5904\u7406\u4e2d," + noteReceivableInfo.getBankDetailSeqId());
            EBGNoteReceivableUtils.setPaymentState(noteReceivableInfo, PaymentState.SUBMITED, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u5904\u7406\u4e2d\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_13", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
        } else {
            if ("ERROR".equals(outResult)) {
                logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u5f02\u5e38," + noteReceivableInfo.getBankDetailSeqId());
                EBGNoteReceivableUtils.setPaymentState(noteReceivableInfo, PaymentState.UNKNOWN, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_9", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u4e92\u54cd\u5e94\u7801\u5f02\u5e38%1$s %2$s %3$s\u3002", (String)"ParserReceiableUtil_14", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode(), responseCode.getMsg(), outResult));
            }
            if ("REFUSE".equals(outResult)) {
                logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u62d2\u7edd\u7b7e\u6536");
                EBGNoteReceivableUtils.setPaymentState(noteReceivableInfo, PaymentState.FAIL, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u5931\u8d25\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_12", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
                noteReceivableInfo.setIsRefuse("1");
            } else {
                logger.error("\u5e94\u4ed8\u7968\u636e\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a" + outResult + "," + noteReceivableInfo.getBankDetailSeqId());
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a%s\u3002", (String)"ParserReceiableUtil_16", (String)"ebg-note-business", (Object[])new Object[0]), outResult));
            }
        }
    }

    private static List<NoteReceivableInfo> dealSingle(List<NoteReceivableInfo> receivableInfos, String rspStr) throws Exception {
        ResponseCode responseCode = ParseUtil.getInnerCode((String)rspStr, (String)"NOTE");
        String outResult = responseCode.getResult();
        if (StringUtils.isEmpty((String)outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u7a7a\uff0c\u7f6e\u4e3a\u4ea4\u6613\u7ed3\u679c\u672a\u77e5");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.UNKNOWN, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_9", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        for (NoteReceivableInfo NoteReceivableInfo2 : receivableInfos) {
            ParserReceiableUtil.reloadData(NoteReceivableInfo2, rspStr);
        }
        if ("SUCCESS".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u6210\u529f");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.SUCCESS, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u6210\u529f\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_11", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        if ("FAIL".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u5931\u8d25");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.FAIL, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u5931\u8d25\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_12", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        if ("UNKNOWN".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u672a\u77e5");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.UNKNOWN, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_9", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        if ("SUBMITED".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u4ea4\u6613\u5904\u7406\u4e2d");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.SUBMITED, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u5904\u7406\u4e2d\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_13", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            return receivableInfos;
        }
        if ("ERROR".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u5f02\u5e38");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.UNKNOWN, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_9", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u4e92\u54cd\u5e94\u7801\u5f02\u5e38%1$s %2$s %3$s\u3002", (String)"ParserReceiableUtil_14", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode(), responseCode.getMsg(), outResult));
        }
        if ("REFUSE".equals(outResult)) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u62d2\u7edd\u7b7e\u6536");
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, PaymentState.FAIL, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u5931\u8d25\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"ParserReceiableUtil_12", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode()), responseCode.getMsg());
            for (NoteReceivableInfo info : receivableInfos) {
                info.setIsRefuse("1");
            }
            return receivableInfos;
        }
        logger.error("\u5e94\u6536\u7968\u636e\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a" + outResult);
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a%s\u3002", (String)"ParserReceiableUtil_15", (String)"ebg-note-business", (Object[])new Object[0]), outResult));
    }

    private static NoteReceivableInfo reloadData(NoteReceivableInfo receivableInfo, String rspStr) {
        Map needParam = CodeLessUtil.getNeedParamPath();
        Set set2 = needParam.keySet();
        set2.stream().forEach(key -> {
            if ("bankRefDate".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("bankRefDate")));
                receivableInfo.setBankRefDate(value);
            } else if ("bankRefKey".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("bankRefKey")));
                receivableInfo.setBankRefKey(value);
            } else if ("billNo".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("billNo")));
                receivableInfo.setBillNo(value);
            } else if ("startNo".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("startNo")));
                receivableInfo.setStartNo(value);
            } else if ("endNo".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("endNo")));
                receivableInfo.setEndNo(value);
            } else if ("cirStatus".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("cirStatus")));
                receivableInfo.setCirStatus(value);
            } else if ("noteStatus".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("noteStatus")));
                receivableInfo.setNoteStatus(value);
            } else if ("rqstSerialNo".equalsIgnoreCase((String)key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("rqstserialno")));
                receivableInfo.setRqstserialno(value);
            } else if ("rspSerialNo".equalsIgnoreCase((String)key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("rspserialno")));
                receivableInfo.setRspserialno(value);
            } else if ("reserved1".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("reserved1")));
                receivableInfo.setReserved1(value);
            } else if ("reserved2".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("reserved2")));
                receivableInfo.setReserved2(value);
            } else if ("reserved3".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("reserved3")));
                receivableInfo.setReserved3(value);
            } else if ("subRange".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("subRange")));
                receivableInfo.setSubRange(value);
            } else if ("transferFlag".equals(key)) {
                String value = ParseUtil.getValue((String)rspStr, (String)((String)needParam.get("transferFlag")));
                receivableInfo.setTransferFlag(value);
            }
        });
        return receivableInfo;
    }

    private static NoteReceivableInfo reloadData(NoteReceivableInfo receivableInfo, Map eachData, Map reflect) {
        Set set2 = reflect.keySet();
        set2.stream().forEach(key -> {
            if ("bankRefDate".equals(key)) {
                String value = (String)eachData.get(reflect.get("bankRefDate"));
                receivableInfo.setBankRefDate(value);
            } else if ("bankRefKey".equals(key)) {
                String value = (String)eachData.get(reflect.get("bankRefKey"));
                receivableInfo.setBankRefKey(value);
            } else if ("billNo".equals(key)) {
                String value = (String)eachData.get(reflect.get("billNo"));
                receivableInfo.setBillNo(value);
            } else if ("startNo".equals(key)) {
                String value = (String)eachData.get(reflect.get("startNo"));
                receivableInfo.setStartNo(value);
            } else if ("endNo".equals(key)) {
                String value = (String)eachData.get(reflect.get("endNo"));
                receivableInfo.setEndNo(value);
            } else if ("cirStatus".equals(key)) {
                String value = (String)eachData.get(reflect.get("cirStatus"));
                receivableInfo.setCirStatus(value);
            } else if ("noteStatus".equals(key)) {
                String value = (String)eachData.get(reflect.get("noteStatus"));
                receivableInfo.setNoteStatus(value);
            } else if ("rqstSerialNo".equalsIgnoreCase((String)key)) {
                String value = (String)eachData.get(reflect.get("rqstserialno"));
                receivableInfo.setRqstserialno(value);
            } else if ("rspSerialNo".equalsIgnoreCase((String)key)) {
                String value = (String)eachData.get(reflect.get("rspserialno"));
                receivableInfo.setRspserialno(value);
            } else if ("reserved1".equals(key)) {
                String value = (String)eachData.get(reflect.get("reserved1"));
                receivableInfo.setReserved1(value);
            } else if ("reserved2".equals(key)) {
                String value = (String)eachData.get(reflect.get("reserved2"));
                receivableInfo.setReserved2(value);
            } else if ("reserved3".equals(key)) {
                String value = (String)eachData.get(reflect.get("reserved3"));
                receivableInfo.setReserved3(value);
            } else if ("subRange".equals(key)) {
                String value = (String)eachData.get(reflect.get("subRange"));
                receivableInfo.setSubRange(value);
            } else if ("transferFlag".equals(key)) {
                String value = (String)eachData.get(reflect.get("transferFlag"));
                receivableInfo.setTransferFlag(value);
            }
        });
        return receivableInfo;
    }
}

