/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.fileupload;

import com.alibaba.fastjson.JSONObject;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.properties.ObjectProperties;
import kd.ebg.egf.common.repository.properties.ObjectPropertiesRepository;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class FileServerUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(FileServerUtil.class);

    public static boolean isUseOpenApi() {
        ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();
        ObjectProperties properties = objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("isUseOpenApi", "receipt", "common_business");
        if (properties == null) {
            return false;
        }
        return !Boolean.parseBoolean(properties.getAttrValue());
    }

    public static String uploadFile(String localPath, String fileName) throws FileNotFoundException {
        if (FileServerUtil.isUseOpenApi()) {
            IParameter parameter = EBContext.getContext().getParameter();
            String appId = parameter.getBankParameter("appId");
            String url = parameter.getBankParameter("url") + "attachment/upload.do";
            String uploadedPath = "";
            try {
                String accessToken = FileServerUtil.getAccessToken(FileServerUtil.getAppToken());
                StringBuilder requestUrlBuilder = new StringBuilder();
                requestUrlBuilder.append(url);
                requestUrlBuilder.append("?access_token=");
                requestUrlBuilder.append(accessToken);
                requestUrlBuilder.append("&&appId=").append(appId);
                requestUrlBuilder.append("&&fId=").append("t_receipt_match_bill");
                StringBuilder sb = new StringBuilder();
                sb.append(localPath);
                uploadedPath = FileServerUtil.upload(requestUrlBuilder.toString(), sb.toString(), localPath, fileName);
            }
            catch (Exception e) {
                logger.error("\u4e0a\u4f20\u5931\u8d25-{}-{}", new Object[]{fileName, e.getMessage()});
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            logger.info("\u6587\u4ef6{}\u5df2\u7ecf\u4e0a\u4f20,\u8fd4\u56de\u6587\u4ef6\u540d\uff1a{}", new Object[]{localPath, uploadedPath});
            return uploadedPath;
        }
        FileService fs = FileServiceFactory.getAttachmentFileService();
        FileItem file = new FileItem(fileName, localPath, (InputStream)new FileInputStream(localPath));
        file.setCreateNewFileWhenExists(true);
        String path = fs.upload(file);
        return path;
    }

    private static String getAppToken() {
        String appToken;
        block18: {
            IParameter parameter = EBContext.getContext().getParameter();
            String appId = parameter.getBankParameter("appId");
            String url = parameter.getBankParameter("url") + "api/getAppToken.do";
            String appSecuret = parameter.getBankParameter("appSecuret");
            String accountId = parameter.getBankParameter("accountId");
            String appTokenKey = accountId + appId + "app_token";
            try {
                appToken = CosmicCache.get((String)appTokenKey);
                if (!StringUtils.isEmpty((String)appToken)) break block18;
                try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                    HttpPost httpPost = new HttpPost(url);
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("appId", (Object)appId);
                    jsonObject.put("appSecuret", (Object)appSecuret);
                    jsonObject.put("accountId", (Object)accountId);
                    StringEntity entity = new StringEntity(jsonObject.toString());
                    entity.setContentEncoding("utf-8");
                    entity.setContentType("application/json");
                    httpPost.setEntity((HttpEntity)entity);
                    logger.info("\u53d1\u9001\u8bf7\u6c42\u83b7\u53d6AppToken-\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonObject.toJSONString());
                    logger.info("\u53d1\u9001\u8bf7\u6c42\u83b7\u53d6AppToken\uff1a" + httpPost.getURI());
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                    String result = EntityUtils.toString((HttpEntity)response.getEntity());
                    logger.info("\u83b7\u53d6AppToken\u54cd\u5e94\u62a5\u6587\uff1a" + result);
                    JSONObject responseJson = JSONObject.parseObject((String)result);
                    JSONObject data = (JSONObject)responseJson.get((Object)"data");
                    if (data != null) {
                        appToken = data.get((Object)"app_token").toString();
                        CosmicCache.cosmicCache.put(appTokenKey, (Object)appToken, 60);
                        if (StringUtils.isEmpty((String)appToken)) {
                            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"FileServerUtil_6", (String)"ebg-note-business", (Object[])new Object[0]), result));
                        }
                        break block18;
                    }
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u62a5\u6587\u6ca1data\u6570\u636e%s\u3002", (String)"FileServerUtil_7", (String)"ebg-note-business", (Object[])new Object[0]), responseJson));
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6apptoken-\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a{}", new Object[]{e.getMessage()});
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a", (String)"FileServerUtil_0", (String)"ebg-note-business", (Object[])new Object[0]), (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6apptoken\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        return appToken;
    }

    private static String getAccessToken(String appToken) {
        String accessToken;
        block19: {
            IParameter parameter = EBContext.getContext().getParameter();
            String appId = parameter.getBankParameter("appId");
            String url = parameter.getBankParameter("url") + "api/login.do";
            String appSecuret = parameter.getBankParameter("appSecuret");
            String accountId = parameter.getBankParameter("accountId");
            String user = parameter.getBankParameter("user");
            if (StringUtils.isEmpty((String)appToken)) {
                FileServerUtil.getAppToken();
            }
            String accessTokenKey = accountId + appId + "access_token";
            try {
                accessToken = CosmicCache.get((String)accessTokenKey);
                if (!StringUtils.isEmpty((String)accessToken)) break block19;
                try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                    HttpPost httpPost = new HttpPost(url);
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("user", (Object)user);
                    jsonObject.put("apptoken", (Object)appToken);
                    jsonObject.put("accountId", (Object)accountId);
                    StringEntity entity = new StringEntity(jsonObject.toString());
                    entity.setContentEncoding("utf-8");
                    entity.setContentType("application/json");
                    httpPost.setEntity((HttpEntity)entity);
                    logger.info("\u53d1\u9001\u8bf7\u6c42\u83b7\u53d6AccessToken-\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonObject.toJSONString());
                    logger.info("\u53d1\u9001\u8bf7\u6c42\u83b7\u53d6AccessToken\uff1a" + httpPost.getURI());
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                    String result = EntityUtils.toString((HttpEntity)response.getEntity());
                    logger.info("\u83b7\u53d6AccessToken\u54cd\u5e94\u62a5\u6587\uff1a" + result);
                    JSONObject responseJson = JSONObject.parseObject((String)result);
                    JSONObject data = (JSONObject)responseJson.get((Object)"data");
                    if (data != null) {
                        accessToken = data.get((Object)"access_token").toString();
                        CosmicCache.cosmicCache.put(accessTokenKey, (Object)accessToken, 1800);
                        if (StringUtils.isEmpty((String)accessToken)) {
                            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"FileServerUtil_6", (String)"ebg-note-business", (Object[])new Object[0]), result));
                        }
                        break block19;
                    }
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u62a5\u6587\u6ca1data\u6570\u636e%s\u3002", (String)"FileServerUtil_7", (String)"ebg-note-business", (Object[])new Object[0]), result));
                }
                catch (Exception e) {
                    logger.error("getAccessToken-\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a{}", new Object[]{e.getMessage()});
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a", (String)"FileServerUtil_0", (String)"ebg-note-business", (Object[])new Object[0]), (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6accesstoken\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        return accessToken;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String upload(String requestUrl, String path, String localFilePath, String fileName) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String uploadedPath = null;
            HttpPost httpPost = new HttpPost(requestUrl);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody("file", FileCommonUtils.getFileByPath((String)localFilePath), ContentType.MULTIPART_FORM_DATA, fileName);
            ContentType contentType = ContentType.create((String)"multipart/form-data", (Charset)Charset.forName("UTF-8"));
            builder.addTextBody("url", path, contentType);
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String responseStr = EntityUtils.toString((HttpEntity)responseEntity);
            if (!StringUtils.isEmpty((String)responseStr)) {
                logger.info("\u4e0a\u4f20\u6587\u4ef6\u54cd\u5e94\u62a5\u6587\uff1a" + responseStr);
                JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
                if ("success".equals(jsonObject.get((Object)"status").toString())) {
                    uploadedPath = jsonObject.get((Object)"url").toString();
                    String string = uploadedPath;
                    return string;
                }
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6:%1$s\u4e0a\u4f20\u5931\u8d25,\u82cd\u7a79\u8fd4\u56de\u62a5\u6587:%2$s", (String)"FileServerUtil_8", (String)"ebg-note-business", (Object[])new Object[0]), path, jsonObject.toJSONString()));
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6:%1$s\u4e0a\u4f20\u5931\u8d25,\u82cd\u7a79\u672a\u8fd4\u56de\u6570\u636e", (String)"FileServerUtil_9", (String)"ebg-note-business", (Object[])new Object[0]), path));
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a", (String)"FileServerUtil_5", (String)"ebg-note-business", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

