/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.noteinfo;

import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.note.business.noteinfo.atomic.INoteInfo;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoBody;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoRequest;
import kd.ebg.note.business.noteinfo.bank.EBBankNoteInfoResponse;
import kd.ebg.note.business.util.AccessUtils;
import kd.ebg.note.common.entity.biz.noteinfo.DetailResponseBody;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoDetail;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoRequest;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoResponse;
import kd.ebg.note.common.framework.frame.BankBundleManager;
import org.slf4j.MDC;

public class QueryNoteInfoMethod
implements EBServiceMethod<NoteInfoRequest, NoteInfoResponse> {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(QueryNoteInfoMethod.class);

    public NoteInfoResponse executeClientRequest(NoteInfoRequest request, EBContext context) throws MalformedURLException {
        AccessUtils.checkQueryAllowed(context);
        EBContext.initParameter();
        FEPAccess access = null;
        INoteInfo noteInfo = (INoteInfo)BankBundleManager.getInstance().getImpl(EBContext.getContext().getBankAcnt().getBankVersionId(), INoteInfo.class, (Object)request);
        int size = noteInfo.getBatchSize();
        List list = request.getBody().getDetails();
        List partition = Lists.partition((List)list, (int)size);
        ArrayList<NoteInfoDetail> responseList = new ArrayList<NoteInfoDetail>();
        EBBankNoteInfoResponse response = null;
        try {
            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
            access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
            for (List noteInfoDetails : partition) {
                response = noteInfo.noteInfo(this.buildRequest(context.getAcnt(), request, noteInfoDetails));
                responseList.addAll(response.getBody().getDetails());
            }
        }
        catch (Throwable e) {
            try {
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                log.error(EBExceiptionUtil.stackTraceString((StackTraceElement[])e.getStackTrace()));
                throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002", (String)"QueryNoteInfoMethod_0", (String)"ebg-note-business", (Object[])new Object[0]), (Throwable)e);
            }
            catch (Throwable throwable) {
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                FEPAccessUtil.release(access);
                throw throwable;
            }
        }
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        FEPAccessUtil.release((FEPAccess)access);
        if (response != null) {
            return this.buildResponse(response, responseList);
        }
        throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002", (String)"QueryNoteInfoMethod_0", (String)"ebg-note-business", (Object[])new Object[0]));
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "queryNoteInfo";
    }

    private BankNoteInfoRequest buildRequest(BankAcnt acnt, NoteInfoRequest noteInfoRequest, List<NoteInfoDetail> infoDetails) {
        BankNoteInfoRequest request = new BankNoteInfoRequest();
        BankHeader header = new BankHeader();
        BankNoteInfoBody body = new BankNoteInfoBody();
        request.setHeader(header);
        request.setBody(body);
        header.setAcnt(acnt);
        header.setBizType(noteInfoRequest.getHeader().getBizType());
        header.setSubBizType(noteInfoRequest.getHeader().getSubBizType());
        header.setClientName(noteInfoRequest.getHeader().getClientName());
        header.setClientVersion(noteInfoRequest.getHeader().getClientVersion());
        header.setExtData(noteInfoRequest.getHeader().getExtData());
        header.setBankVersionID(acnt.getBankVersionId());
        header.setBankLoginID(acnt.getBankLoginId());
        header.setBizSeqID(noteInfoRequest.getHeader().getLogBizSeqID());
        header.setCustomerID(noteInfoRequest.getHeader().getCustomId());
        request.getBody().setTotalCount(noteInfoRequest.getBody().getTotalCount());
        request.getBody().setIsNewECDS(noteInfoRequest.getBody().getIsNewECDS());
        request.getBody().setBatchSeqId(noteInfoRequest.getBody().getBatchSeqId());
        request.getBody().setDetails(infoDetails);
        return request;
    }

    private NoteInfoResponse buildResponse(EBBankNoteInfoResponse ebBankNoteInfoResponse, List<NoteInfoDetail> infoDetails) {
        NoteInfoResponse response = new NoteInfoResponse();
        DetailResponseBody body = new DetailResponseBody();
        response.setBody(body);
        body.setTotalCount(ebBankNoteInfoResponse.getBody().getTotalCount());
        body.setIsNewECDS(ebBankNoteInfoResponse.getBody().getIsNewECDS());
        body.setBatchSeqId(ebBankNoteInfoResponse.getBody().getBatchSeqId());
        body.setDetails(infoDetails);
        return response;
    }
}

