/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class EBThreadPools {
    private static final String EB = "eb";
    private static final Map<String, ThreadPool> payThreadPools = new ConcurrentHashMap<String, ThreadPool>(50);
    private static final Map<String, ThreadPool> queryPayThreadPools = new ConcurrentHashMap<String, ThreadPool>(50);

    private static String getParentKey(String customId, String bankLoginId, String type) {
        String accountId = RequestContext.get().getAccountId();
        StringBuilder sb = new StringBuilder();
        sb.append(EB);
        sb.append('_');
        sb.append(customId);
        sb.append('_');
        sb.append(accountId);
        sb.append('_');
        sb.append(bankLoginId);
        sb.append('_');
        sb.append(type);
        return sb.toString();
    }

    public static ThreadPool getNoteReceivable(String customID, String bankLoginId) {
        String key = EBThreadPools.getParentKey(customID, bankLoginId, "note");
        if (!payThreadPools.containsKey(key)) {
            try {
                ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"note");
                payThreadPools.put(key, pool);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return payThreadPools.get(key);
    }

    public static ThreadPool getQueryNoteReceivable(String customID, String bankLoginId) {
        String key = EBThreadPools.getParentKey(customID, bankLoginId, "queryNote");
        if (!queryPayThreadPools.containsKey(key)) {
            ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"note");
            queryPayThreadPools.put(key, pool);
        }
        return queryPayThreadPools.get(key);
    }

    public static ThreadPool getNotePayable(String customID, String bankLoginId) {
        String key = EBThreadPools.getParentKey(customID, bankLoginId, "notePayable");
        if (!payThreadPools.containsKey(key)) {
            try {
                ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"note");
                payThreadPools.put(key, pool);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return payThreadPools.get(key);
    }

    public static ThreadPool getQueryNotePayable(String customID, String bankLoginId) {
        String key = EBThreadPools.getParentKey(customID, bankLoginId, "queryNotePayable");
        if (!queryPayThreadPools.containsKey(key)) {
            ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"note");
            queryPayThreadPools.put(key, pool);
        }
        return queryPayThreadPools.get(key);
    }
}

