/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services;

import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.Common;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CIB_DC_Notepc_QueryPayPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CIB_DC_Notepc_QueryPayPacker.class);
    private static final String[] billTypes = new String[]{"03", "05", "07", "16", "17", "18"};

    public static String packQueryPay(List<NotePayableInfo> notePayableInfos, String operationCode) {
        NotePayableInfo info = notePayableInfos.get(0);
        String businessType = CIB_DC_Notepc_QueryPayPacker.convertBusType(info.getOperationCode(), logger);
        String billCode = null;
        if (notePayableInfos.size() == 1) {
            billCode = info.getBillNo();
        }
        Date dtStart = null;
        Date dtEnd = null;
        for (NotePayableInfo notePayableInfo : notePayableInfos) {
            LocalDateTime nowLocal = notePayableInfo.getSubmitSuccessTime();
            Date date = Date.from(nowLocal.atZone(ZoneId.systemDefault()).toInstant());
            if (date == null) {
                logger.info("SubmitSuccessTime\u4e3anull");
                continue;
            }
            if (dtStart == null || dtStart.getTime() > date.getTime()) {
                dtStart = date;
            }
            if (dtEnd != null && dtEnd.getTime() >= date.getTime()) continue;
            dtEnd = date;
        }
        String stStart = dtStart == null ? "" : DateTimeUtils.format(dtStart, (String)"yyyy-MM-dd");
        String stEnd = dtEnd == null ? "" : DateTimeUtils.format(dtEnd, (String)"yyyy-MM-dd");
        Element cms = CIB_DC_Notepc_QueryPayPacker.createMsg("01", info.getDrawerAccNo(), billCode, stStart, stEnd, operationCode, info.getDraftType());
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        logger.info("\u5e94\u4ed8\u7968\u636e\u72b6\u6001\u540c\u6b65\u62a5\u6587\uff1a" + str);
        return str;
    }

    public static String QueryNoteReceivableStatusPacker(List<NoteReceivableInfo> receivableInfos, String operationCode, String operType) {
        NoteReceivableInfo info = receivableInfos.get(0);
        String billCode = null;
        if (receivableInfos.size() == 1) {
            billCode = info.getBillNo();
        }
        String businessType = CIB_DC_Notepc_QueryPayPacker.convertBusType(info.getOperationCode(), logger);
        LocalDateTime nowLocal = info.getSubmitSuccessTime();
        Date submitSuccessTime = Date.from(nowLocal.atZone(ZoneId.systemDefault()).toInstant());
        String seqrchDate = DateTimeUtils.format((Date)submitSuccessTime, (String)"yyyy-MM-dd");
        Element cms = CIB_DC_Notepc_QueryPayPacker.createMsg(operType, info.getDrawerAccNo(), billCode, seqrchDate, seqrchDate, operationCode, info.getDraftType());
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        logger.info("\u5e94\u6536\u7968\u636e\u72b6\u6001\u540c\u6b65\u62a5\u6587\uff1a" + str);
        return str;
    }

    private static Element createMsg(String operType, String acctId, String billCode, String dtStart, String dtEnd, String businessType, String billType) {
        if (StringUtils.isEmpty((String)operType) || StringUtils.isEmpty((String)acctId) || StringUtils.isEmpty((String)businessType) || StringUtils.isEmpty((String)billType)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001\u540c\u6b65\u8bf7\u6c42\u53c2\u6570\u6709\u8bef\uff1aoperType=%1$s,acctId=%2$s,businessType=%3$s,billType=%4$S", (String)"CIB_DC_Notepc_QueryPayPacker_2", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), operType, acctId, businessType, billType));
        }
        if (StringUtils.isEmpty((String)billCode) && (StringUtils.isEmpty((String)dtStart) || StringUtils.isEmpty((String)dtEnd))) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001\u540c\u6b65\u8bf7\u6c42\u53c2\u6570\u6709\u8bef\uff1abillCode=%1$s\uff0cdtStart=%2$s\uff0cdtEnd=%3$s\u3002", (String)"CIB_DC_Notepc_QueryPayPacker_3", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), billCode, dtStart, dtEnd));
        }
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBSTMTQUERYTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"EBSTMTQUERYTRNRQ");
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        JDomUtils.addChild((Element)EBSTMTQUERYTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBSTMTQUERYTRNRQ_RQBODY = JDomUtils.addChildAttribute((Element)EBSTMTQUERYTRNRQ, (String)"RQBODY", (String)"PAGE", (String)"1");
        JDomUtils.addChild((Element)EBSTMTQUERYTRNRQ_RQBODY, (String)"OPERTYPE", (String)operType);
        JDomUtils.addChild((Element)EBSTMTQUERYTRNRQ_RQBODY, (String)"ACCTID", (String)acctId);
        JDomUtils.addChild((Element)EBSTMTQUERYTRNRQ_RQBODY, (String)"BUSINESSTYPE", (String)businessType);
        JDomUtils.addChild((Element)EBSTMTQUERYTRNRQ_RQBODY, (String)"BILLTYPE", (String)billType);
        if (!StringUtils.isEmpty((String)billCode)) {
            JDomUtils.addChild((Element)EBSTMTQUERYTRNRQ_RQBODY, (String)"BILLCODE", (String)billCode);
        }
        JDomUtils.addChild((Element)EBSTMTQUERYTRNRQ_RQBODY, (String)"DTSTART", (String)dtStart);
        JDomUtils.addChild((Element)EBSTMTQUERYTRNRQ_RQBODY, (String)"DTEND", (String)dtEnd);
        return cms;
    }

    private static String convertBusType(String operationCode, EBGLogger logger) {
        logger.info("\u7968\u636e\u72b6\u6001\u540c\u6b65\u62a5\u6587\u64cd\u4f5c\u7f16\u7801\uff1a" + operationCode);
        HashMap<String, String> busType = new HashMap<String, String>(){
            {
                this.put("02", "03");
                this.put("03", "05");
                this.put("10", "07");
                this.put("18", "15");
                this.put("20", "17");
                this.put("12", "09");
                this.put("17", "98");
                this.put("25", "18");
                this.put("19", "16");
            }
        };
        return (String)busType.get(operationCode);
    }

    public static String packQueryPay2(List<NotePayableInfo> notePayableInfos) {
        NotePayableInfo info = notePayableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBBATCHSTATUSTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"EBBATCHSTATUSTRNRQ");
        JDomUtils.addChild((Element)EBBATCHSTATUSTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBBATCHSTATUSTRNRQ_RQBODY = JDomUtils.addChildAttribute((Element)EBBATCHSTATUSTRNRQ, (String)"RQBODY", (String)"PAGE", (String)"1");
        JDomUtils.addChild((Element)EBBATCHSTATUSTRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)EBBATCHSTATUSTRNRQ_RQBODY, (String)"CLIENTREF", (String)info.getRqstserialno());
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        logger.info("\u5e94\u4ed8\u7968\u636e\u72b6\u6001\u540c\u6b65\u62a5\u6587\uff1a" + str);
        return str;
    }

    public static String QueryNoteReceivableStatusPacker2(List<NoteReceivableInfo> receivableInfos) {
        NoteReceivableInfo info = receivableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBBATCHSTATUSTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"EBBATCHSTATUSTRNRQ");
        JDomUtils.addChild((Element)EBBATCHSTATUSTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBBATCHSTATUSTRNRQ_RQBODY = JDomUtils.addChildAttribute((Element)EBBATCHSTATUSTRNRQ, (String)"RQBODY", (String)"PAGE", (String)"1");
        JDomUtils.addChild((Element)EBBATCHSTATUSTRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)EBBATCHSTATUSTRNRQ_RQBODY, (String)"CLIENTREF", (String)info.getRqstserialno());
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        logger.info("\u5e94\u4ed8\u7968\u636e\u72b6\u6001\u540c\u6b65\u62a5\u6587\uff1a" + str);
        return str;
    }

    private static Map<String, String> getStartAndEndDate(String operationCode, String operType, List<NoteReceivableInfo> receivableInfos) {
        HashMap<String, String> map = new HashMap<String, String>();
        Date dtStart = null;
        Date dtEnd = null;
        boolean isExist = Arrays.asList(billTypes).contains(operationCode) && "02".equals(operType);
        for (NoteReceivableInfo noteReceivableInfo : receivableInfos) {
            LocalDateTime nowLocal = noteReceivableInfo.getSubmitSuccessTime();
            Date submitSuccessTime = Date.from(nowLocal.atZone(ZoneId.systemDefault()).toInstant());
            LocalDate issue = receivableInfos.get(0).getDueDate();
            Date IssueDate = Date.from(issue.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            Date appDate = null;
            try {
                Date date;
                if (isExist) {
                    String appDateStr = Common.appDateMap.get(noteReceivableInfo.getBillNo());
                    if (appDateStr == null) {
                        appDateStr = Common.findAppDate(noteReceivableInfo.getBillNo());
                    }
                    appDate = appDateStr == null ? IssueDate : DateTimeUtils.parseDate((String)appDateStr, (String)"yyyy-MM-dd");
                    logger.info("\u7b7e\u6536\u64cd\u4f5c-\u83b7\u53d6\u5f00\u59cb\u548c\u622a\u6b62\u65f6\u95f4\uff1a\u4e1a\u52a1\u65f6\u95f4" + appDateStr + ",\u51fa\u7968\u65f6\u95f4\uff1a" + noteReceivableInfo.getIssueDate() + "\uff0c\u53d6\u503c" + appDate);
                }
                if ((date = isExist ? appDate : submitSuccessTime) == null || submitSuccessTime == null) continue;
                if (dtStart == null || dtStart.getTime() > date.getTime()) {
                    dtStart = date;
                }
                if (dtEnd != null && dtEnd.getTime() >= submitSuccessTime.getTime()) continue;
                dtEnd = submitSuccessTime;
            }
            catch (ParseException e) {
                logger.info("\u83b7\u53d6\u5f00\u59cb\u548c\u622a\u6b62\u65f6\u95f4\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        map.put("stStart", dtStart == null ? "" : DateTimeUtils.format(dtStart, (String)"yyyy-MM-dd"));
        map.put("stEnd", dtEnd == null ? "" : DateTimeUtils.format(dtEnd, (String)"yyyy-MM-dd"));
        return map;
    }
}

