/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.payable;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.BankBusinessConfig;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryNotePayableImpl
extends AbstractQueryNotePayableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryNotePayableImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "EBBATCHSTATUSTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u6279\u91cf\u72b6\u6001\u67e5\u8be2-\u5e94\u4ed8\u7968\u636e", (String)"QueryNotePayableImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        String type;
        List notePayableInfos = bankNotePayableRequest.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBBATCHSTATUSTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBBIZPROCESSSTSQUERYTRNRQ");
        JDomUtils.addChild((Element)EBBATCHSTATUSTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBBATCHSTATUSTRNRQ_RQBODY = JDomUtils.addChildAttribute((Element)EBBATCHSTATUSTRNRQ, (String)"RQBODY", (String)"PAGE", (String)"1");
        EBBATCHSTATUSTRNRQ_RQBODY.setAttribute("SIZE", "100");
        switch (bankNotePayableRequest.getHeader().getSubBizType()) {
            case "remit_accept": {
                type = "BC02";
                break;
            }
            case "remit_cancle": {
                type = "SD91";
                break;
            }
            case "remit_receive": {
                type = "BC03";
                break;
            }
            case "remit_register": {
                type = "BC01";
                break;
            }
            case "remit_revocation": {
                type = "BC19";
                break;
            }
            default: {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5f53\u524d\u5b50\u4e1a\u52a1\u7c7b\u578b\u67e5\u8be2%s", (String)"QueryNotePayableImpl_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), bankNotePayableRequest.getHeader().getSubBizType()));
            }
        }
        JDomUtils.addChild((Element)EBBATCHSTATUSTRNRQ_RQBODY, (String)"BIZTYPE", (String)type);
        JDomUtils.addChild((Element)EBBATCHSTATUSTRNRQ_RQBODY, (String)"CLIENTREF", (String)info.getReserved1());
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String rspStr) {
        List payableInfos = bankNotePayableRequest.getNotePayableInfoList();
        HashMap<String, String> unknow = new HashMap<String, String>(){
            {
                this.put("3000", ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25-\u8fbe\u5230\u670d\u52a1\u6700\u5927\u9650\u5236", (String)"QueryNotePayableImpl_2", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                this.put("4000", ResManager.loadKDString((String)"\u8fd0\u884c\u65f6\u9519\u8bef", (String)"QueryNotePayableImpl_3", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            }
        };
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBBATCHSTATUSTRNRS = eb1.getChild("NEWEBBIZPROCESSSTSQUERYTRNRS");
        Element STATUS = EBBATCHSTATUSTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        this.logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        if (!"0".equals(code)) {
            if (!StringUtils.isEmpty((String)((String)unknow.get(code)))) {
                EBGNotePayableUtils.setPaymentState((List)payableInfos, (PaymentState)PaymentState.UNKNOWN, (String)code, (String)MESSAGE);
                return payableInfos;
            }
            EBGNotePayableUtils.setPaymentState((List)payableInfos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
            return payableInfos;
        }
        Element RSBODY = EBBATCHSTATUSTRNRS.getChild("RSBODY");
        List list = RSBODY.getChildren("CONTENT");
        NotePayableInfo info = (NotePayableInfo)payableInfos.get(0);
        for (Element rs : list) {
            String rsBillNo = rs.getChildText("DRAFTNO");
            if (!rsBillNo.equals(info.getBillNo())) continue;
            String DRAFTRANGE = rs.getChildText("DRAFTRANGE");
            info.setSubRange(DRAFTRANGE);
            String BILLSTATUS = rs.getChildText("DRAFTSTATUS");
            String TRANSFLAG = rs.getChildText("TRANSFLAG");
            info.setKeepFlag(TRANSFLAG);
            info.setCirStatus(TRANSFLAG);
            String RSLTMSG = rs.getChildText("RSPREMARK");
            info.setBillNo(rsBillNo);
            info.setNoteStatus(BILLSTATUS);
            String CPEBIZPRCSTS = rs.getChildText("CPEBIZPRCSTS");
            this.logger.info("rsBillNo:" + rsBillNo + ",\u4e1a\u52a1\u72b6\u6001\uff1a" + CPEBIZPRCSTS + "BILLSTATUS:" + BILLSTATUS + ",\u6d41\u901a\u72b6\u6001\uff1a" + TRANSFLAG);
            String subBizType = bankNotePayableRequest.getHeader().getSubBizType();
            if ("remit_accept".equals(subBizType) || "remit_receive".equals(subBizType)) {
                this.parseAccept(payableInfos, CPEBIZPRCSTS, RSLTMSG);
                continue;
            }
            this.parseOther(payableInfos, CPEBIZPRCSTS, RSLTMSG);
        }
        return payableInfos;
    }

    private void parseAccept(List<NotePayableInfo> payableInfos, String CPEBIZPRCSTS, String RSLTMSG) {
        NotePayableInfo info = payableInfos.get(0);
        if (BankBusinessConfig.isOnlineRegister()) {
            if ("0201".equals(CPEBIZPRCSTS) || "0202".equals(CPEBIZPRCSTS) || "0301".equals(CPEBIZPRCSTS) || "0101".equals(CPEBIZPRCSTS)) {
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)CPEBIZPRCSTS, (String)RSLTMSG);
            } else {
                EBGNotePayableUtils.setPaymentState(payableInfos, (PaymentState)PaymentState.UNKNOWN, (String)CPEBIZPRCSTS, (String)RSLTMSG);
            }
        } else if ("S01".equals(CPEBIZPRCSTS) || "R02".equals(CPEBIZPRCSTS) || "R03".equals(CPEBIZPRCSTS)) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else if ("S03".equals(CPEBIZPRCSTS) || "S05".equals(CPEBIZPRCSTS) || "S07".equals(CPEBIZPRCSTS) || "R06".equals(CPEBIZPRCSTS) || "R08".equals(CPEBIZPRCSTS) || "R10".equals(CPEBIZPRCSTS) || "R12".equals(CPEBIZPRCSTS)) {
            EBGNotePayableUtils.setPaymentState(payableInfos, (PaymentState)PaymentState.FAIL, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else if ("S04".equals(CPEBIZPRCSTS)) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else {
            EBGNotePayableUtils.setPaymentState(payableInfos, (PaymentState)PaymentState.UNKNOWN, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        }
    }

    private void parseOther(List<NotePayableInfo> notePayableInfos, String CPEBIZPRCSTS, String RSLTMSG) {
        NotePayableInfo info = notePayableInfos.get(0);
        if (BankBusinessConfig.isOnlineRegister()) {
            if ("0201".equals(CPEBIZPRCSTS) || "0202".equals(CPEBIZPRCSTS) || "0301".equals(CPEBIZPRCSTS) || "0101".equals(CPEBIZPRCSTS)) {
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)CPEBIZPRCSTS, (String)RSLTMSG);
            } else {
                EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)CPEBIZPRCSTS, (String)RSLTMSG);
            }
        } else if ("S01".equals(CPEBIZPRCSTS) || "R02".equals(CPEBIZPRCSTS) || "R03".equals(CPEBIZPRCSTS)) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else if ("S03".equals(CPEBIZPRCSTS) || "S05".equals(CPEBIZPRCSTS) || "S07".equals(CPEBIZPRCSTS) || "R06".equals(CPEBIZPRCSTS) || "R08".equals(CPEBIZPRCSTS) || "R10".equals(CPEBIZPRCSTS) || "R12".equals(CPEBIZPRCSTS)) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.FAIL, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else if ("S02".equals(CPEBIZPRCSTS) || "S06".equals(CPEBIZPRCSTS) || "R05".equals(CPEBIZPRCSTS) || "R09".equals(CPEBIZPRCSTS)) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        }
    }

    public int getBatchSize() {
        return 0;
    }
}

