/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.payable.confirm.querydrawfin;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class NoteStatusQuery {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(NoteStatusQuery.class);

    public void query(NotePayableInfo notePayableInfo) {
        try {
            String rqstStr = this.packNoteInfoRequest(notePayableInfo);
            this.logger.info("\u5411\u94f6\u884c\u53d1\u9001\u62a5\u6587\uff1a" + rqstStr);
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            String encoding = RequestContextUtils.getCharset();
            factory.setHttpHeader("content-type", "text/xml; charset=" + encoding);
            IConnection conn = factory.createExchangeConnection();
            conn.openConnection();
            OutputStream os = conn.getOutputStream();
            IOUtils.sendFully((OutputStream)os, (String)rqstStr);
            IOUtils.closeOutputStreamQuietly((OutputStream)os);
            InputStream is = conn.getInputStream();
            String rspStr = IOUtils.readFully((InputStream)is);
            this.logger.info("\u63a5\u6536\u94f6\u884c\u8bf7\u6c42\uff1a" + rqstStr);
            this.parserNoteInfoResponse(rspStr, notePayableInfo);
            IOUtils.closeInputStreamQuietly((InputStream)is);
            conn.closeConnection();
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String packNoteInfoRequest(NotePayableInfo notePayableInfo) {
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element QUERYDRAWFINDTLTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBFACEQUERYTRNRQ");
        JDomUtils.addChild((Element)QUERYDRAWFINDTLTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element body = JDomUtils.addChildAttribute((Element)QUERYDRAWFINDTLTRNRQ, (String)"RQBODY", (String)"PAGE", (String)"1");
        JDomUtils.addChild((Element)body, (String)"VERSION", (String)"2.0");
        JDomUtils.addChild((Element)body, (String)"OPERATEFLAG", (String)"1");
        JDomUtils.addChild((Element)body, (String)"ACCTID", (String)notePayableInfo.getDrawerAccNo());
        JDomUtils.addChild((Element)body, (String)"DRAFTNO", (String)notePayableInfo.getBillNo());
        JDomUtils.addChild((Element)body, (String)"DRAFTRANGE", (String)notePayableInfo.getSubRange());
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public void parserNoteInfoResponse(String rspStr, NotePayableInfo notePayableInfo) {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element SECURITIES_MSGSRSV1 = root.getChild("SECURITIES_MSGSRSV1");
        Element NEWEBFACEQUERYTRNRS = SECURITIES_MSGSRSV1.getChild("NEWEBFACEQUERYTRNRS");
        Element STATUS = NEWEBFACEQUERYTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            throw EBExceiptionUtil.serviceException((String)MESSAGE);
        }
        Element RSBODY = NEWEBFACEQUERYTRNRS.getChild("RSBODY");
        String DRAFTSTATUS = JDomUtils.getChildText((Element)RSBODY, (String)"DRAFTSTATUS");
        String TRANSFLAG = JDomUtils.getChildText((Element)RSBODY, (String)"TRANSFLAG");
        notePayableInfo.setNoteStatus(DRAFTSTATUS);
        notePayableInfo.setCirStatus(TRANSFLAG);
    }
}

