/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.payable.confirm.querydrawfin;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.newnote.NoteHandlerHelper;
import kd.ebg.note.banks.cib.dc.services.newnote.payable.confirm.querydrawfin.NoteStatusQuery;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.banks.cib.dc.services.util.Util;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryDrawfinDtailParser {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryDrawfinDtailParser.class);

    public void parserNoteInfoResponse(NotePayableInfo[] notePayableInfos, String rspStr) {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element SECURITIES_MSGSRSV1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBSIGNQUERYTRNRS = SECURITIES_MSGSRSV1.getChild("NEWEBQUERYDRAWFINDTLTRNRS");
        Element STATUS = EBSIGNQUERYTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            throw EBExceiptionUtil.serviceException((String)MESSAGE);
        }
        Element RSBODY = EBSIGNQUERYTRNRS.getChild("RSBODY");
        String applyStatus = JDomUtils.getChildText((Element)RSBODY, (String)"APPLYSTATUS");
        String returnReason = JDomUtils.getChildText((Element)RSBODY, (String)"RETURNREASON");
        String applyStatusName = JDomUtils.getChildText((Element)RSBODY, (String)"APPLYSTATUSNAME");
        String[] subCode = new String[]{"YT", "YF"};
        String[] unknownCode = new String[]{"TH"};
        List contentList = RSBODY.getChildren("CONTENT");
        this.logger.info("******contentList\u5927\u5c0f\uff1a" + contentList.size());
        HashMap notePayableInfoMap = Maps.newHashMapWithExpectedSize((int)notePayableInfos.length);
        for (NotePayableInfo info : notePayableInfos) {
            notePayableInfoMap.put(Util.getFileName(info.getReserved4(), "clientref").split("_")[1], info);
            this.logger.info("******\uff1a" + Util.getFileName(info.getReserved4(), "clientref").split("_")[1]);
        }
        for (Element content : contentList) {
            String billCode = content.getChildText("DRAFTNO");
            String DRAFTRANGE = content.getChildText("DRAFTRANGE");
            String DRAFTSTATUS = content.getChildText("DRAFTSTATUS");
            String billStatus = content.getChildText("CIBDRAFTSTATUS");
            String indx = content.getChildText("INDEX");
            this.logger.info("******\u5728\u7ebf\u878d\u8d44\u51fa\u7968\u540c\u6b65-\u878d\u8d44\u7533\u8bf7\u8be6\u60c5\u67e5\u8be2:\u5e8f\u53f7\uff1a" + indx);
            NotePayableInfo info = (NotePayableInfo)notePayableInfoMap.get(indx);
            if (info == null) continue;
            info.setBillNo(billCode);
            info.setNoteStatus(DRAFTSTATUS);
            info.setSubRange(DRAFTRANGE);
            info.setStartNo(NoteHandlerHelper.getStartNo(DRAFTRANGE, ","));
            info.setEndNo(NoteHandlerHelper.getEndNo(DRAFTRANGE, ","));
            this.logger.info("******\u5728\u7ebf\u878d\u8d44\u51fa\u7968\u540c\u6b65-\u878d\u8d44\u7533\u8bf7\u8be6\u60c5\u67e5\u8be2:\u7968\u636e\u53f7\uff1a" + billCode + ",\u72b6\u6001\uff1a" + billStatus);
            PaymentState noteState = null;
            if (Collections.singletonList(subCode).contains(applyStatus)) {
                noteState = PaymentState.SUBMITED;
            }
            if (Collections.singletonList(unknownCode).contains(applyStatus)) {
                noteState = PaymentState.UNKNOWN;
            }
            StringBuilder sb = new StringBuilder(info.getBankMsg());
            if (noteState != null) {
                info.setStatus(Integer.valueOf(noteState.getId()));
                sb.append(StringUtils.isEmpty((String)applyStatusName) ? "" : "," + applyStatusName);
                sb.append(StringUtils.isEmpty((String)returnReason) ? "" : "," + returnReason);
                info.setBankMsg(sb.toString());
            }
            if (StringUtils.isEmpty((String)billCode)) continue;
            new NoteStatusQuery().query(info);
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)billStatus, (String)ResManager.loadKDString((String)"\u51fa\u7968\u5df2\u767b\u8bb0", (String)"QueryDrawfinDtailParser_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
    }
}

