/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmbc.dc.services.news.detail;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cmbc.dc.services.news.CodelessUtil;
import kd.ebg.note.banks.cmbc.dc.services.news.detail.AbstractCmbcNoteDetailImpl;
import kd.ebg.note.banks.cmbc.dc.services.news.detail.NoteInfoImpl;
import kd.ebg.note.banks.cmbc.dc.services.util.Parser;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.utils.PropertiesConstantsUtils;
import org.jdom2.Element;

public class NoteHoldImpl
extends AbstractCmbcNoteDetailImpl {
    public String getDateStr() {
        return "yyyy-MM-dd";
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "B2eNbsDraftHoldingBillsQry";
    }

    public String getStructIdPacker() {
        return "B2eNbsDraftHoldingBillsQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6301\u7968\u67e5\u8be2", (String)"NoteHoldImpl_0", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]);
    }

    @Override
    public String getSendMsg(String rqs) {
        return CodelessUtil.addAttributeToRoot(rqs, this.getBizCode());
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public String pack(BankNoteDetailRequest bankNoteDetailRequest, String s) {
        return null;
    }

    public List<Detail> parse(BankNoteDetailRequest bankNoteDetailRequest, String s) {
        return null;
    }

    public boolean isPackerAuto() {
        return true;
    }

    public boolean isParserAuto() {
        return true;
    }

    public List<Detail> parserUtil(BankNoteDetailRequest request, String responStr) {
        List details = super.parserUtil(request, responStr);
        BankAcnt acnt = request.getAcnt();
        NoteInfoImpl impl = new NoteInfoImpl();
        ArrayList<Detail> result = new ArrayList<Detail>(1);
        for (Detail info : details) {
            if ("CS06".equals(info.getNoteStatus()) || "CS05".equals(info.getNoteStatus())) continue;
            result.add(info);
            String packMessage = CodelessUtil.pack4QueryStatus(acnt.getAccNo(), info.getNoteNo(), info.getStartNo(), info.getEndNo());
            String res = this.doBussiness(packMessage);
            List<Detail> response = impl.parse(request, res);
            List noteSidesInfo = response.get(0).getNoteSidesInfo();
            info.setNoteSidesInfo(noteSidesInfo);
        }
        return result;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse bankResponse = Parser.parseResponse(root);
        if (-1 != bankResponse.getResponseMessage().indexOf(PropertiesConstantsUtils.getValue((String)"nothing"))) {
            return true;
        }
        Element xDataBodyElement = root.getChild("xDataBody");
        String allNum = xDataBodyElement.getChildTextTrim("total");
        if (!StringUtils.isEmpty((String)allNum)) {
            int page = Integer.parseInt(pageTag) - 1;
            return page * 100 >= Integer.parseInt(allNum);
        }
        return true;
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        int page = Integer.parseInt(pageTag);
        int nextPage = page + 1;
        return "" + nextPage;
    }
}

