/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmbc.dc.services.note.detail;

import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cmbc.dc.services.note.detail.endorseinfo.EndorseInfoImpl;
import kd.ebg.note.banks.cmbc.dc.services.util.Packer;
import kd.ebg.note.banks.cmbc.dc.services.util.Parser;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class NoteDetailImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailImpl.class);
    private int curentNum = 0;

    public String pack(BankNoteDetailRequest request, String pageTag) {
        String subBizType = request.getHeader().getSubBizType();
        if ("hold".equals(subBizType)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u6682\u4e0d\u652f\u6301\u6301\u7968\u67e5\u8be2\u3002", (String)"NoteDetailImpl_0", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]));
        }
        BankAcnt ancAcnt = request.getAcnt();
        if (request.getBody().getTranType().equals("03")) {
            return this.queryAccept("QryIssuanceSignUpDraft", ancAcnt, pageTag);
        }
        if (request.getBody().getTranType().equals("10")) {
            return this.queryAccept("QrySignUpEndorsmtDraft", ancAcnt, pageTag);
        }
        if (request.getBody().getTranType().equals("20")) {
            return this.queryAccept("QryStaySignUpDraft", ancAcnt, pageTag);
        }
        if (request.getBody().getTranType().equals("02")) {
            return this.queryAccept("QryAcceptSignUpDraft", ancAcnt, pageTag);
        }
        if (request.getBody().getTranType().equals("40")) {
            return this.queryAccept("QryStayRegDraft", ancAcnt, pageTag);
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684\u56de\u590d\u7c7b\u578b\u3002\u8bf7\u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u3002", (String)"NoteDetailImpl_1", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]));
    }

    public String queryAccept(String type, BankAcnt ancAcnt, String tag) {
        Element root = Packer.createMessageWithHead(type);
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.gen16Sequence());
        JDomUtils.addChild((Element)xdataBody, (String)"pageSize", (String)"100");
        JDomUtils.addChild((Element)xdataBody, (String)"appAcNo", (String)ancAcnt.getAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"currentIndex", (String)tag);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<Detail> parse(BankNoteDetailRequest request, String responseStr) {
        BankAcnt ancAcnt = request.getAcnt();
        this.logger.info("\u660e\u7ec6\u8fd4\u56de\u62a5\u6587\uff1a" + responseStr);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        ArrayList<Detail> detailList = new ArrayList<Detail>(16);
        if (!"0".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u5f02\u5e38", (String)"NoteDetailImpl_2", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]));
        }
        if (-1 != rsp.getResponseMessage().indexOf(ResManager.loadKDString((String)"\u6ca1\u6709\u76f8\u5173\u7684\u4ea4\u6613\u8bb0\u5f55\u3002", (String)"NoteDetailImpl_3", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]))) {
            return detailList;
        }
        Element xdatabody = root.getChild("xDataBody");
        Element dtlListElement = xdatabody.getChild("List");
        List dtlLists = dtlListElement.getChildren("Map");
        if (request.getBody().getTranType().equals("02")) {
            return this.parseAccpect(ancAcnt, dtlLists, "02");
        }
        if (request.getBody().getTranType().equals("03")) {
            return this.parseAccpect(ancAcnt, dtlLists, "03");
        }
        if (request.getBody().getTranType().equals("10")) {
            return this.parseAccpect(ancAcnt, dtlLists, "10");
        }
        if (request.getBody().getTranType().equals("20")) {
            return this.parseAccpect(ancAcnt, dtlLists, "20");
        }
        if (request.getBody().getTranType().equals("40")) {
            return this.parseAccpect(ancAcnt, dtlLists, "40");
        }
        return detailList;
    }

    public List<Detail> parseAccpect(BankAcnt ancAcnt, List<Element> list, String type) {
        ArrayList<Detail> detailList = new ArrayList<Detail>(list.size());
        for (Element rs : list) {
            Detail detailInfo = new Detail();
            String rgctId = rs.getChildTextTrim("rgctId");
            detailInfo.setBankRefKey(rgctId);
            String billNo = rs.getChildTextTrim("billNo");
            detailInfo.setNoteNo(billNo);
            String BILLTYP = rs.getChildTextTrim("billType");
            if ("1".equals(BILLTYP)) {
                detailInfo.setDraftType("AC01");
            } else {
                detailInfo.setDraftType("AC02");
            }
            String acptDt = rs.getChildText("issueDt");
            String dueDt = rs.getChildText("dueDt");
            String billMoney = rs.getChildText("billMoney");
            String forbidFlag = rs.getChildText("banEndorsementMark");
            String remitter = rs.getChildText("remitter");
            String remitterCustBank = rs.getChildText("remitterBank");
            String remitterCustBankNo = rs.getChildText("remitterBankNo");
            String remitterAcct = rs.getChildText("remitterAcct");
            String endorserName = rs.getChildText("applicantName");
            String endorserAcctNo = rs.getChildText("applicantAcctNo");
            String fromBankNo = rs.getChildText("applicantBankNo");
            String payee = rs.getChildText("payee");
            String payeeBank = rs.getChildText("payeeBank");
            String payeeBankNo = rs.getChildText("payeeBankNo");
            String payeeAcct = rs.getChildText("payeeAcct");
            String acceptor = rs.getChildText("acceptor");
            String acceptorAcct = rs.getChildText("acceptorAcct");
            String acceptorBankNo = rs.getChildText("acceptorBankNo");
            String acceptorBank = rs.getChildText("acceptorBank");
            String remark = rs.getChildText("remark");
            String APPDATE = rs.getChildText("applyDate");
            try {
                detailInfo.setIssueDate(DateTimeUtils.format((Date)DateTimeUtils.parseDate((String)acptDt, (String)"yyyy-MM-dd"), (String)"yyyyMMdd"));
            }
            catch (ParseException e1) {
                this.logger.error("", (Throwable)e1);
            }
            try {
                detailInfo.setApplicationDate(DateTimeUtils.format((Date)DateTimeUtils.parseDate((String)APPDATE, (String)"yyyy-MM-dd"), (String)"yyyyMMdd"));
            }
            catch (ParseException e) {
                this.logger.error("", (Throwable)e);
            }
            try {
                detailInfo.setDueDate(DateTimeUtils.format((Date)DateTimeUtils.parseDate((String)dueDt, (String)"yyyy-MM-dd"), (String)"yyyyMMdd"));
            }
            catch (ParseException e) {
                this.logger.error("", (Throwable)e);
            }
            if (StringUtils.isEmpty((String)billMoney)) {
                detailInfo.setAmount("0");
            } else {
                detailInfo.setAmount(billMoney);
            }
            if ("0".equals(forbidFlag)) {
                detailInfo.setTransferFlag("EM00");
            } else {
                detailInfo.setTransferFlag("EM01");
            }
            detailInfo.setDrawerAccName(remitter);
            detailInfo.setDrawerAccNo(remitterAcct);
            detailInfo.setDrawerBankName(remitterCustBank);
            detailInfo.setDrawerCnapsCode(remitterCustBankNo);
            detailInfo.setPayeeAccName(payee);
            detailInfo.setPayeeAccNo(payeeAcct);
            detailInfo.setPayeeCnapsCode(payeeBankNo);
            detailInfo.setPayeeBankName(payeeBank);
            detailInfo.setApplicantAcName(endorserName);
            detailInfo.setApplicantAcNo(endorserAcctNo);
            detailInfo.setApplicantBankCnaps(fromBankNo);
            detailInfo.setAcceptorAccName(acceptor);
            detailInfo.setAcceptorAccNo(acceptorAcct);
            detailInfo.setAcceptorCnapsCode(acceptorBankNo);
            detailInfo.setAcceptorBankName(acceptorBank);
            detailInfo.setCurrency("CNY");
            detailInfo.setContractNumber(rgctId);
            detailInfo.setExplain(remark);
            if ("10".equals(type)) {
                detailInfo.setNoteStatus("100001");
            } else if ("02".equals(type)) {
                detailInfo.setNoteStatus("020001");
            } else if ("03".equals(type)) {
                detailInfo.setNoteStatus("030001");
            } else if ("20".equals(type)) {
                detailInfo.setNoteStatus("200001");
            } else if ("11".equals(type)) {
                detailInfo.setNoteStatus("130101");
            }
            if ("40".equals(type)) {
                detailInfo.setNoteNo(rgctId);
            }
            try {
                EndorseInfoImpl impl = new EndorseInfoImpl();
                List<NoteSidesInfo> sidesDetails = impl.getinfo(billNo, rgctId, ancAcnt.getAccNo());
                detailInfo.setNoteSidesInfo(sidesDetails);
            }
            catch (Throwable t) {
                this.logger.error("sides error", t);
                detailInfo.setIsNoteSidesError("Y");
            }
            detailList.add(detailInfo);
        }
        return detailList;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        int page = Integer.parseInt(pageTag);
        int nextPage = page + 1;
        return "" + nextPage;
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse bankResponse = Parser.parseResponse(root);
        if (-1 != bankResponse.getResponseMessage().indexOf(ResManager.loadKDString((String)"\u6ca1\u6709\u76f8\u5173\u7684\u4ea4\u6613\u8bb0\u5f55\u3002", (String)"NoteDetailImpl_3", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]))) {
            return true;
        }
        Element xDataBodyElement = root.getChild("xDataBody");
        Element dtlListElement = xDataBodyElement.getChild("dtlList");
        String allNum = xDataBodyElement.getChildTextTrim("allNum");
        if (!StringUtils.isEmpty((String)allNum)) {
            int current = Integer.parseInt(pageTag) - 1;
            return current * 100 >= Integer.parseInt(allNum);
        }
        return true;
    }

    public int getCurentNum() {
        return this.curentNum;
    }

    public void setCurentNum(int curentNum) {
        this.curentNum = curentNum;
    }

    public EBBankDetailResponse doBiz(BankNoteDetailRequest request) {
        if (this.isNeedPage()) {
            return this.doBizWithPage(request);
        }
        return super.doBizNoPage(request);
    }

    public EBBankDetailResponse doBizWithPage(BankNoteDetailRequest request) {
        ArrayList<Detail> list = new ArrayList<Detail>();
        try {
            String pageTag = this.getFirstPageTag();
            String responseStr = "";
            do {
                String requestStr = this.pack(request, pageTag);
                this.logger.info("\u53d1\u9001\u6570\u636e" + requestStr);
                ConnectionFactory factory = this.getConnectionFactory();
                int length = requestStr.getBytes(RequestContextUtils.getCharset()).length;
                factory.setHttpHeader("Content-Length", String.valueOf(length));
                factory.setUri(Packer.getURL());
                IConnection connection = this.getConnection(factory);
                this.openConnection(connection);
                try (OutputStream outputStream = this.getOutputStream(connection);){
                    this.send(outputStream, requestStr);
                    try (InputStream inputStream = this.getInputStream(connection);){
                        responseStr = this.recv(inputStream);
                        this.logger.info("\u63a5\u6536\u5230\u6570\u636e" + responseStr);
                        list.addAll(this.parse(request, responseStr));
                        pageTag = this.getNextPageTag(responseStr, pageTag);
                    }
                }
            } while (!this.isLastPage(responseStr, pageTag));
            return new EBBankDetailResponse(list);
        }
        catch (EBServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u4e1a\u52a1\u51fa\u73b0\u5f02\u5e38\u3002", (String)"NoteDetailImpl_4", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

