/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.receivable.payment;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.note.BatchUtil;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonParser;
import kd.ebg.note.banks.ccb.dc.services.note.receivable.payment.QueryPaymentNoteReceivableImpl;
import kd.ebg.note.banks.ccb.dc.services.utils.BoshAcntAreaCodeUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class PaymentNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private static final String SEPERATOR = "|";
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentNoteReceivableImpl.class);

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPaymentNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        NoteReceivableInfo info2;
        List receivableInfos = request.getNoteReceivableInfos();
        for (NoteReceivableInfo info2 : receivableInfos) {
            info2.setPayeeAccNo(BoshAcntAreaCodeUtil.getAccNoWithoutAreaCode(info2.getPayeeAccNo(), info2.getPayeeBankName()));
        }
        BankAcnt acnt = request.getAcnt();
        if (receivableInfos.size() > 1) {
            StringBuilder sBuffer = new StringBuilder();
            sBuffer.append(ResManager.loadKDString((String)"#\u7535\u5b50\u7968\u636e\u53f7\u7801|\u63d0\u793a\u4ed8\u6b3e\u91d1\u989d|\u63d0\u793a\u4ed8\u6b3e\u7533\u8bf7\u65e5\u671f|\u903e\u671f\u539f\u56e0\u8bf4\u660e|\u6e05\u7b97\u65b9\u5f0f|\u63d0\u793a\u4ed8\u6b3e\u4eba\u5907\u6ce8|\u63d0\u793a\u4ed8\u6b3e\u4eba\u7c7b\u522b|\u63d0\u793a\u4ed8\u6b3e\u4eba\u540d\u79f0|\u63d0\u793a\u4ed8\u6b3e\u4eba\u8d26\u53f7|\u63d0\u793a\u4ed8\u6b3e\u4eba\u5f00\u6237\u884c\u884c\u53f7|\u63d0\u793a\u4ed8\u6b3e\u4eba\u627f\u63a5\u884c\u884c\u53f7|", (String)"PaymentNoteReceivableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
            sBuffer.append("\r\n");
            for (int i = 0; i < receivableInfos.size(); ++i) {
                NoteReceivableInfo info3 = (NoteReceivableInfo)receivableInfos.get(i);
                sBuffer.append(info3.getBillNo()).append(SEPERATOR);
                sBuffer.append(info3.getAmount().toString()).append(SEPERATOR);
                String signDate4Test = RequestContextUtils.getBankParameterValue((String)"TEST_DATE");
                if (StringUtils.isNotEmpty((String)signDate4Test)) {
                    sBuffer.append(signDate4Test).append(SEPERATOR);
                } else {
                    String appdate = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
                    LocalDate nowLocal = ((NoteReceivableInfo)receivableInfos.get(0)).getDueDate();
                    Date succ = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
                    if (DateTimeUtils.dayAfter((Date)succ, (Date)new Date())) {
                        appdate = "";
                    }
                    sBuffer.append(appdate).append(SEPERATOR);
                }
                sBuffer.append(info3.getExplanation()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append(info3.getExplanation()).append(SEPERATOR);
                sBuffer.append("RC01").append(SEPERATOR);
                sBuffer.append(acnt.getAccName()).append(SEPERATOR);
                sBuffer.append(acnt.getAccNo()).append(SEPERATOR);
                sBuffer.append(acnt.getCnaps()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append("\r\n");
            }
            String fileContent = sBuffer.toString();
            return BatchUtil.uploadFile6WH055(fileContent, receivableInfos, "0004");
        }
        info2 = (NoteReceivableInfo)receivableInfos.get(0);
        Element root = CCB_DC_Packer.createTransactionHeader("6WH011", info2.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(root, "", info2.getBankBatchSeqId());
        JDomUtils.addChild((Element)txBody, (String)"BkNum1", (String)(receivableInfos.size() + ""));
        JDomUtils.addChild((Element)txBody, (String)"BkAmt9", (String)info2.getAmount().toString());
        Element detaillist = JDomUtils.addChild((Element)txBody, (String)"DETAILLIST");
        Element detailinfo = JDomUtils.addChild((Element)detaillist, (String)"DETAILINFO");
        JDomUtils.addChild((Element)detailinfo, (String)"BkListNo1", (String)info2.getBillNo());
        JDomUtils.addChild((Element)detailinfo, (String)"BkAmt2", (String)info2.getAmount().toString());
        String signDate4Test = RequestContextUtils.getBankParameterValue((String)"TEST_DATE");
        if (StringUtils.isNotEmpty((String)signDate4Test)) {
            JDomUtils.addChild((Element)detailinfo, (String)"Bk8Date2", (String)signDate4Test);
        } else {
            String appdate = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
            LocalDate nowLocal = info2.getDueDate();
            Date succ = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            if (DateTimeUtils.dayAfter((Date)succ, (Date)new Date())) {
                appdate = "";
            }
            JDomUtils.addChild((Element)detailinfo, (String)"Bk8Date2", (String)appdate);
        }
        JDomUtils.addChild((Element)detailinfo, (String)"BkDetail2", (String)info2.getExplanation());
        JDomUtils.addChild((Element)detailinfo, (String)"BkFlag3", (String)"");
        JDomUtils.addChild((Element)detailinfo, (String)"BkDetail1", (String)info2.getExplanation());
        JDomUtils.addChild((Element)detailinfo, (String)"BkRole", (String)"RC01");
        JDomUtils.addChild((Element)detailinfo, (String)"Bk60Name1", (String)acnt.getAccName());
        JDomUtils.addChild((Element)detailinfo, (String)"BkAcctNo1", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)detailinfo, (String)"BkBrchNo1", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)detailinfo, (String)"BkBrchNo2", (String)"");
        return NoteCommonPacker.root2StringSafeMod(root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List receivableInfos = request.getNoteReceivableInfos();
        if (receivableInfos.size() == 1) {
            NoteCommonParser.parsePayMayFail(receivableInfos, responseStr);
        } else {
            NoteCommonParser.parsePay(receivableInfos, responseStr);
        }
        return receivableInfos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u4ed8\u6b3e", (String)"PaymentNoteReceivableImpl_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

