/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.receivable.pledge;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.note.BatchUtil;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonParser;
import kd.ebg.note.banks.ccb.dc.services.note.receivable.pledge.QueryPledgeNoteReceivableImpl;
import kd.ebg.note.banks.ccb.dc.services.utils.BoshAcntAreaCodeUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class PledgeNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private static final String SEPERATOR = "|";
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(PledgeNoteReceivableImpl.class);

    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPledgeNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List receivableInfos = request.getNoteReceivableInfos();
        for (NoteReceivableInfo info : receivableInfos) {
            info.setPayeeAccNo(BoshAcntAreaCodeUtil.getAccNoWithoutAreaCode(info.getPayeeAccNo(), info.getPayeeBankName()));
        }
        BankAcnt acnt = request.getAcnt();
        if (receivableInfos.size() > 1) {
            StringBuilder sBuffer = new StringBuilder();
            sBuffer.append(ResManager.loadKDString((String)"#\u7535\u5b50\u7968\u636e\u53f7\u7801|\u51fa\u8d28\u4eba\u5907\u6ce8|\u51fa\u8d28\u4eba\u7c7b\u522b|\u51fa\u8d28\u4eba\u540d\u79f0|\u51fa\u8d28\u4eba\u8d26\u53f7|\u51fa\u8d28\u4eba\u5f00\u6237\u884c|\u8d28\u6743\u4eba\u540d\u79f0|\u8d28\u6743\u4eba\u8d26\u53f7|\u8d28\u6743\u4eba\u5f00\u6237\u884c|\u6279\u6b21\u53f7|", (String)"PledgeNoteReceivableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
            sBuffer.append("\r\n");
            for (int i = 0; i < receivableInfos.size(); ++i) {
                NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(i);
                sBuffer.append(info.getBillNo()).append(SEPERATOR);
                sBuffer.append(info.getExplanation()).append(SEPERATOR);
                sBuffer.append("RC01").append(SEPERATOR);
                sBuffer.append(acnt.getAccName()).append(SEPERATOR);
                sBuffer.append(acnt.getAccNo()).append(SEPERATOR);
                sBuffer.append(acnt.getCnaps()).append(SEPERATOR);
                sBuffer.append(info.getPayeeAccName()).append(SEPERATOR);
                sBuffer.append(info.getPayeeAccNo()).append(SEPERATOR);
                sBuffer.append(info.getPayeeBankCnaps()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append("\r\n");
            }
            String fileContent = sBuffer.toString();
            return BatchUtil.uploadFile6WH055(fileContent, receivableInfos, "0009");
        }
        NoteReceivableInfo receivableInfo = (NoteReceivableInfo)receivableInfos.get(0);
        Element header = CCB_DC_Packer.createTransactionHeader("6WH009", receivableInfo.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(header, "", receivableInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)receivableInfo.getBillNo());
        JDomUtils.addChild((Element)txBody, (String)"ecdsType", (String)receivableInfo.getDraftType());
        JDomUtils.addChild((Element)txBody, (String)"BkAcctNo1", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)txBody, (String)"Bk60Name1", (String)acnt.getAccName());
        JDomUtils.addChild((Element)txBody, (String)"BkBrchNo1", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)txBody, (String)"BkDetail1", (String)receivableInfo.getExplanation());
        JDomUtils.addChild((Element)txBody, (String)"BkEcdBatchNo", (String)receivableInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)txBody, (String)"Bk60Name3", (String)receivableInfo.getPayeeAccName());
        JDomUtils.addChild((Element)txBody, (String)"BkAcctNo3", (String)receivableInfo.getPayeeAccNo());
        JDomUtils.addChild((Element)txBody, (String)"BkBrchNo3", (String)receivableInfo.getPayeeBankCnaps());
        JDomUtils.addChild((Element)txBody, (String)"BkHvpBrchNo", (String)acnt.getCnaps());
        return NoteCommonPacker.root2StringSafeMod(header);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        NoteCommonParser.parsePay(request.getNoteReceivableInfos(), responseStr);
        return request.getNoteReceivableInfos();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d28\u62bc", (String)"PledgeNoteReceivableImpl_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

