/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.receivable.signin;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.banks.ccb.dc.services.note.BatchUtil;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.receivable.signin.QuerySigninNoteReceivableImpl;
import kd.ebg.note.banks.ccb.dc.services.note.receivable.signin.SignTypeUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class SigninNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private static final String SEPERATOR = "|";

    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QuerySigninNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List receivableInfos = request.getNoteReceivableInfos();
        BankAcnt acnt = request.getAcnt();
        if (receivableInfos.size() >= 1) {
            StringBuilder sBuffer = new StringBuilder();
            sBuffer.append(ResManager.loadKDString((String)"#\u7535\u5b50\u7968\u636e\u53f7\u7801|\u56de\u590d\u4eba\u540d\u79f0|\u56de\u590d\u4eba\u8d26\u53f7|\u56de\u590d\u4eba\u5f00\u6237\u884c\u884c\u53f7|\u56de\u590d\u6807\u8bb0|\u539fECDS\u5e73\u53f0\u65e5\u671f|\u539fECDS\u5e73\u53f0\u6d41\u6c34|\u56de\u590d\u4eba\u5907\u6ce8|||||", (String)"SigninNoteReceivableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
            sBuffer.append("\r\n");
            for (int i = 0; i < receivableInfos.size(); ++i) {
                NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(i);
                sBuffer.append(info.getBillNo()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append(acnt.getAccNo()).append(SEPERATOR);
                sBuffer.append(acnt.getCnaps()).append(SEPERATOR);
                sBuffer.append(info.getOtherInfo()).append(SEPERATOR);
                sBuffer.append(info.getBankRefDate()).append(SEPERATOR);
                sBuffer.append(info.getBankRefKey()).append(SEPERATOR);
                sBuffer.append(info.getExplanation()).append(SEPERATOR).append(SEPERATOR).append(SEPERATOR).append(SEPERATOR).append(SEPERATOR);
                sBuffer.append("\r\n");
            }
            String fileContent = sBuffer.toString();
            return BatchUtil.uploadFile6WH022(fileContent, receivableInfos, "0002");
        }
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        Element root = CCB_DC_Packer.createTransactionHeader("6WH014", info.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(root, "", info.getBankDetailSeqId());
        JDomUtils.addChild((Element)txBody, (String)"BkType1", (String)SignTypeUtil.INSTANCE.convert2Bank(info.getOperationCode()));
        JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)info.getBillNo());
        JDomUtils.addChild((Element)txBody, (String)"BkRole", (String)"RC01");
        JDomUtils.addChild((Element)txBody, (String)"BkAcctNo1", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)txBody, (String)"BkBrchNo1", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)txBody, (String)"BkBrchNo2", (String)"");
        if ("02".equals(info.getOperationCode())) {
            JDomUtils.addChild((Element)txBody, (String)"BkLevel1", (String)info.getDrawerCreditRatings());
            JDomUtils.addChild((Element)txBody, (String)"BkPrtFileName", (String)info.getDrawerCreditRatingsAgency());
            JDomUtils.addChild((Element)txBody, (String)"Bk8Date1", (String)info.getDrawerCreditRatingsDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        JDomUtils.addChild((Element)txBody, (String)"BkAddr", (String)"");
        JDomUtils.addChild((Element)txBody, (String)"BkListNo4", (String)info.getContractNo());
        JDomUtils.addChild((Element)txBody, (String)"BkType2", (String)info.getOtherInfo());
        if ("SU01".equals(info.getOtherInfo())) {
            JDomUtils.addChild((Element)txBody, (String)"BkType3", (String)info.getExplanation());
        }
        JDomUtils.addChild((Element)txBody, (String)"BkOldPlatDate", (String)info.getBankRefDate());
        JDomUtils.addChild((Element)txBody, (String)"BkOldSeq", (String)info.getBankRefKey());
        JDomUtils.addChild((Element)txBody, (String)"BkDetail1", (String)"");
        JDomUtils.addChild((Element)txBody, (String)"BkDetail2", (String)info.getExplanation());
        return NoteCommonPacker.root2StringSafeMod(root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List infos = request.getNoteReceivableInfos();
        Element root = CCB_DC_Parser.parseString2Root(responseStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if ("000000".equals(response.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)response.getResponseCode(), (String)response.getResponseMessage());
            Element TX_INFO = root.getChild("TX_INFO");
            String BkListNo1 = TX_INFO.getChildText("BkListNo1");
            EBGNoteReceivableUtils.setNoteBatchNo((List)infos, (String)BkListNo1);
        } else if ("YCEECDB63007".equals(response.getResponseCode()) || "0130Z110WH01".equals(response.getResponseCode()) || "YBLECDA10000".equals(response.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return infos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7b7e\u6536", (String)"SigninNoteReceivableImpl_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

