/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.cmp.service.note.util;

import java.math.BigDecimal;
import java.util.Date;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Packer;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class ICBC_CMP_NotePacker {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ICBC_CMP_NotePacker.class);

    public static String packPay(NotePayableInfo[] notePayableInfos, String transCode) {
        NotePayableInfo notePayableInfo = notePayableInfos[0];
        logger.info(transCode + ",amount:" + notePayableInfo.getAmount());
        logger.info(transCode + ",BillAmt:" + ParserUtils.convertCentStr2Yuan((String)notePayableInfo.getAmount().toString()).toString());
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(transCode, notePayableInfo.getBankBatchSeqId());
        Element eb = JDomUtils.getChildElement((Element)root, (String)"eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"BillNo", (String)notePayableInfo.getBillNo());
        JDomUtils.addChild((Element)in, (String)"BillOpenName", (String)notePayableInfo.getDrawerAccName());
        JDomUtils.addChild((Element)in, (String)"BillOpenAcc", (String)notePayableInfo.getDrawerAccNo());
        JDomUtils.addChild((Element)in, (String)"AccNo", (String)notePayableInfo.getDrawerAccNo());
        JDomUtils.addChild((Element)in, (String)"BillAmt", (String)ParserUtils.convertYuan2CentStr((BigDecimal)notePayableInfo.getAmount()));
        JDomUtils.addChild((Element)in, (String)"SignFlag", (String)"");
        JDomUtils.addChild((Element)in, (String)"Addr", (String)"");
        JDomUtils.addChild((Element)in, (String)"RejectReason", (String)"");
        JDomUtils.addChild((Element)in, (String)"RejectRemark", (String)"");
        JDomUtils.addChild((Element)in, (String)"SMSFlag", (String)"");
        JDomUtils.addChild((Element)in, (String)"RecList", (String)"");
        JDomUtils.addChild((Element)in, (String)"PhoneList", (String)"");
        String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
        boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
        if (isProduct) {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"));
        } else {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)(signDate4Test + DateTimeUtils.format((Date)new Date(), (String)"HHmmssSSS")));
        }
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String msgSigned = ICBC_CMP_Packer.sign(reqstMsg);
        return ICBC_CMP_Packer.createMessageWithHead(msgSigned, transCode);
    }

    public static String packQueryStatusXml(NotePayableInfo[] notePayableInfos, String transCode) {
        Element root = ICBC_CMP_Packer.createICBCCMPRoot(transCode);
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"QryfSeqno", (String)"");
        JDomUtils.addChild((Element)in, (String)"QrySerialNo", (String)"");
        JDomUtils.addChild((Element)in, (String)"RefNo", (String)notePayableInfos[0].getBankDetailSeqId());
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead(requestMessage, transCode);
    }

    public static String packQueryStatusXml1(NotePayableInfo[] notePayableInfos, String transCode) {
        Element root = ICBC_CMP_Packer.createICBCCMPRoot(transCode);
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"QryfSeqno", (String)notePayableInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)in, (String)"QrySerialNo", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead(requestMessage, transCode);
    }

    public static String packQueryStatusXml(NoteReceivableInfo[] receivableInfos, String transCode) {
        Element root = ICBC_CMP_Packer.createICBCCMPRoot(transCode);
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"QryfSeqno", (String)receivableInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)in, (String)"QrySerialNo", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead(requestMessage, transCode);
    }

    public static String packQueryDetailXml(NoteReceivableInfo[] receivableInfos) {
        Element root = ICBC_CMP_Packer.createICBCCMPRoot("QBIINFO");
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"BillNo", (String)receivableInfos[0].getBillNo());
        JDomUtils.addChild((Element)in, (String)"NextTag", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead(requestMessage, "QBIINFO");
    }

    public static String packQueryDetailXml(NoteReceivableInfo receivableInfos) {
        Element root = ICBC_CMP_Packer.createICBCCMPRoot("QBIINFO");
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"BillNo", (String)receivableInfos.getBillNo());
        JDomUtils.addChild((Element)in, (String)"NextTag", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead(requestMessage, "QBIINFO");
    }

    public static String packQueryDetailPayableXml(NotePayableInfo[] notePayableInfos) {
        Element root = ICBC_CMP_Packer.createICBCCMPRoot("QBIINFO");
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"BillNo", (String)notePayableInfos[0].getBillNo());
        JDomUtils.addChild((Element)in, (String)"NextTag", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead(requestMessage, "QBIINFO");
    }
}

