/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.cmp.service.note.util;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.icbc.cmp.service.note.payable.cancle.StatusUtil;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_FailErrorCodes;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_NotePacker;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Parser;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class ICBC_CMP_NoteParser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ICBC_CMP_NoteParser.class);

    public static void parsePayable(List<NotePayableInfo> notePayableInfos, String rspStr) {
        NotePayableInfo notePayableInfo = notePayableInfos.get(0);
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(rspStr, true);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        String SerialNo = pub.getChildText("SerialNo");
        logger.info("SerialNo:{}", (Object)SerialNo);
        String fSeqno = pub.getChildText("fSeqno");
        logger.info("fSeqno:{}", (Object)fSeqno);
        notePayableInfo.setRspserialno(SerialNo);
        notePayableInfo.setRqstserialno(fSeqno);
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        String bankStatus = "<RetCode>" + headRsp.getResponseCode() + "</RetCode>";
        logger.info("parsePay RetCode=" + headRsp.getResponseCode() + ", parsePay RetMsg=" + headRsp.getResponseMessage());
        if (!"0".equals(headRsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        Element out = eb.getChild("out");
        String outstr = JDomUtils.element2StringPlain((Element)out, (String)"UTF-8");
        logger.info("outstr \u4e2d\u62a5\u6587\u662f\uff1a" + outstr);
        String resultstr = out.getChildTextTrim("Result");
        logger.info("outstr \u4e2dresult\u662f\uff1a" + resultstr + ",\u662f\u5426\u4e3a15:" + resultstr.equals("15"));
        if (out == null) {
            if (notePayableInfos.size() != 0) {
                EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
                return;
            }
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankStatus, (String)headRsp.getResponseMessage());
            return;
        }
        String result = out.getChildTextTrim("Result");
        if (result.equals("0")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u7b49\u5f85\u94f6\u884c\u5904\u7406\u3002", (String)"ICBC_CMP_NoteParser_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else if (result.equals("1")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u6388\u6743\u6210\u529f,\u7b49\u5f85\u94f6\u884c\u5904\u7406\uff08\u9884\u7559\uff09", (String)"ICBC_CMP_NoteParser_1", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else if (result.equals("2")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u7b49\u5f85\u6388\u6743\uff08\u9884\u7559\uff09", (String)"ICBC_CMP_NoteParser_2", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else if (result.equals("6")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.FAIL, (String)result, (String)headRsp.getResponseMessage());
        } else if (result.equals("7")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f", (String)"ICBC_CMP_NoteParser_3", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else if (result.equals("9")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u94f6\u884c\u6b63\u5728\u5904\u7406", (String)"ICBC_CMP_NoteParser_4", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else if (result.equals("15")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUCCESS, (String)result, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f\uff0c\u4eba\u884c\u5904\u7406\u6210\u529f", (String)"ICBC_CMP_NoteParser_5", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else if (result.equals("16")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.FAIL, (String)result, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f\uff0c\u4eba\u884c\u5904\u7406\u5931\u8d25", (String)"ICBC_CMP_NoteParser_6", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
    }

    public static void parsePay(List<NoteReceivableInfo> infos, String s) {
        Element out;
        NoteReceivableInfo info = infos.get(0);
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(s, true);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        String retmsg = pub.getChildText("RetMsg");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        String bankStatus = "<RetCode>" + headRsp.getResponseCode() + "</RetCode>";
        String SerialNo = pub.getChildText("SerialNo");
        logger.info("\u83b7\u53d6\u5230\u7684\u6d41\u6c34\u53f7\uff1a" + SerialNo);
        info.setRspserialno(SerialNo);
        info.setBankRefKey(SerialNo);
        if (!"0".equals(headRsp.getResponseCode())) {
            if (ICBC_CMP_FailErrorCodes.isFailed(headRsp.getResponseCode())) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)bankStatus, (String)headRsp.getResponseMessage());
            } else {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)bankStatus, (String)headRsp.getResponseMessage());
            }
        }
        if ((out = eb.getChild("out")) == null) {
            if (infos.size() != 0) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)bankStatus, (String)headRsp.getResponseMessage());
            } else {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)bankStatus, (String)headRsp.getResponseMessage());
            }
        } else {
            String result = out.getChildTextTrim("Result");
            if (result.equals("0")) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u7b49\u5f85\u94f6\u884c\u5904\u7406\u3002", (String)"ICBC_CMP_NoteParser_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("1")) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u6388\u6743\u6210\u529f,\u7b49\u5f85\u94f6\u884c\u5904\u7406\uff08\u9884\u7559\uff09", (String)"ICBC_CMP_NoteParser_1", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("2")) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u7b49\u5f85\u6388\u6743\uff08\u9884\u7559\uff09", (String)"ICBC_CMP_NoteParser_2", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("6")) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)result, (String)String.format(ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd:%s", (String)"ICBC_CMP_NoteParser_23", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), retmsg));
            } else if (result.equals("7")) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f", (String)"ICBC_CMP_NoteParser_3", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("9")) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u94f6\u884c\u6b63\u5728\u5904\u7406", (String)"ICBC_CMP_NoteParser_4", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("15")) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)result, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f\uff0c\u4eba\u884c\u5904\u7406\u6210\u529f", (String)"ICBC_CMP_NoteParser_5", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("16")) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)result, (String)String.format(ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f\uff0c\u4eba\u884c\u5904\u7406\u5931\u8d25:%s\u3002", (String)"ICBC_CMP_NoteParser_24", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), retmsg));
            }
        }
    }

    public static String getstatus(NoteReceivableInfo receivableInfos, String rsp) {
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(rsp, true);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        String bankMsg = headRsp.getResponseMessage();
        if (!"0".equals(headRsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u540c\u6b65\u7ed3\u679c\u5931\u8d25", (String)"ICBC_CMP_NoteParser_19", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
        Element out = eb.getChild("out");
        String BillNo = out.getChildTextTrim("BillNo");
        String result = out.getChildTextTrim("BillState");
        return result;
    }

    public static void parseQueryNoteMessagePayable(List<NotePayableInfo> paymentInfos, String rspStr) {
        NotePayableInfo paymentinfo = paymentInfos.get(0);
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(rspStr, true);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        String rootstr = JDomUtils.element2StringPlain((Element)root, (String)"UTF-8");
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        logger.info("parseQueryNoteMessage RetCode=" + headRsp.getResponseCode() + ", parseQueryNoteMessage RetMsg=" + headRsp.getResponseMessage());
        logger.info("parseQueryNoteMessage batchSeqId=" + paymentinfo.getBatchSeqId());
        logger.info("paymentInfos.length=" + paymentInfos.size());
        if (!"0".equals(headRsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u51fa\u7968\u7ed3\u679c\u5931\u8d25", (String)"ICBC_CMP_NoteParser_20", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), (String)headRsp.getResponseMessage());
        } else {
            Element out = eb.getChild("out");
            String outstr = JDomUtils.element2StringPlain((Element)out, (String)"UTF-8");
            logger.info("outstr \u4e2d\u62a5\u6587\u662f\uff1a" + outstr);
            String resultstr = out.getChildTextTrim("Result");
            logger.info("outstr \u4e2dresult\u662f\uff1a" + resultstr + ",\u662f\u5426\u4e3a15:" + resultstr.equals("15"));
            String BillNo = out.getChildTextTrim("BillNo");
            String BillOpenDate = out.getChildTextTrim("BillOpenDate");
            String BillDueDate = out.getChildTextTrim("BillDueDate");
            String result = out.getChildTextTrim("Result");
            if (result.equals("0")) {
                EBGNotePayableUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u7b49\u5f85\u94f6\u884c\u5904\u7406\u3002", (String)"ICBC_CMP_NoteParser_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("1")) {
                EBGNotePayableUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u6388\u6743\u6210\u529f,\u7b49\u5f85\u94f6\u884c\u5904\u7406\uff08\u9884\u7559\uff09", (String)"ICBC_CMP_NoteParser_1", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("2")) {
                EBGNotePayableUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u7b49\u5f85\u6388\u6743\uff08\u9884\u7559\uff09", (String)"ICBC_CMP_NoteParser_2", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("6")) {
                EBGNotePayableUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)result, (String)ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd", (String)"ICBC_CMP_NoteParser_21", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
                paymentinfo.setNoteStatus("000002");
            } else if (result.equals("7")) {
                EBGNotePayableUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f", (String)"ICBC_CMP_NoteParser_3", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("9")) {
                EBGNotePayableUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u94f6\u884c\u6b63\u5728\u5904\u7406", (String)"ICBC_CMP_NoteParser_4", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("15")) {
                EBGNotePayableUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)result, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f\uff0c\u4eba\u884c\u5904\u7406\u6210\u529f", (String)"ICBC_CMP_NoteParser_5", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
                paymentinfo.setNoteStatus("010004");
            } else if (result.equals("16")) {
                EBGNotePayableUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)result, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f\uff0c\u4eba\u884c\u5904\u7406\u5931\u8d25", (String)"ICBC_CMP_NoteParser_6", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
                paymentinfo.setNoteStatus("000002");
            }
            paymentinfo.setBillNo(BillNo);
        }
    }

    public static void parseQueryNoteMessage(List<NoteReceivableInfo> receivableInfos, String rsp) {
        NoteReceivableInfo noteReceivableInfo = receivableInfos.get(0);
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(rsp, true);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        String bankMsg = headRsp.getResponseMessage();
        if (!"0".equals(headRsp.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u4ea4\u6613\u7ed3\u679c\u5931\u8d25\u3002", (String)"ICBC_CMP_NoteParser_22", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), (String)bankMsg);
        } else {
            Element out = eb.getChild("out");
            String BillNo = out.getChildTextTrim("BillNo");
            String BillOpenDate = out.getChildTextTrim("BillOpenDate");
            String BillDueDate = out.getChildTextTrim("BillDueDate");
            String result = out.getChildTextTrim("Result");
            String msg = ICBC_CMP_NotePacker.packQueryDetailXml(noteReceivableInfo);
            String returnmsg = new StatusUtil().sendAndRecvMsg(msg);
            noteReceivableInfo.setNoteStatus(ICBC_CMP_NoteParser.getstatus(noteReceivableInfo, returnmsg));
            noteReceivableInfo.setBillNo(BillNo);
            if (result.equals("0")) {
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u7b49\u5f85\u94f6\u884c\u5904\u7406\u3002", (String)"ICBC_CMP_NoteParser_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("1")) {
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u6388\u6743\u6210\u529f,\u7b49\u5f85\u94f6\u884c\u5904\u7406\uff08\u9884\u7559\uff09", (String)"ICBC_CMP_NoteParser_1", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("2")) {
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u7b49\u5f85\u6388\u6743\uff08\u9884\u7559\uff09", (String)"ICBC_CMP_NoteParser_2", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("6")) {
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableInfo, (PaymentState)PaymentState.FAIL, (String)result, (String)ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd", (String)"ICBC_CMP_NoteParser_21", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("7")) {
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f", (String)"ICBC_CMP_NoteParser_3", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("9")) {
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u94f6\u884c\u6b63\u5728\u5904\u7406", (String)"ICBC_CMP_NoteParser_4", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            } else if (result.equals("15")) {
                String noteStatus = noteReceivableInfo.getNoteStatus();
                if (noteStatus.equals("100001") || noteStatus.equals("030001") || noteStatus.equals("200001")) {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4ee3\u7b7e\u6536\u72b6\u6001\uff0c\u8bf7\u7a0d\u540e\u540c\u6b65\u3002", (String)"ICBC_CMP_NoteParser_25", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
                } else {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableInfo, (PaymentState)PaymentState.SUCCESS, (String)result, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f\uff0c\u4eba\u884c\u5904\u7406\u6210\u529f", (String)"ICBC_CMP_NoteParser_5", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
                }
            } else if (result.equals("16")) {
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableInfo, (PaymentState)PaymentState.FAIL, (String)result, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f\uff0c\u4eba\u884c\u5904\u7406\u5931\u8d25", (String)"ICBC_CMP_NoteParser_6", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            }
        }
    }
}

