/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.cmp.service.note.util;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.LoggerConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.time.DateUtils;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class ICBC_CMP_Parser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ICBC_CMP_Parser.class);

    public static BankResponse parseHeader(Element pub) {
        BankResponse rsp = new BankResponse();
        String retCode = pub.getChildTextTrim("RetCode");
        String retMsg = "";
        Element RetMsgElement = pub.getChild("RetMsg");
        if (null != RetMsgElement) {
            String retMessage = ICBC_CMP_Parser.e2StrPlain(RetMsgElement, "GBK");
            int start = retMessage.indexOf("<RetMsg>");
            int end = retMessage.indexOf("</RetMsg>", start);
            retMsg = retMessage.substring(start + "<RetMsg>".length(), end);
        }
        String errMsg = pub.getChildText("ErrMsg");
        rsp.setResponseCode(retCode);
        rsp.setResponseMessage(StrUtil.join((String)" ", (String)retMsg, (String)errMsg));
        return rsp;
    }

    private static String e2StrPlain(Element element, String encoding) {
        XMLOutputter outputter = new XMLOutputter();
        Format format = Format.getPrettyFormat();
        format.setEncoding(encoding);
        format.setIndent("");
        format.setLineSeparator("");
        format.setExpandEmptyElements(true);
        outputter.setFormat(format);
        return outputter.outputString(element).trim();
    }

    public static Date parseICBCTransTime(String timeStampStr) {
        try {
            return DateUtils.parseDate((String)timeStampStr, (String[])new String[]{"yyyy-MM-dd-HH.mm.ss"});
        }
        catch (ParseException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static Date convertICBCTransTime(String dateStr, String timeStampStr) {
        try {
            Date timeStamp = DateUtils.parseDate((String)timeStampStr, (String[])new String[]{"yyyy-MM-dd-HH.mm.ss"});
            String timeStr = DateUtil.formatDate((Date)timeStamp, (String)"HHmmss");
            return DateUtils.parseDate((String)(dateStr + timeStr), (String[])new String[]{"yyyyMMddHHmmss"});
        }
        catch (ParseException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static String decodeRsp(String content, boolean logContent) {
        if (StrUtil.isEmpty((String)content)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5de5\u884c\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"ICBC_CMP_Parser_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
        int sep = content.indexOf("=");
        if (sep == -1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u7801\u5931\u8d25,\u5de5\u884c\u54cd\u5e94\u683c\u5f0f\u9519\u8bef:\u4e0d\u542b'='", (String)"ICBC_CMP_Parser_1", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
        String temp = content.substring(0, sep);
        String result = content.substring(1 + sep);
        if ("reqData".equals(temp)) {
            String reqData;
            String charsetName = EBContext.getContext().getCharsetName();
            try {
                reqData = new String(Base64.decodeBase64((String)result), charsetName);
            }
            catch (UnsupportedEncodingException e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u7801\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u96c6%s\u3002", (String)"ICBC_CMP_Parser_6", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), charsetName), (Throwable)e);
            }
            LoggerConnection.writeLogger((String)"response", (String)String.format(ResManager.loadKDString((String)"\u89e3\u7801\u540e\u5f97\u5230\u660e\u6587\u662f%s\u3002", (String)"ICBC_CMP_Parser_7", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), reqData));
            return reqData;
        }
        if ("errorCode".equals(temp)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5de5\u884c\u54cd\u5e94\u5185\u5bb9\u9519\u8bef:%s", (String)"ICBC_CMP_Parser_8", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), content));
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u7801\u5931\u8d25,\u5de5\u884c\u54cd\u5e94\u5185\u5bb9\u9519\u8bef:\u5de5\u884c\u8fd4\u56de\u7684\u5bc6\u6587\u4e2d\u4e0d\u542breqData", (String)"ICBC_CMP_Parser_5", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
    }
}

