/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hzyq.dc.service.receipt.utils;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.jdom2.Element;

public class TCommon {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(TCommon.class);

    public static String createCommonMsg(String xml) throws EBServiceException {
        int digital = 8;
        int msgBodyLen = TCommon.getLength(xml);
        String msgHead = TCommon.formatLen(String.valueOf(msgBodyLen), digital);
        return msgHead + xml;
    }

    public static int getLength(String str) throws EBServiceException {
        String encoding = TCommon.getEncoding();
        try {
            int length = str.getBytes(encoding).length;
            return length;
        }
        catch (Exception var3) {
            log.error("\u83b7\u53d6\u5b57\u7b26\u4e32\u957f\u5ea6\u51fa\u9519\uff1a" + str + ", encoding:" + encoding, (Throwable)var3);
            return 0;
        }
    }

    public static String formatLen(String msgLen, int len) {
        try {
            return StringFormater.formatLen((String)msgLen, (int)len, (boolean)false, (char)'0', (String)TCommon.getEncoding());
        }
        catch (Exception var3) {
            log.error("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u51fa\u9519\u3002", (Throwable)var3);
            return "";
        }
    }

    public static String getEncoding() throws EBServiceException {
        return RequestContextUtils.getBankParameterValue((String)"charset");
    }

    private static byte[] read(DataInputStream dis, int length) throws EBServiceException {
        byte[] bytes = new byte[length];
        try {
            int result = dis.read(bytes);
            if (result - length != 0) {
                log.info("\u76ee\u6807\u8bfb\u53d6\u957f\u5ea6:" + length + ", \u5b9e\u9645\u8bfb\u53d6\u957f\u5ea6:" + result);
            }
            return bytes;
        }
        catch (IOException var4) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u6d41\u5931\u8d25\uff0cIOException %s\u3002", (String)"TCommon_6", (String)"ebg-receipt-banks-hzyq-dc", (Object[])new Object[0]), var4.getMessage()), (Throwable)var4);
        }
    }

    private static String read2String(DataInputStream dis, int length, String encoding) throws EBServiceException {
        try {
            String str = new String(TCommon.read(dis, length), encoding);
            str = StringUtils.isEmpty((String)str) ? "" : str.trim();
            return str;
        }
        catch (EBServiceException var4) {
            throw var4;
        }
        catch (UnsupportedEncodingException var5) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301%s\u5b57\u7b26\u7f16\u7801\u3002", (String)"TCommon_7", (String)"ebg-receipt-banks-hzyq-dc", (Object[])new Object[0]), encoding), (Throwable)var5);
        }
    }

    public static String recvMessage(InputStream inputStream) throws EBServiceException {
        String encoding = RequestContextUtils.getCharset();
        try {
            DataInputStream dis = new DataInputStream(inputStream);
            String length = TCommon.read2String(dis, 10, encoding);
            int len = Integer.parseInt(length);
            String str = TCommon.read2String(dis, 2, encoding);
            String xmlString = TCommon.read2String(dis, len - 2, encoding);
            log.info("##\u63a5\u6536\u62a5\u6587\u957f\u5ea6\uff1a" + length + ", \u62a5\u4f53\u524d\u4e24\u5b57\u8282\uff1a" + str + ", \u62a5\u4f53\u5185\u5bb9\uff1a" + xmlString);
            return xmlString;
        }
        catch (Exception var7) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u63a5\u6536\u6570\u636e\u5f02\u5e38%s\u3002", (String)"TCommon_8", (String)"ebg-receipt-banks-hzyq-dc", (Object[])new Object[0]), var7.getMessage()), (Throwable)var7);
        }
    }

    public static String parseRecvMsg(String input) {
        log.info("###recv data\uff1a" + input);
        return !StringUtils.isEmpty((String)input) ? input.substring(12) : "";
    }

    public static BankResponse parseBankResponse(Element head) throws EBServiceException {
        BankResponse response = new BankResponse();
        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        String ext_info = head.getChildTextTrim("ext_info");
        String responseMessage = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\uff1a%s\u3002", (String)"TCommon_9", (String)"ebg-receipt-banks-hzyq-dc", (Object[])new Object[0]), ret_info);
        if (!StringUtils.isEmpty((String)ext_info)) {
            responseMessage = responseMessage + String.format(ResManager.loadKDString((String)"\uff1b\u94f6\u884c\u8fd4\u56de\u9644\u52a0\u4fe1\u606f\uff1a%s", (String)"TCommon_10", (String)"ebg-receipt-banks-hzyq-dc", (Object[])new Object[0]), ext_info);
        }
        response.setResponseCode(succ_flag + "_" + ret_code);
        response.setResponseMessage(responseMessage);
        return response;
    }
}

