/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.icbc.opa.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Vector;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.icbc.opa.service.receipt.ICBCOpaCommConfig;
import kd.ebg.receipt.banks.icbc.opa.service.receipt.ICBCOpaFileParser;
import kd.ebg.receipt.banks.icbc.opa.service.receipt.api.DetailImpl;
import kd.ebg.receipt.banks.icbc.opa.service.receipt.api.OneReceiptDownloadImpl;
import kd.ebg.receipt.banks.icbc.opa.service.receipt.utils.TodayReceiptUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.bank.ReceiptSystemProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.framework.utils.ReceiptCommonAipUtil;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.model.repository.DetailInfoRepository;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        String bankLogin;
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        if (status.intValue() != TaskStatus.PROCESSING.getId()) {
            return false;
        }
        if (!RequestContextUtils.receiptFormatIsFile() && !FileCommonUtils.isTestEnv()) {
            return false;
        }
        String bankVersion = EBContext.getContext().getBankVersionID();
        return !RequestContextUtils.isSupportBatchDownloadByBankLogin((String)bankVersion, (String)(bankLogin = EBContext.getContext().getBankLoginID())) || !request.getTransDate().isBefore(LocalDate.now());
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        List<Object> result = new ArrayList(16);
        boolean isToday = request.getTransDate().isEqual(LocalDate.now());
        if (isToday) {
            result = this.doTodayTask(downloadListTask, request);
        } else {
            List downloadListDetails;
            result = this.doJob_pushMode(downloadListTask);
            if (!result.isEmpty() && !(downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId))).isEmpty()) {
                List ids = downloadListDetails.stream().map(o -> o.getId()).collect(Collectors.toList());
                this.downloadListDetailService.deleteById(ids);
            }
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadListDetail> doTodayTask(DownloadListTask task, BankReceiptHandleRequest request) {
        String bankCurrency;
        LocalDate transDate;
        String transDateStr = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String bankLoginId = EBContext.getContext().getBankLoginID();
        ICBCOpaCommConfig config = (ICBCOpaCommConfig)EBConfigBuilder.getInstance().buildConfig(ICBCOpaCommConfig.class, bankLoginId);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        DetailImpl detailImpl = new DetailImpl();
        String accNo = task.getAccNo();
        List<DetailInfo> detailInfoList = detailImpl.detail(accNo, transDate = task.getTransDate(), bankCurrency = request.getAcnt().getCurrency());
        if (detailInfoList.isEmpty()) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u8be5\u8d26\u53f7\u5f53\u5929\u65e0\u4ea4\u6613\u660e\u7ec6", (String)"BankReceiptFetchListImpl_8", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]));
        }
        OneReceiptDownloadImpl oneReceiptDownload = new OneReceiptDownloadImpl();
        BankFtpProperties ftpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        try {
            List<String> receiptList = TodayReceiptUtils.getInstance().getReceiptList(ftpProperties, accNo, transDate);
            for (DetailInfo detailInfo : detailInfoList) {
                String onlySequence = detailInfo.getReceiptNo();
                String fileType = "0";
                String fileLastStr = "pdf";
                if (config.getPushFileType().equals("OFD")) {
                    fileType = "1";
                    fileLastStr = "ofd";
                }
                boolean isNeedDownloadQuery = true;
                String zipName = String.format("%s_%s_%s.zip", transDateStr, accNo, onlySequence);
                if (!receiptList.isEmpty() && TodayReceiptUtils.getInstance().isContainsByName(receiptList, zipName)) {
                    isNeedDownloadQuery = false;
                }
                boolean isFlag = true;
                if (isNeedDownloadQuery) {
                    isFlag = oneReceiptDownload.downloadReceipt(accNo, onlySequence, fileType, bankCurrency, transDateStr);
                }
                if (!isFlag) continue;
                DownloadListDetail downloadListDetail = new DownloadListDetail();
                downloadListDetail.setFileName(zipName);
                String fileLink = String.format("today_%s_%s_%s.%s", accNo, transDateStr, onlySequence, fileLastStr);
                downloadListDetail.setFileLink(fileLink);
                result.add(downloadListDetail);
            }
        }
        finally {
            RequestContextUtils.setRunningParam((String)"isTodayTask", (String)"true");
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean isOnlyBySyncRecord() {
        ReceiptSystemProperties receiptSystemProperties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        String isOnlyBySyncRecord = receiptSystemProperties.getIsOnlyBySyncRecord();
        return Objects.equals(isOnlyBySyncRecord, "true");
    }

    public List<DownloadListDetail> doJob_pushMode(DownloadListTask task) {
        File[] files;
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String accNo = task.getAccNo();
        String transDateStr = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate transDate = task.getTransDate();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)task.getBankVersionId(), (String)accNo, (String)transDateStr);
        String bankVersionId = task.getBankVersionId();
        DetailInfoRepository detailInfoRepository = (DetailInfoRepository)SpringContextUtil.getBean(DetailInfoRepository.class);
        List detailInfoList = detailInfoRepository.findByAccNoAndBankVersionIDAndTransDateBetween(accNo, bankVersionId, transDate, transDate);
        int detailCount = 1;
        long diffDays = ChronoUnit.DAYS.between(transDate, LocalDate.now());
        boolean isBeforeThreeMonth = diffDays > 90L;
        boolean isPullDetail = ReceiptCommonAipUtil.isPullRecordByCustomIdTransDateAndAccNo((String)task.getCustomNo(), (LocalDate)transDate, (String)accNo);
        if (!this.isOnlyBySyncRecord() && !isBeforeThreeMonth || isPullDetail && !isBeforeThreeMonth) {
            detailCount = detailInfoList.size();
        }
        boolean flag = false;
        File bakFile = FileCommonUtils.getFileByPath((String)bakFilePath);
        String bankLoginId = EBContext.getContext().getBankLoginID();
        ICBCOpaCommConfig config = (ICBCOpaCommConfig)EBConfigBuilder.getInstance().buildConfig(ICBCOpaCommConfig.class, bankLoginId);
        String pushFileType = config.getPushFileType();
        String unZipDir = FileStorageUtil.getFileBatchBakPathByTransDate((String)bankVersionId, (String)transDateStr);
        String filterTransDate = transDateStr;
        String tempUpZipDir = unZipDir;
        if (Objects.equals(pushFileType, "BJ_VERSION")) {
            filterTransDate = LocalDateUtil.formatDate((LocalDate)transDate, (String)"yyyy-MM-dd");
            tempUpZipDir = tempUpZipDir + File.separator + transDateStr + File.separator + accNo;
        }
        PDFFilter fitler = new PDFFilter(accNo, filterTransDate, pushFileType);
        File unZipFile = FileCommonUtils.getFileByPath((String)tempUpZipDir);
        if (unZipFile.exists() && (files = unZipFile.listFiles(fitler)).length >= detailCount) {
            logger.info("\u5de5\u5546\u94f6\u884c\u5f00\u653e\u5e73\u53f0-\u56de\u5355\u603b\u5305\u5df2\u4e0b\u8f7d-\u65e5\u671f\uff1a{}-\u8d26\u53f7\uff1a{}-temp\u76ee\u5f55\u4e0b\u5b58\u5728\u7684\u56de\u5355\u6570\u91cf\uff1a{} \u4ea4\u6613\u660e\u7ec6\uff1a{}", new Object[]{transDateStr, accNo, files.length, detailCount});
            for (int i = 0; i < files.length; ++i) {
                DownloadListDetail detail = new DownloadListDetail();
                detail.setFileName(files[i].getName());
                boolean isSuccess = FileCommonUtils.moveFile((File)files[i], (String)bakFilePath, (String)files[i].getName());
                if (!isSuccess) continue;
                result.add(detail);
            }
            return result;
        }
        if (bakFile.exists() && (files = bakFile.listFiles(fitler)).length >= detailCount) {
            logger.info("\u5de5\u5546\u94f6\u884c\u5f00\u653e\u5e73\u53f0-\u56de\u5355\u603b\u5305\u5df2\u4e0b\u8f7d-\u65e5\u671f\uff1a{}-\u8d26\u53f7\uff1a{}-bak\u76ee\u5f55\u4e0b\u5b58\u5728\u7684\u56de\u5355\u6570\u91cf\uff1a{} \u4ea4\u6613\u660e\u7ec6\uff1a{}", new Object[]{transDateStr, accNo, files.length, detailCount});
            for (int i = 0; i < files.length; ++i) {
                DownloadListDetail detail = new DownloadListDetail();
                detail.setFileName(files[i].getName());
                result.add(detail);
            }
            return result;
        }
        if (!flag) {
            List<String> fileList = this.getFileList(task);
            for (String fileName : fileList) {
                DownloadListDetail detail = new DownloadListDetail();
                detail.setFileName(fileName);
                detail.setBankFilePath(bakFilePath + File.separator + fileName);
                detail.setTransDate(task.getTransDate());
                result.add(detail);
            }
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]));
        }
        return result;
    }

    private List<String> getFileList(DownloadListTask task) {
        ArrayList<String> fileList = new ArrayList<String>(16);
        String bankVersionId = task.getBankVersionId();
        String accNo = task.getAccNo();
        String bankLoginId = task.getBankLoginId();
        LocalDate transDate = task.getTransDate();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        LocalDate localDate = transDate;
        String transDateStr = transDate.format(DateTimeFormatter.BASIC_ISO_DATE);
        BankFtpProperties ftpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        String sftp_path = ftpProperties.getFtpPath();
        String ftpPath = sftp_path = EBGStringUtils.isNotEmpty((String)sftp_path) ? sftp_path : "/";
        ChannelSftp sftp = null;
        String tempPath = FileStorageUtil.getFileBakPath((String)bankVersionId) + File.separator + transDateStr;
        String unZipDir = FileStorageUtil.getFileBatchBakPathByTransDate((String)bankVersionId, (String)transDateStr);
        ICBCOpaCommConfig config = (ICBCOpaCommConfig)EBConfigBuilder.getInstance().buildConfig(ICBCOpaCommConfig.class, bankLoginId);
        String pushFileType = config.getPushFileType();
        String filterTransDate = transDateStr;
        String tempUpZipDir = unZipDir;
        if (Objects.equals(pushFileType, "BJ_VERSION")) {
            filterTransDate = LocalDateUtil.formatDate((LocalDate)transDate, (String)"yyyy-MM-dd");
            tempUpZipDir = tempUpZipDir + File.separator + transDateStr + File.separator + accNo;
        }
        try {
            List<String> filenames;
            if (ftpProperties.getReceiptAchieveWay().equals("sftp")) {
                Vector vector;
                if (SFTPUtils.getInstance().isAbort(sftp)) {
                    sftp = SFTPUtils.getInstance().getSftp();
                }
                if (sftp != null && EBGStringUtils.isNotEmpty((String)ftpPath) && !(vector = sftp.ls(ftpPath)).isEmpty()) {
                    String fileName = "";
                    boolean isCdPath = true;
                    for (int i = 0; i < vector.size(); ++i) {
                        ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)vector.get(i);
                        fileName = file.getFilename();
                        Date modifyTime = TodayReceiptUtils.getInstance().getSftpModifyTime(file);
                        LocalDate modifyDate = LocalDateUtil.date2LocalDate((Date)modifyTime);
                        if (!fileName.endsWith(".zip") || modifyDate.equals(transDate)) continue;
                        try {
                            String fileDate = "";
                            fileDate = Objects.equals(pushFileType, "BJ_VERSION") ? fileName.split("_")[0] : fileName.split("_")[1];
                            String ld = localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                            if ((EBGStringUtils.isEmpty((String)fileDate) || !fileDate.contains(ld)) && !fileName.contains(ld) || fileName.contains("_DZD_Month")) continue;
                            if (!isCdPath) {
                                ftpPath = "";
                            }
                            RequestContextUtils.setZipName((String)fileName);
                            boolean flag = SFTPUtils.getInstance().downloadSingleFile(ftpPath, fileName, tempPath, sftp);
                            if (!flag) continue;
                            isCdPath = false;
                            List<String> receiptList = BankReceiptFetchListImpl.readZipFiles(tempPath + File.separator + fileName);
                            logger.info("\u5de5\u884c-{}-{}-\u538b\u7f29\u5305\uff1a{}-\u5b58\u5728\u7684\u56de\u5355\u6587\u4ef6\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, fileName, receiptList.size()});
                            if (receiptList == null || receiptList.size() == 0) {
                                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6%s\u4e0d\u5305\u542bpdf\u683c\u5f0f\u7684\u56de\u5355\u6587\u4ef6\u3002", (String)"BankReceiptFetchListImpl_6", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]), fileName));
                            }
                            if (!GZFileUtils.unZipFiles((String)(tempPath + File.separator + fileName), (String)unZipDir)) continue;
                            File accFile = FileCommonUtils.getFileByPath((String)tempUpZipDir);
                            if (accFile.exists()) {
                                PDFFilter fitler = new PDFFilter(accNo, filterTransDate, pushFileType);
                                File[] files = accFile.listFiles(fitler);
                                logger.info("\u5de5\u884c-{}-{}-\u538b\u7f29\u5305\uff1a{}-\u5b58\u5728\u8be5\u8d26\u53f7\u56de\u5355\u6587\u4ef6\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, fileName, files.length});
                                if (files.length > 0) {
                                    for (int j = 0; j < files.length; ++j) {
                                        if (!FileCommonUtils.moveFile((File)files[j], (String)bakFilePath, (String)files[j].getName())) continue;
                                        fileList.add(files[j].getName());
                                    }
                                }
                            }
                            FileCommonUtils.getFileByPath((String)(tempPath + File.separator + fileName)).delete();
                            File unZipFile = FileCommonUtils.getFileByPath((String)tempUpZipDir);
                            if (!unZipFile.exists() || !unZipFile.isDirectory() || unZipFile.listFiles().length != 0) continue;
                            FileCommonUtils.deleteFile((File)unZipFile);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            } else if (ftpProperties.getReceiptAchieveWay().equals("bank_login") && (filenames = this.getFileByName(transDateStr, task.getAccNo(), task.getTransDate(), ".zip")) != null && filenames.size() > 0) {
                for (String filename : filenames) {
                    if (filename.contains("_DZD_Month")) continue;
                    RequestContextUtils.setZipName((String)filename);
                    BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, task.getTransDate());
                    boolean flag = bankReceiptApiUtil.downloadReceiptFile(filename, tempPath);
                    ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>(16);
                    PDFFilter fitler = new PDFFilter(accNo, filterTransDate, pushFileType);
                    this.handleFiles(fileList, detailList, filename, transDateStr, accNo, flag, fitler, tempPath, tempUpZipDir);
                }
            }
        }
        catch (Exception e) {
            try {
                String msg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5de5\u884c\u7535\u5b50\u56de\u5355\u6587\u4ef6\u5217\u8868\u4efb\u52a1\uff0cSFTP\u53d1\u751f\u5f02\u5e38\uff1a%s\u3002\u8bf7\u68c0\u67e5\u56de\u5355\u5e73\u53f0SFTP\u914d\u7f6e\u4fe1\u606f\u548cSFTP\u670d\u52a1\u662f\u5426\u6b63\u5e38\u8fd0\u884c\uff0c\u5e76\u4f7f\u7528SFTP\u5de5\u5177\u786e\u8ba4\u662f\u5426\u53ef\u8fde\u901a\u3002", (String)"BankReceiptFetchListImpl_7", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]), e.getMessage());
                throw new ReceiptException(msg, e.getCause());
            }
            catch (Throwable throwable) {
                SFTPUtils.getInstance().close(sftp);
                throw throwable;
            }
        }
        SFTPUtils.getInstance().close(sftp);
        return fileList;
    }

    private void handleFiles(List<String> fileList, List<DownloadListDetail> detailList, String fileName, String transDate, String accNo, boolean flag, PDFFilter fitler, String tempPath, String tempUpZipDir) {
        if (flag) {
            String bankVersionId = EBContext.getContext().getBankVersionID();
            String unZipDir = FileStorageUtil.getFileBatchBakPathByTransDate((String)bankVersionId, (String)transDate);
            if (GZFileUtils.unZipFiles((String)(tempPath + File.separator + fileName), (String)unZipDir)) {
                File accFile = FileCommonUtils.getFileByPath((String)tempUpZipDir);
                if (accFile.exists()) {
                    File[] files = accFile.listFiles(fitler);
                    if (files.length > 0) {
                        String bakPath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)transDate);
                        for (int j = 0; j < files.length; ++j) {
                            fileList.add(files[j].getName());
                            DownloadListDetail detail = new DownloadListDetail();
                            detail.setFileName(files[j].getName());
                            detailList.add(detail);
                            File sourceFile = FileCommonUtils.getFileByPath((String)(tempUpZipDir + File.separator + files[j].getName()));
                            if (!sourceFile.exists() || !FileCommonUtils.moveFile((File)sourceFile, (String)bakPath, (String)sourceFile.getName())) continue;
                            FileCommonUtils.deleteFile((File)sourceFile);
                        }
                    }
                    logger.info("\u83b7\u53d6\u8d26\u53f7\u6587\u4ef6\u660e\u7ec6\u5b8c\u6bd5...");
                }
                FileCommonUtils.getFileByPath((String)(tempPath + File.separator + fileName)).delete();
                File unZipFile = FileCommonUtils.getFileByPath((String)tempUpZipDir);
                if (unZipFile.exists() && unZipFile.isDirectory() && unZipFile.listFiles().length == 0) {
                    FileCommonUtils.deleteFile((File)unZipFile);
                }
            }
        }
    }

    private List<String> getFileByName(String matchString, String accNo, LocalDate transDate, String suffix) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.getFileByName(matchString, suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readZipFiles(String patchPath) {
        ArrayList<String> fileList = new ArrayList<String>(16);
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(patchPath);
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)e.nextElement();
                System.out.println(entry.getName());
                if (entry.isDirectory() || !entry.getName().endsWith(".pdf") && !entry.getName().endsWith(".PDF") && !entry.getName().endsWith(".ofd") && !entry.getName().endsWith(".OFD")) continue;
                fileList.add(entry.getName());
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
        return fileList;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "ICMC_OPA_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u5de5\u5546\u94f6\u884c\u5f00\u653e\u5e73\u53f0\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_5", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return EBGStringUtils.isNotEmpty((String)RequestContextUtils.getRunningParam((String)"isTodayTask"));
    }

    static class PDFFilter
    implements FileFilter {
        private String transDate;
        private String accNo;
        private String pushFileType;

        public PDFFilter(String accNo, String transDate, String pushFileType) {
            this.accNo = accNo;
            this.transDate = transDate;
            this.pushFileType = pushFileType;
        }

        @Override
        public boolean accept(File file) {
            ICBCOpaFileParser icbcOpaFileParser = new ICBCOpaFileParser();
            icbcOpaFileParser.setFileName(file.getName());
            if (icbcOpaFileParser.getFileSplitLength() == 3) {
                return false;
            }
            if (Objects.equals(this.pushFileType, "OFD")) {
                return file.getName().contains(this.transDate) && file.getName().contains(this.accNo) && file.getName().toLowerCase(Locale.ENGLISH).contains(".ofd");
            }
            return file.getName().contains(this.transDate) && file.getName().contains(this.accNo) && file.getName().toLowerCase(Locale.ENGLISH).contains(".pdf");
        }
    }
}

