/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.crcb.dc.service.receipt;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.crcb.dc.service.receipt.CrcbDcCommConfig;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadTaskStatusEnum;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.DownloadUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        DownloadTaskService downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        DownloadListTask task = downloadTaskService.findById(taskId);
        String accNo = request.getAccNo();
        String bankLogin = task.getBankLoginId();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        LocalDate transDate = request.getTransDate();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        if (downloadListDetails.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-crcb-dc", (Object[])new Object[0]));
        }
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"CRCB_DC", (String)accNo, (String)transDateStr);
        CrcbDcCommConfig crcbDcCommConfig = (CrcbDcCommConfig)EBConfigBuilder.getInstance().buildConfig(CrcbDcCommConfig.class, bankLogin);
        for (DownloadListDetail detail : downloadListDetails) {
            String fileLink = detail.getFileLink();
            String fileName = detail.getFileName();
            if (detail.getUploadFlag().intValue() == UploadTaskStatusEnum.UPLOAD_SUCCESS.getId()) continue;
            JSONObject jsonObject = JSONObject.parseObject((String)fileLink);
            String downloadFileNme = jsonObject.getString("downloadFileNme");
            String verifyCode = jsonObject.getString("verifyCode");
            String urlPre = crcbDcCommConfig.getReceipt_download_pre();
            if (StringUtils.isEmpty((String)urlPre)) {
                throw new ReceiptException(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-crcb-dc", (Object[])new Object[0]));
            }
            StringBuilder url = new StringBuilder();
            url.append(urlPre).append("?DownloadFileNme=").append(downloadFileNme);
            url.append("&electricNo=").append(verifyCode);
            String fileUrl = url.toString();
            if (fileUrl.contains("http")) {
                RequestContextUtils.setRunningParam((String)"exchangeProtocol", (String)"http");
            } else {
                RequestContextUtils.setRunningParam((String)"exchangeProtocol", (String)"https");
            }
            DownloadUtils.download((String)url.toString(), (String)fileName, (String)bakFilePath);
            result.add(detail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u4e3a\u7a7a\u3002", (String)"BankReceiptDownloadImpl_2", (String)"ebg-receipt-banks-crcb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CRCB_DC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u91cd\u5e86\u519c\u5546\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u3002", (String)"BankReceiptDownloadImpl_3", (String)"ebg-receipt-banks-crcb-dc", (Object[])new Object[0]);
    }
}

