/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.crcb.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.receipt.banks.crcb.dc.service.helper.RequestPacker;
import kd.ebg.receipt.banks.crcb.dc.service.helper.ResponseParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;

public class BankQueryReceiptListImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static int size = 20;

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        int startIndex = Integer.parseInt(this.getCurrentPage());
        return RequestPacker.packReceiptQueryMessage(accNo, transDate, startIndex);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        List<String> results = ResponseParser.parserReceiptMessage(responseStr);
        if (results.size() == 0 || results.size() < size) {
            this.setLastPage(true);
        }
        return BankReceiptResponseEB.success(results);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "CL0146";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u7535\u5b50\u56de\u5355\u5217\u8868\u4fe1\u606f\u3002", (String)"BankQueryReceiptListImpl_0", (String)"ebg-receipt-banks-crcb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml;charset=UTF-8");
    }

    public static List<String> queryReceiptList(String accNo, LocalDate transDate) {
        ArrayList<String> result = new ArrayList<String>(16);
        BankQueryReceiptListImpl bankQueryReceiptList = new BankQueryReceiptListImpl();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        bankQueryReceiptList.setCurrentPage("0");
        boolean lastPage = false;
        bankQueryReceiptList.setLastPage(false);
        while (!lastPage) {
            BankReceiptResponseEB response = bankQueryReceiptList.doBiz(bankReceiptRequest);
            if (Objects.nonNull(response) && Objects.nonNull(response.getData())) {
                result.addAll((List)response.getData());
            }
            bankQueryReceiptList.setCurrentPage(Integer.parseInt(bankQueryReceiptList.getCurrentPage()) + size);
            lastPage = bankQueryReceiptList.isLastPage();
        }
        return result;
    }
}

