/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.czccb.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.banks.czccb.dc.service.receipt.api.DetailPage;
import kd.ebg.receipt.banks.czccb.dc.service.receipt.util.HisDetailPacker;
import kd.ebg.receipt.banks.czccb.dc.service.receipt.util.HisDetailParser;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IHisDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.model.DetailInfo;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail {
    public HisDetailPacker hisDetailPacker = new HisDetailPacker();
    public HisDetailParser hisDetailParser = new HisDetailParser();
    public DetailPage detailPage = new DetailPage();

    public static List<DetailInfo> queryReceiptList(String accNo, LocalDate transDate) {
        DetailImpl detail = new DetailImpl();
        BankDetailRequest request = new BankDetailRequest();
        BankAcnt bankAcnt = new BankAcnt();
        BankHeader header = new BankHeader();
        header.setAcnt(bankAcnt);
        bankAcnt.setAccNo(accNo);
        request.setEndDate(transDate);
        request.setStartDate(transDate);
        request.setHeader(header);
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        detail.setCurrentPage(detail.detailPage.getFirstPageTag());
        boolean lastPage = false;
        detail.setLastPage(false);
        while (!lastPage) {
            EBBankDetailResponse response = detail.doBiz(request);
            List receiveItems = response.getDetails();
            if (Objects.nonNull(response) && Objects.nonNull(receiveItems)) {
                detailInfos.addAll(receiveItems);
            }
            lastPage = detail.isLastPage();
        }
        return detailInfos;
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        String pageTag = this.getCurrentPage();
        String rqstStr = this.hisDetailPacker.packDetail(bankDetailRequest, pageTag);
        return rqstStr;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        EBBankDetailResponse response = new EBBankDetailResponse();
        String pageTag = this.getCurrentPage();
        this.setLastPage(this.detailPage.isLastPage(rspStr, pageTag));
        List<DetailInfo> detailInfos = this.hisDetailParser.parseDetail(bankDetailRequest, rspStr);
        response.setDetails(detailInfos);
        this.setCurrentPage(this.detailPage.getNextPageTag(rspStr, pageTag));
        return response;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CBE010102";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6", (String)"HisDetailImpl_0", (String)"ebg-receipt-banks-czccb-dc", (Object[])new Object[0]);
    }
}

