/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.sjb.cms.service.api;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.sjb.cms.service.proxy.ProxyDownload;
import kd.ebg.receipt.banks.sjb.cms.utils.TCommon;
import kd.ebg.receipt.banks.sjb.cms.utils.TPacker;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Element;

public class Receipt529761Impl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(Receipt529761Impl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        Element ap = TPacker.createCommonHead("529761", Sequence.gen16Sequence());
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        BankAcnt acnt = bankReceiptRequest.getAcnt();
        String date = bankReceiptRequest.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        JDomUtils.addChild((Element)body, (String)"acno", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)acnt.getCurrency());
        JDomUtils.addChild((Element)body, (String)"begin_date", (String)date);
        JDomUtils.addChild((Element)body, (String)"end_date", (String)date);
        JDomUtils.addChild((Element)body, (String)"crdr_flag", (String)"");
        JDomUtils.addChild((Element)body, (String)"amt", (String)"");
        JDomUtils.addChild((Element)body, (String)"opp_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"opp_acname", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        try {
            return TCommon.createCommonMsg(xmlMsg, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        String content;
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = TCommon.parseBankResponse(head);
        if (!"0_0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5168\u6e20\u9053\u7535\u5b50\u56de\u5355\u67e5\u8be2\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\uff0c%2$s\u3002", (String)"Receipt529761Impl_0", (String)"ebg-receipt-banks-sjb-cms", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element body = ap.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            logger.error("###\u65e0\u56de\u5355\u4fe1\u606f\u3002");
            return BankReceiptResponseEB.success();
        }
        String file_flag = head.getChildTextTrim("file_flag");
        String fileName = "";
        if ("1".equalsIgnoreCase(file_flag)) {
            logger.info("##\u8fd4\u56de'\u6587\u4ef6'");
            fileName = body.getChildTextTrim("file_name");
            content = (String)new ProxyDownload().doBiz(BankReceiptRequest.builder().accNo(bankReceiptRequest.getAcnt().getAccNo()).transDate(bankReceiptRequest.getTransDate()).requestStr(fileName).build()).getData();
        } else {
            logger.info("##\u8fd4\u56de'\u62a5\u6587'");
            content = body.getChildTextTrim("serial_record");
        }
        HashMap<String, String> resp = new HashMap<String, String>(4);
        resp.put("recordNum", record_num);
        resp.put("fieldNum", field_num);
        resp.put("content", content);
        resp.put("fileName", fileName);
        return BankReceiptResponseEB.success(resp);
    }

    public String getDeveloper() {
        return "567";
    }

    public String getBizCode() {
        return "529761";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"3.25\u5168\u6e20\u9053\u7535\u5b50\u56de\u5355\u67e5\u8be2 (529761\u4ea4\u6613)\u3002", (String)"Receipt529761Impl_1", (String)"ebg-receipt-banks-sjb-cms", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return TCommon.parseRecvMsg(super.recv(inputStream));
    }
}

