/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bjb.opa.service.receipt.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.receipt.banks.bjb.opa.service.utils.CommonPacker;
import kd.ebg.receipt.banks.bjb.opa.service.utils.CommonUtils;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.model.DetailInfo;

public class ReceiptDetailImpl
extends AbstractDetailImpl
implements IDetail {
    EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractDetailImpl.class);

    public int getFirstPage() {
        return 0;
    }

    public String pack(BankDetailRequest request) {
        JSONObject requestJson = CommonPacker.createData(this.getBizCode());
        requestJson.put("accountNo", (Object)request.getAcnt().getAccNo());
        requestJson.put("beginDate", (Object)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        requestJson.put("endDate", (Object)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        requestJson.put("beginAmt", (Object)"0.00");
        requestJson.put("endAmt", (Object)"999999999999.00");
        int currentPage = Integer.parseInt(this.getCurrentPage());
        requestJson.put("turnPageBeginPos", (Object)String.valueOf(currentPage * 999 + 1));
        requestJson.put("turnPageShowNum", (Object)Integer.toString(999));
        requestJson.put("startPageNo", (Object)this.getCurrentPage());
        requestJson.put("pageSize", (Object)"100");
        String xmlRequest = CommonPacker.createRequest("receipt", requestJson.toJSONString());
        return xmlRequest;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String res) {
        int currentPage;
        this.setLastPage(true);
        res = CommonPacker.parseResponse(res);
        CommonUtils.checkSuccess(res);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        JSONObject response = JSONObject.parseObject((String)res);
        JSONArray opResultSet = response.getJSONArray("opResultSet");
        if (opResultSet.size() == 0) {
            return new EBBankDetailResponse(detailList);
        }
        String totalNum = response.getString("turnPageTotalNum");
        int turnPageTotalNum = Integer.parseInt(totalNum);
        if (turnPageTotalNum > ((currentPage = Integer.parseInt(this.getCurrentPage())) + 1) * 999) {
            this.setLastPage(false);
        }
        for (int i = 0; i < opResultSet.size(); ++i) {
            try {
                JSONObject opResult = opResultSet.getJSONObject(i);
                DetailInfo detailInfo = new DetailInfo();
                String billNumber = opResult.getString("billNumber");
                String amount = opResult.getString("amount");
                String kernelNum = opResult.getString("kernelNum");
                detailInfo.setReceiptNo(billNumber);
                detailInfo.setBankSerialNo(kernelNum);
                detailInfo.setAmount(amount);
                detailInfo.setJson(opResult.toJSONString());
                detailList.add(detailInfo);
                continue;
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CebankQueryBillNumNewOp";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u67e5\u8be2", (String)"ReceiptDetailImpl_0", (String)"ebg-receipt-banks-bjb-opa", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }
}

