/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ceb.dc.service.receipt;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.ceb.dc.service.CebDCCommConfig;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.api.BankReceiptFileDownloadImpl;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.api.ofd.BankOFDReceiptFileDownloadImpl;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.api.ofd.BankReceiptFileAppointmentQueryImpl;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.util.ofd.ReceiptQueryInfo;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.bank.BankLoginProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String bankLoginId = request.getBankLoginId();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String accNo = request.getAccNo();
        String bankVersionId = request.getBankVersionId();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        CebDCCommConfig config = (CebDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CebDCCommConfig.class, bankLoginId);
        boolean isPdf = config.getReceiptFileType().equals("PDF");
        RequestContextUtils.setRunningParam((String)"cipher", (String)config.getCipher());
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        BankLoginProperties loginProperties = (BankLoginProperties)EBConfigBuilder.getInstance().buildConfig(BankLoginProperties.class, bankLoginId);
        if (isPdf) {
            boolean isLastFile = false;
            for (int i = 0; i < downloadListDetails.size(); ++i) {
                if (i == downloadListDetails.size() - 1) {
                    isLastFile = true;
                }
                DownloadListDetail downloadListDetail = (DownloadListDetail)downloadListDetails.get(i);
                String fileName = downloadListDetail.getFileName();
                String receiptFilePath = bakFilePath + File.separator + fileName;
                File receiptFile = FileCommonUtils.getFileByPath((String)receiptFilePath);
                if (!receiptFile.exists() && downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                    List<DownloadListDetail> details = this.download(downloadListDetail, isLastFile, bankLoginId, loginProperties, bankFtpProperties, config, bakFilePath);
                    result.addAll(details);
                    continue;
                }
                result.add(downloadListDetail);
            }
        } else {
            DownloadListTask task = this.downloadTaskService.findById(taskId);
            String bankLogin = EBContext.getContext().getBankLoginID();
            String bakPathParentPath = FileStorageUtil.getFileBakPath((String)bankLogin) + File.separator + transDateStr;
            for (int i = 0; i < downloadListDetails.size(); ++i) {
                JSONObject jsonObject;
                DownloadListDetail downloadListDetail = (DownloadListDetail)downloadListDetails.get(i);
                if (downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                    result.add(downloadListDetail);
                    continue;
                }
                String fileLink = downloadListDetail.getFileLink();
                try {
                    jsonObject = JSONObject.parseObject((String)fileLink);
                }
                catch (Exception e) {
                    throw new ReceiptException((Throwable)e);
                }
                BankReceiptFileAppointmentQueryImpl bankReceiptFileAppointment = new BankReceiptFileAppointmentQueryImpl();
                HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
                paramMap.put("ClientBchID", jsonObject.get((Object)"ClientBchID"));
                paramMap.put("ClientPchID", jsonObject.get((Object)"ClientPchID"));
                BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap((Map)paramMap).build();
                BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)bankReceiptFileAppointment.doBiz((BankRequest)bankReceiptRequest);
                List receiptQueryInfoList = (List)receiptResponseEB.getData();
                for (ReceiptQueryInfo receiptQueryInfo : receiptQueryInfoList) {
                    String fileName = receiptQueryInfo.getFileName();
                    String filePath = receiptQueryInfo.getFilePath();
                    HashMap runningParams = Maps.newHashMapWithExpectedSize((int)16);
                    runningParams.put("fileName", fileName);
                    runningParams.put("filePath", filePath);
                    EBContext.getContext().setRunningParams((Map)runningParams);
                    BankOFDReceiptFileDownloadImpl bankOFDReceiptFileDownload = new BankOFDReceiptFileDownloadImpl();
                    BankReceiptRequest bankRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
                    bankOFDReceiptFileDownload.doBiz((BankRequest)bankRequest);
                    this.download(fileName, transDate, accNo, bankLoginId, bankFtpProperties, bakPathParentPath);
                    List details = FileCommonUtils.getDetailList((DownloadListTask)task, (String)fileName);
                    for (DownloadListDetail detail : details) {
                        String receiptName = detail.getFileName();
                        StringBuilder newReceiptName = new StringBuilder();
                        newReceiptName.append(accNo).append("_");
                        newReceiptName.append(transDateStr).append("_");
                        newReceiptName.append(receiptName);
                        StringBuilder receiptPath = new StringBuilder();
                        receiptPath.append(bakFilePath).append(File.separator).append(receiptName);
                        File receiptFile = FileCommonUtils.getFileByPath((String)receiptPath.toString());
                        boolean isRename = FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)newReceiptName.toString());
                        if (!isRename) continue;
                        detail.setFileName(newReceiptName.toString());
                        detail.setFileLink(fileLink);
                        result.add(detail);
                    }
                }
            }
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u4e3a\u7a7a", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> download(DownloadListDetail detail, boolean isLastFile, String bankLoginId, BankLoginProperties loginProperties, BankFtpProperties bankFtpProperties, CebDCCommConfig config, String bakFilePath) {
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        ChannelSftp sftp = null;
        LocalDate transDate = detail.getTransDate();
        String localDate = transDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String accNo = detail.getAccNo();
        String fileName = detail.getFileLink();
        BankReceiptRequest receiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        RequestContextUtils.setRunningParam((String)"fileName", (String)fileName);
        BankReceiptFileDownloadImpl iBankReceipt = new BankReceiptFileDownloadImpl();
        iBankReceipt.doBiz((BankRequest)receiptRequest);
        String sftp_path = bankFtpProperties.getFtpPath();
        String string = sftp_path = EBGStringUtils.isEmpty((String)sftp_path) ? "/" + localDate : sftp_path + "/" + localDate;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp(bankLoginId);
            }
            String nowLocalPath = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            String nowSftp_path = bankFtpProperties.getFtpPath();
            nowSftp_path = EBGStringUtils.isEmpty((String)nowSftp_path) ? "/" + nowLocalPath : nowSftp_path + "/" + nowLocalPath;
            boolean flag = SFTPUtils.getInstance().downloadSingleFile(nowSftp_path, detail.getFileLink(), bakFilePath, sftp);
            if (!flag) {
                flag = SFTPUtils.getInstance().downloadSingleFile(sftp_path, detail.getFileLink(), bakFilePath, sftp);
            }
            logger.info("CEB_DC-sftp\u4e0b\u8f7d-{}-{}-\u538b\u7f29\u5305\uff1a{}-\u4e0b\u8f7d\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{accNo, localDate, detail.getFileLink(), flag});
            File file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + detail.getFileLink()));
            if (file.exists()) {
                FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)detail.getFileName());
                detail.setBankFilePath(bakFilePath + File.separator + detail.getFileName());
                result.add(detail);
            }
            if (isLastFile) {
                SFTPUtils.getInstance().close(sftp);
            }
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            List<String> tempFiles = this.getFileByName(detail.getFileLink(), accNo, transDate);
            String ftpPath = bankFtpProperties.getFrontProxyPath() + File.separator + transDate;
            if (tempFiles == null || tempFiles.size() == 0) {
                tempFiles = this.getFileByName(detail.getFileLink(), accNo, LocalDate.now());
                ftpPath = bankFtpProperties.getFrontProxyPath() + File.separator + LocalDate.now();
            }
            if (tempFiles != null && tempFiles.size() != 0) {
                for (String tempFileName : tempFiles) {
                    if (!tempFileName.contains(detail.getFileLink())) continue;
                    BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                    boolean flag = bankReceiptApiUtil.downloadReceiptFileWithPath(ftpPath, fileName, bakFilePath);
                    File file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + detail.getFileLink()));
                    if (file.exists()) {
                        flag = FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)detail.getFileName());
                        logger.info("\u5149\u5927\u94f6\u884c\u901a\u8fc7\u4ee3\u7406\u83b7\u53d6\u56de\u5355\u6587\u4ef6====\u91cd\u547d\u540d\u7ed3\u679c:{} ", (Object)flag);
                        detail.setBankFilePath(bakFilePath + File.separator + detail.getFileName());
                        result.add(detail);
                        continue;
                    }
                    flag = false;
                }
            }
        }
        return result;
    }

    public void download(String zipName, LocalDate transDate, String accNo, String bankLoginId, BankFtpProperties bankFtpProperties, String bakPathParentPath) {
        ChannelSftp sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            boolean flag;
            String sftp_path = bankFtpProperties.getFtpPath();
            String string = sftp_path = EBGStringUtils.isEmpty((String)sftp_path) ? "/" + LocalDate.now() : sftp_path + "/" + LocalDate.now();
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp(bankLoginId);
            }
            if (!(flag = SFTPUtils.getInstance().downloadSingleFile(sftp_path, zipName, bakPathParentPath, sftp))) {
                sftp_path = bankFtpProperties.getFtpPath();
                sftp_path = EBGStringUtils.isEmpty((String)sftp_path) ? "/" + transDate : sftp_path + "/" + transDate;
                flag = SFTPUtils.getInstance().downloadSingleFile(sftp_path, zipName, bakPathParentPath, sftp);
            }
            logger.info("CEB_DC-OFD\u538b\u7f29\u5305sftp\u4e0b\u8f7d-{}-{}-\u538b\u7f29\u5305\uff1a{}-\u4e0b\u8f7d\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{accNo, transDate, zipName, flag});
            SFTPUtils.getInstance().close(sftp);
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            String ftpPath = bankFtpProperties.getFrontProxyPath() + File.separator + transDate;
            List<String> tempFiles = this.getFileByName(zipName, accNo, transDate);
            if (tempFiles == null || tempFiles.size() == 0) {
                tempFiles = this.getFileByName(zipName, accNo, LocalDate.now());
                ftpPath = bankFtpProperties.getFrontProxyPath() + File.separator + LocalDate.now();
            }
            if (tempFiles != null && tempFiles.size() != 0) {
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                boolean flag = bankReceiptApiUtil.downloadReceiptFileWithPath(ftpPath, zipName, bakPathParentPath);
                logger.info("CEB_DC-OFD\u538b\u7f29\u5305\u4ee3\u7406\u7a0b\u5e8f\u4e0b\u8f7d-{}-{}-\u538b\u7f29\u5305\uff1a{}-\u4e0b\u8f7d\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{accNo, transDate, zipName, flag});
            }
        }
        File file = FileCommonUtils.getFileByPath((String)(bakPathParentPath + File.separator + zipName));
        if (!file.exists()) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(ResManager.loadKDString((String)"\u538b\u7f29\u5305\uff1a", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0])).append(zipName).append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"BankReceiptDownloadImpl_2", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]));
            throw new ReceiptException(errorMsg.toString());
        }
    }

    private List<String> getFileByName(String matchString, String accNo, LocalDate transDate) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.getFileByName(matchString);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CEB_DC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5149\u5927\u94f6\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_3", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]);
    }
}

