/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.drcb.cmp.service.receipt.api;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.drcb.cmp.service.util.Packer;
import kd.ebg.receipt.banks.drcb.cmp.service.util.Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Element;

public class ReceiptCreateImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptCreateImpl.class);

    public String pack(BankReceiptRequest request) {
        LocalDate transDate = request.getTransDate();
        JSONObject jsonObject = JSONObject.parseObject((String)request.getRequestStr());
        Element root = Packer.createHead(this.getBizCode(), request.getHeader().getRequestSeqID());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"tran_type", (String)"1");
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)"1");
        if (!transDate.equals(LocalDate.now())) {
            JDomUtils.addChild((Element)body, (String)"host_serial_no", (String)jsonObject.getString("host_serial_no"));
            JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)jsonObject.getString("tr_acdt"));
            JDomUtils.addChild((Element)body, (String)"tr_time", (String)jsonObject.getString("tr_time"));
            JDomUtils.addChild((Element)body, (String)"acno", (String)jsonObject.getString("acno"));
            JDomUtils.addChild((Element)body, (String)"opp_acno", (String)jsonObject.getString("opp_acno"));
            JDomUtils.addChild((Element)body, (String)"amt", (String)jsonObject.getString("amt"));
            JDomUtils.addChild((Element)body, (String)"crdr_flag", (String)jsonObject.getString("crdr_flag"));
            JDomUtils.addChild((Element)body, (String)"balacne", (String)jsonObject.getString("balacne"));
        }
        String xmlMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlMessage);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parserHead(root);
        if (!"0".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5355\u7b14\u56de\u5355\u6253\u5370\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u54cd\u5e94\u7801\uff1a%1$s\uff0c\u54cd\u5e94\u4fe1\u606f\uff1a%2$s\u3002", (String)"ReceiptCreateImpl_1", (String)"ebg-receipt-banks-drcb-cmp", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element head = root.getChild("head");
        Element body = root.getChild("body");
        if (null == body || null == body.getChildren() || body.getChildren().size() == 0) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5355\u7b14\u56de\u5355\u6253\u5370\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u54cd\u5e94\u7801\uff1a%1$s\uff0c\u54cd\u5e94\u4fe1\u606f\uff1a%2$s\u3002", (String)"ReceiptCreateImpl_1", (String)"ebg-receipt-banks-drcb-cmp", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        String file_name = body.getChildTextTrim("file_name");
        return BankReceiptResponseEB.success((Object)file_name);
    }

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "548249";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/corporbank/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
    }
}

