/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.framework;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class EBThreadPools {
    private static final String EB = "eb";
    private static final Map<String, ThreadPool> bankThreadPools = new ConcurrentHashMap<String, ThreadPool>(50);
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(EBThreadPools.class);
    private static int coreThread = 1;

    public static ThreadPool getThreadPool(String type, String bankLoginId, String customId) {
        String telnetId = RequestContext.get().getAccountId();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(EB);
        stringBuilder.append("_");
        stringBuilder.append(type);
        stringBuilder.append("_");
        stringBuilder.append(bankLoginId);
        stringBuilder.append("_");
        stringBuilder.append(customId);
        stringBuilder.append("_");
        stringBuilder.append(telnetId);
        String key = stringBuilder.toString();
        if (Objects.equals(type, "create")) {
            key = "eb_" + type + "_" + customId + "_" + telnetId;
        }
        if (!bankThreadPools.containsKey(key)) {
            try {
                String coreThreadStr = System.getProperty("receipt.coreThread");
                if (!EBGStringUtils.isEmpty((String)coreThreadStr) && (coreThread = Integer.parseInt(coreThreadStr)) < 1) {
                    coreThread = 1;
                }
            }
            catch (Exception e) {
                coreThread = 1;
            }
            try {
                ThreadPool executor = ThreadPools.newFixedThreadPool((String)key, (int)coreThread);
                bankThreadPools.put(key, executor);
            }
            catch (RuntimeException e) {
                logger.error("\u56de\u5355\u8c03\u5ea6\u521b\u5efa\u7ebf\u7a0b\u6c60\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
            }
        }
        return bankThreadPools.get(key);
    }
}

