/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.handler;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.model.bank.BankListEntity;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.entity.HandlerType;
import kd.ebg.receipt.business.receipt.entity.ReceiptHandlerRequest;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.framework.EBThreadPools;
import kd.ebg.receipt.business.receipt.framework.ScheduleHanlder;
import kd.ebg.receipt.business.receipt.framework.TaskActuator;
import kd.ebg.receipt.business.receipt.framework.TaskFactory;
import kd.ebg.receipt.business.receipt.utils.ReceiptTaskHandleUtils;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.BankBundleManager;
import kd.ebg.receipt.common.framework.frame.BankVersion;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class DownLoadTaskHandler
extends ScheduleHanlder {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DownLoadTaskHandler.class);
    private BankLoginService bankLoginService;
    private BankVersionService bankVersionService;
    private BankAcntService bankAcntService;
    private DownloadTaskService downloadTaskService;
    private DownloadListDetailService downloadListDetailService;
    private int hour = 9;

    public DownLoadTaskHandler(String name) {
        super(name);
    }

    @Override
    public boolean preJob() {
        String hourStr = System.getProperty("receipt.download.hour");
        try {
            if (!EBGStringUtils.isEmpty((String)hourStr)) {
                this.hour = Integer.parseInt(hourStr);
                if (this.hour < 1) {
                    this.hour = 1;
                }
            }
        }
        catch (Exception e) {
            this.hour = 2;
        }
        this.bankLoginService = BankLoginService.getInstance();
        this.bankVersionService = BankVersionService.getInstance();
        this.bankAcntService = BankAcntService.getInstance();
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        String customId = RequestContext.get().getTenantId();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).logBizSeqID(Sequence.genSequence()).logRequestSeqID(Sequence.genSequence()).bizName("receipt").build());
        return true;
    }

    @Override
    public boolean afterJob() {
        EBContext.destroy();
        return true;
    }

    @Override
    public void subProcess() {
        List<BankListEntity> bankListEntities;
        this.MDC_Schedule();
        BankBundleManager bankBundleManager = BankBundleManager.getInstance();
        long starTimeSub = System.currentTimeMillis();
        String customId = RequestContext.get().getTenantId();
        LocalDateTime nowTime = LocalDateTime.now();
        if (nowTime.getHour() < this.hour) {
            this.logger.info("\u4e0b\u8f7d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u4e0d\u80fd\u5728\u8bbe\u5b9a\u7684\u6307\u5b9a\u65f6\u95f4\u4e4b\u524d\u6267\u884c-\u76ee\u524d\u8bbe\u7f6e\u7684\u65f6\u95f4\u70b9\u662f-{}\u70b9", new Object[]{customId, this.hour});
        }
        if ((bankListEntities = super.getBankListEntities()).size() == 0) {
            this.logger.info("\u4e0b\u8f7d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u542f\u7528\u7684\u94f6\u884c\u5217\u8868\u4e3a\u7a7a", (Object)customId);
            return;
        }
        List<BankLogin> bankLoginList = super.getBankLoginList();
        if (bankLoginList.size() == 0) {
            this.logger.info("\u4e0b\u8f7d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u672a\u914d\u7f6e\u524d\u7f6e\u673a", (Object)customId);
            return;
        }
        HashMap allBankLoginMap = Maps.newHashMapWithExpectedSize((int)16);
        for (BankLogin bankLogin : bankLoginList) {
            Set<String> bankLoginSet = new HashSet<String>();
            if (allBankLoginMap.containsKey(bankLogin.getBankVersionId())) {
                bankLoginSet = (Set)allBankLoginMap.get(bankLogin.getBankVersionId());
            }
            bankLoginSet.add(bankLogin.getKey().getBankLoginId());
            allBankLoginMap.put(bankLogin.getBankVersionId(), bankLoginSet);
        }
        this.logger.monitorInfo("ebg-receiptSchedule-{}-banks\uff1a{}-bankLogins\uff1a{}", new Object[]{this.name, bankListEntities.size(), bankListEntities.size()});
        for (BankListEntity bankListEntity : bankListEntities) {
            long bankVersionStartTime = System.currentTimeMillis();
            String bankVersionId = bankListEntity.getNumber();
            String enable = bankListEntity.getEnable();
            BankVersion versionInfo = bankBundleManager.getBankVersionInfo(bankVersionId);
            if (versionInfo == null) continue;
            if (Objects.equals(enable, "0")) {
                this.logger.info("\u4e0b\u8f7d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u672a\u542f\u7528\u8be5\u94f6\u884c-{}", new Object[]{customId, bankVersionId});
                continue;
            }
            if (!allBankLoginMap.containsKey(bankVersionId)) {
                this.logger.info("\u4e0b\u8f7d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u8be5\u94f6\u884c-{}-\u672a\u914d\u7f6e\u524d\u7f6e\u673a", new Object[]{customId, bankVersionId});
                continue;
            }
            RequestContextUtils.setRunningParam((String)"RECEIPT_FORMAT", (String)"");
            boolean isFileReceipt = RequestContextUtils.isOnlySupportXml((String)bankVersionId);
            Set bankLoginSet = (Set)allBankLoginMap.get(bankVersionId);
            this.logger.info("\u8be5\u79df\u6237{}-\u8be5\u94f6\u884c-{}-\u4e00\u5171\u914d\u7f6e\u4e86{}\u4e2a\u524d\u7f6e\u673a", new Object[]{customId, bankVersionId, bankLoginSet.size()});
            for (String bankLoginId : bankLoginSet) {
                boolean isSupportBatchDownload = RequestContextUtils.isSupportBatchDownloadByBankLogin((String)bankVersionId, (String)bankLoginId);
                long bankLoginStartTime = System.currentTimeMillis();
                List<Object> bankAcntList = super.getAcntsListByBankLogin(bankVersionId, bankLoginId);
                if ((bankAcntList = bankAcntList.stream().filter(item -> Objects.equals(RequestContext.get().getTenantId(), item.getCustomID())).collect(Collectors.toList())).size() == 0) {
                    this.logger.info("\u4e0b\u8f7d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u8be5\u94f6\u884c-{}-{}-\u4e0d\u5b58\u5728\u94f6\u884c\u56de\u5355\u8d26\u6237", new Object[]{customId, bankVersionId, bankLoginId});
                    continue;
                }
                this.logger.monitorInfo("ebg-receiptSchedule-{}-bankVersion\uff1a{}-{}-accNos\uff1a{}", new Object[]{this.name, bankVersionId, bankLoginId, bankAcntList.size()});
                int interval = RequestContextUtils.getDownloadIntervalConfig((String)bankVersionId, (String)bankLoginId);
                List<DownloadListTask> downloadListTasks = super.getDownloadListTasksOfDownload(bankVersionId, bankLoginId, bankAcntList);
                if (downloadListTasks.size() == 0) continue;
                downloadListTasks = ReceiptTaskHandleUtils.getInstance().sortDescTaskListBySort(downloadListTasks);
                for (DownloadListTask downloadListTask : downloadListTasks) {
                    boolean isTodayTask = false;
                    if (downloadListTask.getTodaysFlag() == 1 || downloadListTask.getTransDate().isEqual(LocalDate.now())) {
                        isTodayTask = true;
                    }
                    if (Objects.equals(this.name, HandlerType.TODAY_DOWNLOAD.getName()) && isTodayTask && this.isNeedExecuteTask(downloadListTask, interval)) {
                        this.doTask(downloadListTask, false);
                    }
                    if (!Objects.equals(this.name, HandlerType.DOWNLOAD.getName()) || isTodayTask) continue;
                    if (isSupportBatchDownload && isFileReceipt) {
                        if (!this.isConformDownloadOfBatch(downloadListTask)) continue;
                        this.doTask(downloadListTask, true);
                        continue;
                    }
                    this.doTask(downloadListTask, false);
                }
                long endTime = System.currentTimeMillis();
                this.logger.monitorInfo("ebg-receiptSchedule-{}-bankVersion\uff1a{},bankLogin\uff1a{}-tasks\uff1a{} do\uff1a{} ms", new Object[]{this.name, bankVersionId, bankLoginId, downloadListTasks.size(), endTime - bankLoginStartTime});
            }
            long endTime = System.currentTimeMillis();
            this.logger.monitorInfo("ebg-receiptSchedule-{}-bankVersion\uff1a{},do\uff1a{} ms", new Object[]{this.name, bankVersionId, endTime - bankVersionStartTime});
        }
        long endTime = System.currentTimeMillis();
        this.logger.monitorInfo("ebg-receiptSchedule-{}-end-total\uff1a{} ms", new Object[]{this.name, endTime - starTimeSub});
        this.logger.info("\u4e0b\u8f7d\u4efb\u52a1\u5904\u7406\u5b8c\u6210-{}", (Object)customId);
    }

    public void doTask(DownloadListTask downloadListTask, boolean isBatchDownload) {
        String customId = RequestContext.get().getTenantId();
        String bankVersionId = downloadListTask.getBankVersionId();
        String bankLoginId = downloadListTask.getBankLoginId();
        ReceiptHandlerRequest receiptRequest = new ReceiptHandlerRequest();
        receiptRequest.setBankVersion(bankVersionId);
        receiptRequest.setBatchSeqId(downloadListTask.getBatchNo());
        receiptRequest.setTransDate(LocalDateUtil.formatDate((LocalDate)downloadListTask.getTransDate()));
        receiptRequest.setType(this.name);
        receiptRequest.setBankLoginId(bankLoginId);
        receiptRequest.setCustomId(downloadListTask.getCustomNo());
        receiptRequest.setTaskId(downloadListTask.getId());
        receiptRequest.setAccNo(downloadListTask.getAccNo());
        receiptRequest.setBatchDownload(isBatchDownload);
        if (isBatchDownload && !downloadListTask.getTransDate().isEqual(LocalDate.now())) {
            receiptRequest.setType(HandlerType.BATCH_DOWNLOAD.getName());
            receiptRequest.setTaskStatus(downloadListTask.getStatus());
        }
        TaskActuator task = TaskFactory.getTask(receiptRequest);
        EBThreadPools.getThreadPool(this.name, bankLoginId, customId).submit((Callable)((Object)task));
        if (!isBatchDownload) {
            if (downloadListTask.getStatus().intValue() == TaskStatus.CREATE.getId()) {
                downloadListTask.setStatus(Integer.valueOf(TaskStatus.PROCESSING.getId()));
            }
            if (downloadListTask.getStatus().intValue() == TaskStatus.COMPLETED.getId()) {
                downloadListTask.setStatus(Integer.valueOf(TaskStatus.DOWNLOADING.getId()));
            }
            downloadListTask.setCompleteTime(LocalDateTime.now());
            this.downloadTaskService.update(downloadListTask);
        }
    }

    public boolean isNeedExecuteTask(DownloadListTask task, int interval) {
        try {
            if (interval == 0 || task.getStatus().intValue() == TaskStatus.CREATE.getId()) {
                return true;
            }
            LocalDateTime lastTime = task.getModifytime();
            long minutes = ChronoUnit.MINUTES.between(lastTime, LocalDateTime.now());
            return minutes >= (long)interval;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u56de\u5355\u4e0b\u8f7d\u95f4\u9694\u914d\u7f6e\u5931\u8d25--" + e.getMessage(), (Throwable)e);
            return true;
        }
    }

    public boolean isConformDownloadOfBatch(DownloadListTask task) {
        String bankLoginId = task.getBankLoginId();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)task.getTransDate());
        String key = String.format("receipt_download_%s_%s_%s_lock", bankLoginId, transDateStr, task.getStatus());
        String cache_token = CosmicCache.get((String)key);
        if (EBGStringUtils.isEmpty((String)cache_token)) {
            CosmicCache.putIfAbsentWithExpire((String)key, (String)"true", (int)3600, (TimeUnit)TimeUnit.SECONDS);
            return true;
        }
        return false;
    }
}

