/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.query.balanceReconciliation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.data.PageRequest;
import kd.ebg.egf.common.model.data.Pageable;
import kd.ebg.egf.common.model.data.Sort;
import kd.ebg.receipt.business.receipt.bank.BalanceReconciliationQueryRequest;
import kd.ebg.receipt.business.receipt.bank.BalanceReconciliationQueryResponseEB;
import kd.ebg.receipt.business.receipt.query.IBalanceReconciliationPage;
import kd.ebg.receipt.business.receipt.query.ReceiptResult;
import kd.ebg.receipt.business.receipt.query.ReceiptResultPage;
import kd.ebg.receipt.business.receipt.query.Result;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.entity.biz.reconciliation.query.BalanceReconciliationDetail;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.services.reconciliation.ReconciliationDownloadTaskService;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationInfo;
import kd.ebg.receipt.common.model.repository.reconciliation.ReconciliationDownloadListDetailRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class FileBalanceReconciliationQueryPage
implements IBalanceReconciliationPage {
    private ReconciliationDownloadListDetailRepository reconciliationDownloadListDetailRepository;
    private ReconciliationDownloadTaskService reconciliationDownloadTaskService;

    @Override
    public String getFirstPageTag() {
        return "1";
    }

    @Override
    public String getNextPageTag(String rspStr, String pageTag) {
        Integer page;
        Integer n = page = Integer.valueOf(Integer.parseInt(pageTag));
        Integer n2 = page = Integer.valueOf(page + 1);
        return page + "";
    }

    @Override
    public boolean isLastPage(String rspStr, String pageTag) {
        Result resultSet = (Result)JSON.parseObject((String)rspStr, (TypeReference)new TypeReference<Result<ReceiptResultPage>>(){}, (Feature[])new Feature[0]);
        if (!"success".equals(resultSet.getCode())) {
            return true;
        }
        return ((ReceiptResultPage)resultSet.getData()).isLastPage();
    }

    public BalanceReconciliationQueryResponseEB doBiz(BalanceReconciliationQueryRequest request) {
        int pageSize;
        this.reconciliationDownloadListDetailRepository = (ReconciliationDownloadListDetailRepository)SpringContextUtil.getBean(ReconciliationDownloadListDetailRepository.class);
        this.reconciliationDownloadTaskService = (ReconciliationDownloadTaskService)SpringContextUtil.getBean(ReconciliationDownloadTaskService.class);
        BalanceReconciliationQueryResponseEB responseEB = new BalanceReconciliationQueryResponseEB();
        String accNo = request.getAccNo();
        String bankVersionID = request.getHeader().getBankVersionID();
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        String fixedAccNo = accNo;
        if (!RequestContextUtils.isAccNoOfReconciliationByBank((String)bankVersionID)) {
            fixedAccNo = "";
        }
        String reconciliationProtocolNo = request.getReconciliationProtocolNo();
        int page = request.getPageNum();
        if (page <= 0) {
            page = 1;
        }
        if ((pageSize = request.getPageSize()) <= 0) {
            pageSize = 1000;
        }
        List downloadListTasks = this.reconciliationDownloadTaskService.findByAccNoAndBankVersionIDAndTransDateBetween(fixedAccNo, bankVersionID, null, startDate, endDate);
        ArrayList<Long> refIDs = new ArrayList<Long>(16);
        for (ReconciliationInfo info : downloadListTasks) {
            ReceiptResult result = new ReceiptResult();
            result.setCompleteFlas(1);
            result.setTransDate(info.getTransDate());
            result.setRefID(info.getId());
            refIDs.add(info.getId());
        }
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "id")});
        PageRequest pageRequest = PageRequest.of((int)(page - 1), (int)pageSize, (Sort)sort);
        Page detailPage = this.reconciliationDownloadListDetailRepository.findByRefidInAndAccNoAndProtocolNoPage(refIDs, fixedAccNo, reconciliationProtocolNo, (Pageable)pageRequest);
        ArrayList detailList = new ArrayList(16);
        if (detailPage.getContent() != null) {
            detailList.addAll(detailPage.getContent());
        }
        long totalElements = detailPage.getTotalElements();
        boolean lastPage = detailPage.isLast();
        ArrayList<BalanceReconciliationDetail> bankReceiptInfos = new ArrayList<BalanceReconciliationDetail>(16);
        if (Objects.nonNull(detailList)) {
            for (ReconciliationDetail detail : detailList) {
                if (detail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
                BalanceReconciliationDetail info = new BalanceReconciliationDetail();
                info.setFilePath(detail.getBankFilePath());
                info.setAccNo(fixedAccNo);
                info.setReconciliationNo(detail.getReconciliationNo());
                info.setReconciliationProtocolNo(detail.getReconciliationProtocolNo());
                info.setReconciliationYearMonth(detail.getYearMonth());
                info.setExplanation(ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u7684\u5bf9\u8d26\u5355\uff0c\u8bf7\u67e5\u9605\u5bf9\u8d26\u5355\u6587\u4ef6\u5185\u5bb9\u3002", (String)"FileBalanceReconciliationQueryPage_0", (String)"ebg-receipt-business", (Object[])new Object[0]));
                String uploadFileName = detail.getUploadFileName();
                if (!EBGStringUtils.isEmpty((String)uploadFileName)) {
                    info.setUploadFileName(uploadFileName);
                }
                info.setUploadFlag(detail.getUploadFlag().intValue());
                bankReceiptInfos.add(info);
            }
        }
        responseEB.setDetails(bankReceiptInfos);
        responseEB.setFileFlag(1);
        responseEB.setCompleteFlag(1);
        responseEB.setPageNum(page);
        responseEB.setPageSize(pageSize);
        responseEB.setTotalCount(totalElements);
        responseEB.setLastPage(lastPage);
        return responseEB;
    }
}

