/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.utils;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.receipt.common.framework.frame.BankBundleManager;
import kd.ebg.receipt.common.framework.properties.SystemPropertyConfig;

public class AccessUtils {
    public static void checkQueryAllowed(EBContext context) {
        String bankVersionID = context.getBankVersionID();
        boolean isQueryAllowed = SystemPropertyConfig.NOT_PAYMENT_ALLOW.getCurrentValueAsBoolean();
        if (!isQueryAllowed) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u975e\u652f\u4ed8\u901a\u9053\u5df2\u5173\u95ed\uff0c\u8bf7\u5728\u94f6\u4f01\u5168\u5c40\u53c2\u6570\u914d\u7f6e\u4e2d\u5f00\u542f\u201c\u975e\u652f\u4ed8\u901a\u9053\u5f00\u5173\u201d\u540e\u91cd\u65b0\u53d1\u8d77\u8bf7\u6c42\u3002", (String)"AccessUtils_0", (String)"ebg-receipt-business", (Object[])new Object[0]));
        }
        if (!AccessUtils.isAllowBankQuery(bankVersionID)) {
            String bankName = (String)BankBundleManager.getInstance().getBankKeyWords(bankVersionID).get(0);
            if (!bankName.endsWith(ResManager.loadKDString((String)"\u94f6\u884c", (String)"AccessUtils_1", (String)"ebg-receipt-business", (Object[])new Object[0])) || !bankName.endsWith(ResManager.loadKDString((String)"\u884c", (String)"AccessUtils_2", (String)"ebg-receipt-business", (Object[])new Object[0]))) {
                bankName = bankName + ResManager.loadKDString((String)"\u94f6\u884c", (String)"AccessUtils_1", (String)"ebg-receipt-business", (Object[])new Object[0]);
            }
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"%s\u7684\u975e\u652f\u4ed8\u901a\u9053\u5df2\u5173\u95ed\uff0c\u8bf7\u5728\u94f6\u884c\u53c2\u6570\u914d\u7f6e\u4e2d\u5f00\u542f'\u94f6\u884c\u975e\u652f\u4ed8\u901a\u9053\u5f00\u5173'\u540e\u91cd\u65b0\u53d1\u8d77\u8bf7\u6c42", (String)"AccessUtils_3", (String)"ebg-receipt-business", (Object[])new Object[0]), bankName));
        }
    }

    private static boolean isAllowBankQuery(String bankVersionID) {
        boolean result = true;
        try {
            QFilter filter = QFilter.of((String)"attr_key=? and object_id=? and object_name=?", (Object[])new Object[]{"bank_query_allow", bankVersionID, "BANK_BUSINESS"});
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"aqap_object_properties", (String)"attr_value", (QFilter[])filter.toArray());
            if (dynamicObject != null) {
                result = dynamicObject.getBoolean("attr_value");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

