/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.utils;

import com.google.common.base.Preconditions;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.receipt.business.receipt.bank.BalanceReconciliationQueryRequest;
import kd.ebg.receipt.business.receipt.bank.BalanceReconciliationQueryResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.balanceReconciliation.BalanceReconciliationRequestEB;
import kd.ebg.receipt.business.receipt.bank.task.balanceReconciliation.BalanceReconciliationResponseEB;
import kd.ebg.receipt.common.constant.balanceReconciliation.BalanceDiffStatEnum;
import kd.ebg.receipt.common.constant.balanceReconciliation.BalanceReconciliationStatusEnum;
import kd.ebg.receipt.common.entity.biz.reconciliation.balanceReconciliation.BalanceReconciliationRequest;
import kd.ebg.receipt.common.entity.biz.reconciliation.balanceReconciliation.BalanceReconciliationRequestBody;
import kd.ebg.receipt.common.entity.biz.reconciliation.balanceReconciliation.BalanceReconciliationResponse;
import kd.ebg.receipt.common.entity.biz.reconciliation.balanceReconciliation.BalanceReconciliationResponseBody;
import kd.ebg.receipt.common.entity.biz.reconciliation.query.BalanceReconciliationDetail;
import kd.ebg.receipt.common.entity.biz.reconciliation.query.QueryBalanceReconciliationRequest;
import kd.ebg.receipt.common.entity.biz.reconciliation.query.QueryBalanceReconciliationRequestBody;
import kd.ebg.receipt.common.entity.biz.reconciliation.query.QueryBalanceReconciliationResponse;
import kd.ebg.receipt.common.entity.biz.reconciliation.query.QueryBalanceReconciliationResponseBody;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;

public class BalanceReconciliationConvert {
    public static BalanceReconciliationQueryRequest convert(QueryBalanceReconciliationRequest queryReceiptRequest) {
        QueryBalanceReconciliationRequestBody body = queryReceiptRequest.getBody();
        String accNo = queryReceiptRequest.getHeader().getAccNo();
        String startDate = body.getReconciliationYearMonthStart() + "01";
        String endDate = body.getReconciliationYearMonthEnd() + "01";
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)startDate), (Object)ResManager.loadKDString((String)"\u67e5\u8be2\u5f00\u59cb\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceReconciliationConvert_0", (String)"ebg-receipt-business", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)endDate), (Object)ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u675f\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceReconciliationConvert_1", (String)"ebg-receipt-business", (Object[])new Object[0]));
        BalanceReconciliationQueryRequest receiptRequest = new BalanceReconciliationQueryRequest();
        BankHeader header = new BankHeader();
        receiptRequest.setHeader(header);
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        header.setAcnt(mainAcnt);
        header.setBankLoginID(mainAcnt.getBankLoginId());
        header.setBankVersionID(mainAcnt.getBankVersionId());
        header.setCustomerID(queryReceiptRequest.getHeader().getCustomId());
        header.setBizSeqID(queryReceiptRequest.getHeader().getLogBizSeqID());
        header.setBizType(queryReceiptRequest.getHeader().getBizType());
        header.setSubBizType(queryReceiptRequest.getHeader().getSubBizType());
        header.setClientName(queryReceiptRequest.getHeader().getClientName());
        header.setClientVersion(queryReceiptRequest.getHeader().getClientVersion());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        header.setBankCurrency(bankCurrency);
        header.setExtData(queryReceiptRequest.getHeader().getExtData());
        receiptRequest.setStartDate(LocalDate.parse(startDate, DateTimeFormatter.BASIC_ISO_DATE));
        receiptRequest.setEndDate(LocalDate.parse(endDate, DateTimeFormatter.BASIC_ISO_DATE));
        receiptRequest.setAccNo(mainAcnt.getAccNo());
        return receiptRequest;
    }

    public static BalanceReconciliationRequestEB convert(BalanceReconciliationRequest queryReceiptRequest) {
        BalanceReconciliationRequestBody body = queryReceiptRequest.getBody();
        BalanceReconciliationRequestEB reconciliationRequestEB = BalanceReconciliationConvert.convertToRequest(body);
        String accNo = queryReceiptRequest.getHeader().getAccNo();
        String reconciliationYearMonth = body.getReconciliationYearMonth();
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)reconciliationYearMonth), (Object)ResManager.loadKDString((String)"\u5bf9\u8d26\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceReconciliationConvert_2", (String)"ebg-receipt-business", (Object[])new Object[0]));
        BankHeader header = new BankHeader();
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        header.setAcnt(mainAcnt);
        header.setBankLoginID(mainAcnt.getBankLoginId());
        header.setBankVersionID(mainAcnt.getBankVersionId());
        header.setCustomerID(queryReceiptRequest.getHeader().getCustomId());
        header.setBizSeqID(queryReceiptRequest.getHeader().getLogBizSeqID());
        header.setBizType(queryReceiptRequest.getHeader().getBizType());
        header.setSubBizType(queryReceiptRequest.getHeader().getSubBizType());
        header.setClientName(queryReceiptRequest.getHeader().getClientName());
        header.setClientVersion(queryReceiptRequest.getHeader().getClientVersion());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        header.setBankCurrency(bankCurrency);
        header.setExtData(queryReceiptRequest.getHeader().getExtData());
        reconciliationRequestEB.setHeader(header);
        String reconciliationNo = reconciliationRequestEB.getReconciliationNo();
        if (!RequestContextUtils.isAccNoOfReconciliationByBank((String)header.getBankVersionID())) {
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)reconciliationNo), (Object)ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceReconciliationConvert_3", (String)"ebg-receipt-business", (Object[])new Object[0]));
        }
        String balanceStatus = reconciliationRequestEB.getBalanceStatus();
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)balanceStatus), (Object)ResManager.loadKDString((String)"\u4f59\u989d\u6838\u5bf9\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceReconciliationConvert_4", (String)"ebg-receipt-business", (Object[])new Object[0]));
        if (Objects.equals(BalanceReconciliationStatusEnum.N.getCode(), balanceStatus)) {
            String adjustCause = reconciliationRequestEB.getAdjustCause();
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)adjustCause), (Object)ResManager.loadKDString((String)"\u4f59\u989d\u8c03\u8282\u539f\u56e0\u7c7b\u578b\u5b57\u6bb5(adjustCause)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceReconciliationConvert_5", (String)"ebg-receipt-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)BalanceDiffStatEnum.isConByCode((String)adjustCause), (Object)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u8c03\u8282\u539f\u56e0\u7c7b\u578b\u5b57\u6bb5(adjustCause)\u4e0a\u4f20\u7684\u53c2\u6570\u6709\u8bef\uff0c\u9519\u8bef\u503c\uff1a%s\u3002", (String)"BalanceReconciliationConvert_8", (String)"ebg-receipt-business", (Object[])new Object[0]), adjustCause));
            String acntDrct = reconciliationRequestEB.getAcntDrct();
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)acntDrct), (Object)ResManager.loadKDString((String)"\u8d26\u6237\u65b9\u5411\u5b57\u6bb5(acntDrct)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceReconciliationConvert_7", (String)"ebg-receipt-business", (Object[])new Object[0]));
        }
        return reconciliationRequestEB;
    }

    public static QueryBalanceReconciliationResponse convert(BalanceReconciliationQueryResponseEB receiptResponse) {
        QueryBalanceReconciliationResponse response = new QueryBalanceReconciliationResponse();
        QueryBalanceReconciliationResponseBody body = new QueryBalanceReconciliationResponseBody();
        response.setBody(body);
        body.setCompleteFlag(receiptResponse.getCompleteFlag());
        body.setFileFlag(receiptResponse.getFileFlag());
        if (receiptResponse.getEbException() != null) {
            response.setException(receiptResponse.getEbException());
        }
        List<BalanceReconciliationDetail> receiptInfos = receiptResponse.getDetails();
        ArrayList<BalanceReconciliationDetail> details = new ArrayList<BalanceReconciliationDetail>(16);
        if (Objects.nonNull(receiptInfos) && receiptInfos.size() > 0) {
            for (BalanceReconciliationDetail info : receiptInfos) {
                details.add(info);
            }
            body.setTotalCount((long)receiptInfos.size());
        }
        body.setPageNum(receiptResponse.getPageNum());
        body.setLastPage(receiptResponse.isLastPage());
        body.setPageSize(receiptResponse.getPageSize());
        body.setReceiptInfos(details);
        return response;
    }

    public static BalanceReconciliationResponse convert(BalanceReconciliationResponseEB receiptResponse) {
        BalanceReconciliationResponse response = new BalanceReconciliationResponse();
        BalanceReconciliationResponseBody body = BalanceReconciliationConvert.convertToResponseBody(receiptResponse);
        response.setBody(body);
        return response;
    }

    public static BalanceReconciliationRequestEB convertToRequest(BalanceReconciliationRequestBody reconciliationRequestBody) {
        BalanceReconciliationRequestEB detail = new BalanceReconciliationRequestEB();
        FieldUtils.fieldsCopy((Object)reconciliationRequestBody, (Object)((Object)detail));
        return detail;
    }

    public static BalanceReconciliationResponseBody convertToResponseBody(BalanceReconciliationResponseEB reconciliationResponseEB) {
        BalanceReconciliationResponseBody response = new BalanceReconciliationResponseBody();
        FieldUtils.fieldsCopy((Object)((Object)reconciliationResponseEB), (Object)response);
        return response;
    }
}

