/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hbb.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.hbb.dc.service.receipt.util.RequestPack;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class BankReceiptInfoQueryImpl
extends AbstractDetailImpl
implements IDetail {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptInfoQueryImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "HBB_DC_RECEIPT_INFO_REQUEST";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6cb3\u5317\u94f6\u884c\u56de\u5355\u4fe1\u606f\u67e5\u8be2\u8bf7\u6c42\u3002", (String)"BankReceiptInfoQueryImpl_0", (String)"ebg-receipt-banks-hbb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String cipher = RequestContextUtils.getBankParameterValue((String)"userPassword");
        factory.setUri("/eb2e/eb2e-acmgmt.ReceiptQry.do?userPassword=" + cipher + "&SIGDATA=1");
        factory.setHttpHeader("Content-Type", "application/xml");
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        String accNo = bankDetailRequest.getAcnt().getAccNo();
        String startTransDateStr = LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getStartDate());
        String endTransDateStr = LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getEndDate());
        int currentPage = Integer.parseInt(this.getCurrentPage());
        currentPage = (currentPage - 1) * 50 + 1;
        String requestStr = RequestPack.receiptDetailt(accNo, startTransDateStr, endTransDateStr, currentPage);
        return requestStr;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String responseStr) {
        this.setLastPage(true);
        List<DetailInfo> detailInfoList = this.detailParser(responseStr);
        EBBankDetailResponse detailResponse = new EBBankDetailResponse();
        detailResponse.setDetails(detailInfoList);
        return detailResponse;
    }

    public boolean isSupportPage() {
        return true;
    }

    public int getFirstPage() {
        return 1;
    }

    public List<DetailInfo> detailParser(String response) {
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(16);
        if (response == null || response.trim().length() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\u3002", (String)"BankReceiptInfoQueryImpl_1", (String)"ebg-receipt-banks-hbb-dc", (Object[])new Object[0]));
        }
        Element root = JDomUtils.str2DocUTF8((String)response).getRootElement();
        Element Head = JDomUtils.getUnNullChildElement((Element)root, (String)"Head");
        String IBSReturnCode = JDomUtils.getUnNullChildText((Element)Head, (String)"IBSReturnCode");
        String IBSReturnMsg = JDomUtils.getUnNullChildText((Element)Head, (String)"IBSReturnCode");
        if ("00000000".equalsIgnoreCase(IBSReturnCode)) {
            Element Body = JDomUtils.getUnNullChildElement((Element)root, (String)"Body");
            List lists = Body.getChildren("list");
            lists.forEach(list -> {
                DetailInfo detailInfo = new DetailInfo();
                String acNo = JDomUtils.getUnNullChildText((Element)list, (String)"acNo");
                String Jnlno = JDomUtils.getUnNullChildText((Element)list, (String)"Jnlno");
                String amount = JDomUtils.getUnNullChildText((Element)list, (String)"amount");
                String hisJnlNo = JDomUtils.getUnNullChildText((Element)list, (String)"hisJnlNo");
                String pdfFileName = acNo + hisJnlNo + ".pdf";
                String json = MatchRule.getInstance().getDetailJsonWithStructuredData(list);
                detailInfo.setReceiptNo(Jnlno);
                detailInfo.setReversed1(amount);
                detailInfo.setReversed2(pdfFileName);
                detailInfo.setJson(json);
                result.add(detailInfo);
            });
            int recAmount = Integer.parseInt(Body.getChildTextTrim("recordNumber"));
            int currentPage = Integer.parseInt(this.getCurrentPage());
            if (result == null || result.size() < 50) {
                this.setLastPage(true);
            } else if ((currentPage - 1) * 50 + result.size() >= recAmount) {
                this.setLastPage(true);
            } else {
                this.setLastPage(false);
                this.setCurrentPage(currentPage + 1);
            }
            return result;
        }
        if ("00000001".equalsIgnoreCase(IBSReturnCode)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff0c\u8fd4\u56de\u7801\uff1a%1$s\u3002\u94f6\u884c\u54cd\u5e94\u8d85\u65f6\uff0c\u9700\u8981\u91cd\u65b0\u767b\u5f55\u4ee3\u7406\u5de5\u5177\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a%2$s\u3002", (String)"BankReceiptInfoQueryImpl_2", (String)"ebg-receipt-banks-hbb-dc", (Object[])new Object[0]), IBSReturnCode, IBSReturnMsg));
        }
        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u3002\u8fd4\u56de\u7801\uff1a%1$s\u8fd4\u56de\u4fe1\u606f\uff1a%2$s\u3002", (String)"BankReceiptInfoQueryImpl_3", (String)"ebg-receipt-banks-hbb-dc", (Object[])new Object[0]), IBSReturnCode, IBSReturnMsg));
    }
}

