/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cdcb.cms.utils;

import java.time.LocalDate;
import java.time.LocalTime;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Packer {
    public static Element creatHead(String trCode, String reqNo) {
        Element ap = JDomUtils.createRoot((String)"ap");
        Element head = JDomUtils.addChild((Element)ap, (String)"head");
        JDomUtils.addChild((Element)head, (String)"tr_code", (String)trCode);
        JDomUtils.addChild((Element)head, (String)"org_code");
        JDomUtils.addChild((Element)head, (String)"cms_corp_no");
        JDomUtils.addChild((Element)head, (String)"user_no");
        JDomUtils.addChild((Element)head, (String)"user_id");
        JDomUtils.addChild((Element)head, (String)"serial_no");
        JDomUtils.addChild((Element)head, (String)"req_no", (String)reqNo);
        JDomUtils.addChild((Element)head, (String)"tr_acdt", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        JDomUtils.addChild((Element)head, (String)"tr_time", (String)LocalDateUtil.formatLocalTime((LocalTime)LocalTime.now()));
        JDomUtils.addChild((Element)head, (String)"channel", (String)"18");
        JDomUtils.addChild((Element)head, (String)"sign");
        JDomUtils.addChild((Element)head, (String)"file_flag", (String)"0");
        JDomUtils.addChild((Element)head, (String)"reserved");
        return ap;
    }

    public static String createCommonMsg(String xml) throws EBServiceException {
        int digital = 10;
        String msgBody = "00" + xml;
        int msgBodyLen = Packer.getLength(msgBody);
        String msgHead = Packer.formatLen(String.valueOf(msgBodyLen), digital);
        return msgHead + msgBody;
    }

    public static int getLength(String str) throws EBServiceException {
        String encoding = RequestContextUtils.getCharset();
        try {
            int length = str.getBytes(encoding).length;
            return length;
        }
        catch (Exception var4) {
            return 0;
        }
    }

    public static String formatLen(String msgLen, int len) {
        try {
            return StringFormater.formatLen((String)msgLen, (int)len, (boolean)true, (char)'0', (String)RequestContextUtils.getCharset());
        }
        catch (Exception var4) {
            return "";
        }
    }
}

