/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmbc.dc.service.receipt;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.receipt.banks.cmbc.dc.service.receipt.api.BankReceiptQueryImpl;
import kd.ebg.receipt.banks.cmbc.dc.service.receipt.info.CMBCDCFileParser;
import kd.ebg.receipt.banks.cmbc.dc.service.receipt.info.CmbcFileInfo;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        try {
            this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
            ArrayList<Long> ids = new ArrayList<Long>(1);
            List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
            for (DownloadListDetail downloadListDetail : downloadListDetails) {
                CMBCDCFileParser cmbcdcFileParser = new CMBCDCFileParser();
                cmbcdcFileParser.setFileName(downloadListDetail.getFileName());
                if (cmbcdcFileParser.getFileSplitLength() != 6) continue;
                ids.add(downloadListDetail.getId());
            }
            if (!ids.isEmpty()) {
                this.downloadListDetailService.deleteById(ids);
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, CmbcFileInfo> fileInfoMap = this.getFileInfoMap(accNo, transDate, 1);
        for (Map.Entry entry : fileInfoMap.entrySet()) {
            CmbcFileInfo info = (CmbcFileInfo)entry.getValue();
            DownloadListDetail detail = new DownloadListDetail();
            String fileName = info.getFileName().replace(".pdf", "");
            if (countMap.containsKey(fileName)) {
                Integer recount = (Integer)countMap.get(fileName);
                recount = recount + 1;
                countMap.put(fileName, recount);
                fileName = fileName + "+" + recount + ".pdf";
            } else {
                countMap.put(fileName, 0);
                fileName = info.getFileName();
            }
            detail.setFileLink(info.getFileLink());
            detail.setFileName(fileName);
            result.add(detail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-cmbc-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    private Map<String, CmbcFileInfo> getFileInfoMap(String accNo, LocalDate transDate, Integer pageNo) {
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)8);
        paramsMap.put("pageNo", pageNo);
        BankReceiptRequest receiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap((Map)paramsMap).build();
        BankReceiptQueryImpl iBankReceipt = new BankReceiptQueryImpl();
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        Map fileInfoMap = (Map)((BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)receiptRequest)).getData();
        if (fileInfoMap.size() > 0) {
            result.putAll(fileInfoMap);
            Map<String, CmbcFileInfo> cmbcFileInfoMap = this.getFileInfoMap(accNo, transDate, pageNo + 1);
            result.putAll(cmbcFileInfoMap);
        }
        return result;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CMBC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u6c11\u751f\u94f6\u884c\u63a8\u6539\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-cmbc-dc", (Object[])new Object[0]);
    }
}

