/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.index;

import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.model.bank.BankListEntity;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.DetailDownloadStatusEnum;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.formplugin.plugin.util.ShowPageUtil;
import kd.ebg.receipt.formplugin.pojo.receipt.ReceiptNumGroup;
import kd.ebg.receipt.formplugin.pojo.receipt.ReceiptPcGroup;
import kd.ebg.receipt.formplugin.util.ReceiptStatisticsUtil;
import org.apache.commons.lang3.StringUtils;

public class ReceiptTaskStatsPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        Label label = (Label)this.getView().getControl("label_receipt_stats");
        label.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)8);
        String dateStr = this.getPageCache().get("rowindex" + evt.getRowIndex());
        customParams.put("trans_date", dateStr);
        if (StringUtils.equals((CharSequence)"receipt_acnt_count", (CharSequence)evt.getFieldName()) || StringUtils.equals((CharSequence)"task_num_count", (CharSequence)evt.getFieldName())) {
            ShowPageUtil.showListPage("receipt_info", customParams, this.getView());
        } else {
            switch (evt.getFieldName()) {
                case "runing_task_num": {
                    customParams.put("status", "-1");
                    break;
                }
                case "fail_task_num": {
                    customParams.put("status", TaskStatusEnum.FAILED.getId() + "");
                    break;
                }
                case "success_task_num": {
                    customParams.put("status", TaskStatusEnum.FINISH.getId() + "");
                    break;
                }
                case "detail_success_num": {
                    customParams.put("detail_flag", DetailDownloadStatusEnum.DOWNLOAD_SUCCESS.getId() + "");
                }
            }
            ShowPageUtil.showListPage("receipt_download_task", customParams, this.getView());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Label) {
            Label label = (Label)evt.getSource();
            HashMap customParams = Maps.newHashMapWithExpectedSize((int)8);
            if (this.getModel().getValue("startdate") == null) {
                Date defaultEndDate = DateUtil.getLastDay((Date)new Date(), (int)1);
                Date defaultStartDate = DateUtil.getLastDay((Date)defaultEndDate, (int)6);
                customParams.put("trans_date_end", defaultEndDate);
                customParams.put("trans_date_start", defaultStartDate);
            } else {
                customParams.put("trans_date_end", this.getModel().getValue("enddate"));
                customParams.put("trans_date_start", this.getModel().getValue("startdate"));
            }
            if (StringUtils.equals((CharSequence)"show_receipt_stats", (CharSequence)label.getOperationKey())) {
                ShowPageUtil.showListPage("receipt_stats_by_day", customParams, this.getView());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("show_more".equals(formOperate.getOperateKey())) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setFormId("bos_list");
            showParameter.setBillFormId("receipt_download_task");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.fillDefaultValue();
        this.drawChart();
        this.loadData();
    }

    private void fillDefaultValue() {
        String startDateStr = this.getFromParentPageCache("startdate");
        String endDateStr = this.getFromParentPageCache("enddate");
        if (!StringUtils.isBlank((CharSequence)startDateStr) && !StringUtils.isBlank((CharSequence)endDateStr)) {
            this.getModel().setValue("startdate", (Object)new Date(Long.parseLong(startDateStr)));
            this.getModel().setValue("enddate", (Object)new Date(Long.parseLong(endDateStr)));
        } else {
            Date defaultEndDate = DateUtil.getLastDay((Date)new Date(), (int)1);
            Date defaultStartDate = DateUtil.getLastDay((Date)defaultEndDate, (int)6);
            this.getModel().setValue("startdate", (Object)defaultStartDate);
            this.getModel().setValue("enddate", (Object)defaultEndDate);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date date;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (("startdate".equals(key) || "enddate".equals(key)) && (date = (Date)this.getModel().getValue(key)) != null) {
            this.putIntoParentPageCache(key, String.valueOf(date.getTime()));
        }
        if ("enddate".equals(key)) {
            String endStartStr = DateUtil.formatDate((Date)((Date)this.getModel().getValue("enddate")), (String)"yyyy-MM-dd");
            String startStr = DateUtil.formatDate((Date)((Date)this.getModel().getValue("startdate")), (String)"yyyy-MM-dd");
            endStartStr = endStartStr + " 23:59:59";
            this.getModel().setValue("enddate", (Object)DateUtil.string2Date((String)endStartStr, (String)"yyyy-MM-dd HH:mm:ss"));
            String cacheKey = String.format("%s_%s", startStr, endStartStr);
            String count = this.getFromParentPageCache(cacheKey);
            if (DateUtil.getDayDiff((Date)((Date)this.getModel().getValue("startdate")), (Date)((Date)this.getModel().getValue("enddate"))) > 7L) {
                if (StringUtils.isBlank((CharSequence)count)) {
                    this.putIntoParentPageCache(cacheKey, "0");
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u8de8\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc77\u5929\u3002", (String)"ReceiptTaskStatsPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (Objects.equals(count, "0")) {
                    this.removePageCache(cacheKey);
                    return;
                }
            } else {
                this.removePageCache(cacheKey);
            }
            this.drawChart();
            this.loadData();
        }
    }

    private void loadData() {
        String customID = RequestContext.get().getTenantId();
        List<Long> bankVersionIds = this.getAllEnableBankVersionIds(customID);
        if (CollectionUtils.isEmpty(bankVersionIds)) {
            return;
        }
        QFilter[] qFilters = new QFilter[3];
        qFilters[0] = new QFilter("custom_id", "=", (Object)customID);
        qFilters[1] = new QFilter("bank_version.id", "in", bankVersionIds);
        List<Date> dates = this.getDateList();
        if (!CollectionUtils.isEmpty(dates)) {
            Collections.reverse(dates);
            int errorCount = 0;
            this.getModel().deleteEntryData("entryentity");
            int rowCount = dates.size();
            int[] rowIndex = this.getModel().batchCreateNewEntryRow("entryentity", rowCount);
            ArrayList cellStyles = new ArrayList(16);
            for (int i = 0; i < rowCount; ++i) {
                String dateStr = DateUtil.formatDate((Date)dates.get(i), (String)"yyyy-MM-dd");
                qFilters[2] = QFilter.of((String)"trans_date>= ? and trans_date<=?", (Object[])new Object[]{LocalDateUtil.getFirstTimeByDate((Date)dates.get(i)), LocalDateUtil.getFirstTimeByDate((Date)dates.get(i))});
                DynamicObjectCollection taskNumResultCollection = QueryServiceHelper.query((String)"receipt_info", (String)"sum(receipt_acnt_num) as receipt_acnt_count, sum(task_num) as task_num_count", (QFilter[])qFilters);
                int successStatus = TaskStatus.FINISH.getId();
                int failStatus = TaskStatus.FAILED.getId();
                int detailSuccessStatus = DetailDownloadStatusEnum.DOWNLOAD_SUCCESS.getId();
                DynamicObjectCollection statusNumResultCollection = QueryServiceHelper.query((String)"receipt_download_task", (String)("sum(case when status='" + successStatus + "' then 1 else 0 end) as success_task_num,  sum(case when status='" + failStatus + "'  then 1 else 0 end) as fail_task_num,  sum(case when (status != '" + successStatus + "' and status != '" + failStatus + "') then 1 else 0 end) as runing_task_num,  sum(case when detail_flag='" + detailSuccessStatus + "'  then 1 else 0 end) as detail_success_num "), (QFilter[])qFilters);
                int receipt_acnt_count = 0;
                int task_num_count = 0;
                int success_task_num = 0;
                int detail_success_num = 0;
                int runing_task_num = 0;
                int fail_task_num = 0;
                if (taskNumResultCollection.size() > 0) {
                    DynamicObject taskNumResult = (DynamicObject)taskNumResultCollection.get(0);
                    receipt_acnt_count = taskNumResult.getInt("receipt_acnt_count");
                    task_num_count = taskNumResult.getInt("task_num_count");
                }
                if (statusNumResultCollection.size() > 0) {
                    DynamicObject statusNumResult = (DynamicObject)statusNumResultCollection.get(0);
                    success_task_num = statusNumResult.getInt("success_task_num");
                    detail_success_num = statusNumResult.getInt("detail_success_num");
                    runing_task_num = statusNumResult.getInt("runing_task_num");
                    fail_task_num = statusNumResult.getInt("fail_task_num");
                }
                this.getModel().setValue("trans_date", (Object)dateStr, rowIndex[i]);
                this.getPageCache().put("rowindex" + i, dateStr);
                this.getModel().setValue("runing_task_num", (Object)runing_task_num, rowIndex[i]);
                this.getModel().setValue("fail_task_num", (Object)fail_task_num, rowIndex[i]);
                this.getModel().setValue("success_task_num", (Object)success_task_num, rowIndex[i]);
                this.getModel().setValue("receipt_acnt_count", (Object)receipt_acnt_count, rowIndex[i]);
                this.getModel().setValue("task_num_count", (Object)task_num_count, rowIndex[i]);
                this.getModel().setValue("detail_success_num", (Object)detail_success_num, rowIndex[i]);
                boolean receipt_task_status = receipt_acnt_count <= task_num_count;
                this.getModel().setValue("receipt_task_status", (Object)(receipt_task_status ? ResManager.loadKDString((String)"\u6b63\u5e38", (String)"ReceiptTaskStatsPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f02\u5e38", (String)"ReceiptTaskStatsPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0])), rowIndex[i]);
                boolean detail_task_status = detail_success_num == task_num_count;
                this.getModel().setValue("detail_task_status", (Object)(detail_task_status ? ResManager.loadKDString((String)"\u6b63\u5e38", (String)"ReceiptTaskStatsPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f02\u5e38", (String)"ReceiptTaskStatsPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0])), rowIndex[i]);
                boolean download_task_status = success_task_num == task_num_count;
                this.getModel().setValue("download_task_status", (Object)(download_task_status ? ResManager.loadKDString((String)"\u6b63\u5e38", (String)"ReceiptTaskStatsPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f02\u5e38", (String)"ReceiptTaskStatsPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0])), rowIndex[i]);
                boolean task_status = receipt_task_status && download_task_status && detail_task_status;
                this.getModel().setValue("task_status", (Object)(task_status ? ResManager.loadKDString((String)"\u6b63\u5e38", (String)"ReceiptTaskStatsPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f02\u5e38", (String)"ReceiptTaskStatsPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0])), rowIndex[i]);
                if (task_status) continue;
                ++errorCount;
            }
            Label label = (Label)this.getControl("error_count");
            label.setText(errorCount + "");
            HashMap ctrl = Maps.newHashMapWithExpectedSize((int)16);
            if (errorCount > 0) {
                ctrl.put("fc", "red");
            } else {
                ctrl.put("fc", "#3F7F00");
            }
            this.getView().updateControlMetadata("error_count", (Map)ctrl);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            entryGrid.setCellStyle(cellStyles);
        }
    }

    private HistogramChart buildHistogramChart(String key, String yName, List<String> categories) {
        HistogramChart customchart = (HistogramChart)this.getControl(key);
        customchart.clearData();
        Axis categoryAxis = this.createCategoryAxis(key, ResManager.loadKDString((String)"\u65e5\u671f", (String)"ReceiptTaskStatsPlugin_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), true);
        this.createValueAxis(key, ResManager.loadKDString((String)yName, (String)"ReceiptStatisticsPlugin_1", (String)"ReceiptTaskStatsPlugin_4", (Object[])new Object[0]), false);
        categoryAxis.setCategorys(categories);
        return customchart;
    }

    private void drawChart() {
        String numberKey = "histogramchartap";
        String pcKey = "histogramchartap1";
        ArrayList<String> categories = new ArrayList<String>(16);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        List<Date> dates = this.getDateList();
        dates.forEach(monthStartDate -> categories.add(format.format((Date)monthStartDate)));
        HistogramChart numberChart = this.buildHistogramChart(numberKey, ResManager.loadKDString((String)"\u6570\u91cf(\u4e2a)", (String)"ReceiptTaskStatsPlugin_5", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), categories);
        HistogramChart pcChart = this.buildHistogramChart(pcKey, ResManager.loadKDString((String)"\u5b8c\u6574\u7387(%)", (String)"ReceiptTaskStatsPlugin_6", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), categories);
        LinkedHashMap<ReceiptNumGroup, List<Number>> numData = new LinkedHashMap<ReceiptNumGroup, List<Number>>();
        LinkedHashMap<ReceiptPcGroup, List<Number>> pcData = new LinkedHashMap<ReceiptPcGroup, List<Number>>();
        this.getData(dates, numData, pcData);
        numData.forEach((group, data) -> this.createBarSeries(numberKey, group.groupName, (List<Number>)data, group.color));
        pcData.forEach((group, data) -> this.createBarSeries(pcKey, group.groupName, (List<Number>)data, group.color));
        this.refreshHistogramChart(numberChart);
        this.refreshHistogramChart(pcChart);
    }

    private void refreshHistogramChart(HistogramChart histogramChart) {
        histogramChart.setMargin(Position.top, "50px");
        histogramChart.refresh();
    }

    private void getData(List<Date> dates, Map<ReceiptNumGroup, List<Number>> sortedData1, Map<ReceiptPcGroup, List<Number>> sortedData2) {
        QFilter[] qFilters = new QFilter[3];
        String customID = RequestContext.get().getTenantId();
        qFilters[0] = new QFilter("custom_id", "=", (Object)customID);
        List<Long> bankVersionIdList = this.getAllEnableBankVersionIds(customID);
        qFilters[1] = new QFilter("bank_version.id", "in", bankVersionIdList);
        List<ReceiptNumGroup> groups = this.getReceiptNumGroups();
        for (ReceiptNumGroup group : groups) {
            ArrayList initialBillCountList = new ArrayList(dates.size());
            sortedData1.put(group, initialBillCountList);
        }
        List<ReceiptPcGroup> groups2 = this.getReceiptPcGroups();
        for (ReceiptPcGroup pcGroup : groups2) {
            ArrayList initialBillCountList = new ArrayList(dates.size());
            sortedData2.put(pcGroup, initialBillCountList);
        }
        for (Date date : dates) {
            qFilters[2] = QFilter.of((String)"trans_date>= ? and trans_date<=?", (Object[])new Object[]{LocalDateUtil.getFirstTimeByDate((Date)date), LocalDateUtil.getFirstTimeByDate((Date)date)});
            DynamicObjectCollection statistics = QueryServiceHelper.query((String)"receipt_download_task", (String)"sum(receipt_num ) as receipt_num, sum(detail_num) as detail_num, sum(match_num) as match_num, sum(upload_num) as upload_num", (QFilter[])qFilters);
            for (ReceiptNumGroup group : groups) {
                sortedData1.get(group).add(statistics.size() > 0 ? ((DynamicObject)statistics.get(0)).getInt(group.fieldName) : 0);
            }
            int receipt_num = ((DynamicObject)statistics.get(0)).getInt("receipt_num");
            int detail_num = ((DynamicObject)statistics.get(0)).getInt("detail_num");
            int upload_num = ((DynamicObject)statistics.get(0)).getInt("upload_num");
            int match_num = ((DynamicObject)statistics.get(0)).getInt("match_num");
            for (ReceiptPcGroup group : groups2) {
                Number number = 0;
                if ("download_pc".equals(group.fieldName)) {
                    number = ReceiptStatisticsUtil.getPcResult(receipt_num, detail_num);
                } else if ("match_pc".equals(group.fieldName)) {
                    number = ReceiptStatisticsUtil.getPcResult(match_num, receipt_num);
                } else if ("upload_pc".equals(group.fieldName)) {
                    number = ReceiptStatisticsUtil.getPcResult(upload_num, receipt_num);
                }
                sortedData2.get(group).add(number);
            }
        }
    }

    private Map<ReceiptNumGroup, List<Number>> getData(List<Date> dates) {
        QFilter[] qFilters = new QFilter[3];
        String customID = RequestContext.get().getTenantId();
        qFilters[0] = new QFilter("custom_id", "=", (Object)customID);
        List<Long> bankVersionIdList = this.getAllEnableBankVersionIds(customID);
        qFilters[1] = new QFilter("bank_version.id", "in", bankVersionIdList);
        List<ReceiptNumGroup> groups = this.getReceiptNumGroups();
        HashMap summaryResult = Maps.newHashMapWithExpectedSize((int)16);
        for (ReceiptNumGroup group : groups) {
            ArrayList initialBillCountList = new ArrayList(dates.size());
            summaryResult.put(group, initialBillCountList);
        }
        for (Date date : dates) {
            qFilters[2] = QFilter.of((String)"trans_date>= ? and trans_date<=?", (Object[])new Object[]{LocalDateUtil.getFirstTimeByDate((Date)date), LocalDateUtil.getFirstTimeByDate((Date)date)});
            DynamicObjectCollection statistics = QueryServiceHelper.query((String)"receipt_download_task", (String)"sum(receipt_num) as receipt_num, sum(detail_num) as detail_num, sum(match_num) as match_num, sum(upload_num) as upload_num", (QFilter[])qFilters);
            for (ReceiptNumGroup group : groups) {
                ((List)summaryResult.get(group)).add(statistics.size() > 0 ? ((DynamicObject)statistics.get(0)).getInt(group.fieldName) : 0);
            }
        }
        return summaryResult;
    }

    private List<Long> getAllEnableBankVersionIds(String customId) {
        List bankVersionList = BankVersionService.getInstance().findByCustomId(customId);
        if (CollectionUtils.isEmpty((Collection)bankVersionList)) {
            return null;
        }
        ArrayList<Long> bankVersionIdList = new ArrayList<Long>(16);
        for (BankListEntity bankListEntity : bankVersionList) {
            bankVersionIdList.add(Long.parseLong(bankListEntity.getId()));
        }
        return bankVersionIdList;
    }

    private List<ReceiptNumGroup> getReceiptNumGroups() {
        return ReceiptNumGroup.getDefaultGroups();
    }

    private List<ReceiptPcGroup> getReceiptPcGroups() {
        return ReceiptPcGroup.getDefaultGroups();
    }

    private List<Date> getDateList() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (startDate == null && endDate == null) {
            endDate = DateUtil.getLastDay((Date)new Date(), (int)1);
            startDate = DateUtil.getLastDay((Date)endDate, (int)6);
        }
        ArrayList<Date> dates = new ArrayList<Date>(16);
        Date date = startDate;
        if (Objects.nonNull(date) && Objects.nonNull(endDate)) {
            while (date.getTime() <= endDate.getTime()) {
                dates.add(date);
                date = DateUtil.getNextDay((Date)date, (int)1);
            }
        }
        return dates;
    }

    private HistogramChart getMainChart(String key) {
        return (HistogramChart)this.getControl(key);
    }

    private Axis createCategoryAxis(String key, String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart(key).createXAxis(name, AxisType.category) : this.getMainChart(key).createYAxis(name, AxisType.category);
        HashMap axisTick = Maps.newHashMapWithExpectedSize((int)16);
        axisTick.put("interval", 0);
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", (Object)axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private Axis createValueAxis(String key, String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart(key).createXAxis(name, AxisType.value) : this.getMainChart(key).createYAxis(name, AxisType.value);
        HashMap axisTick = Maps.newHashMapWithExpectedSize((int)16);
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", (Object)axisTick);
        HashMap splitLine = Maps.newHashMapWithExpectedSize((int)16);
        HashMap lineStyle = Maps.newHashMapWithExpectedSize((int)16);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", (Object)splitLine);
        this.setLineColor(axis, "#999999");
        this.getMainChart(key).setShowTooltip(true);
        return axis;
    }

    private void createBarSeries(String key, String name, List<Number> values, String color) {
        BarSeries barSeries = this.getMainChart(key).createBarSeries(name);
        barSeries.setBarWidth("18px");
        barSeries.setColor(color);
        barSeries.setAnimationDuration(2000);
        barSeries.setData(values.toArray(new Number[0]));
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap lineStyleMap = Maps.newHashMapWithExpectedSize((int)16);
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", (Object)axisLineMap);
    }

    private String getFromParentPageCache(String key) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            return pageCache.get(((Object)((Object)this)).getClass().getSimpleName() + "-" + key);
        }
        return null;
    }

    private void putIntoParentPageCache(String key, String value) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            pageCache.put(((Object)((Object)this)).getClass().getSimpleName() + "-" + key, value);
        }
    }

    private void removePageCache(String key) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            pageCache.remove(((Object)((Object)this)).getClass().getSimpleName() + "-" + key);
        }
    }
}

