/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.statistics;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.front.api.boot.utils.StringUtils;
import kd.ebg.receipt.formplugin.plugin.common.EbgCommonFilterContainerPlugin;
import kd.ebg.receipt.formplugin.plugin.util.ShowPageUtil;
import kd.ebg.receipt.formplugin.util.StringUtil;

public class ReceiptDefectStatisticsByBankAndBankLoginAndMonthPlugin
extends EbgCommonFilterContainerPlugin
implements HyperLinkClickListener {
    private static String ENTITY_KEY = "receipt_defect_sta_by_mon";
    private static String ENTITY_KEY_RECEIPT_DOWNLOAD_TASK = "receipt_download_task";
    private int dataCount = 0;
    private EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptDefectStatisticsByBankAndBankLoginAndMonthPlugin.class);
    private BankVersionRepository bankVersionRepository = BankVersionRepository.getInstance();
    private BankVersionService bankVersionService = BankVersionService.getInstance();
    private BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();
    private static final String TEST_DEFECT_SETTING_KEY = "test_defect_setting";
    private List<QFilter> rowQFilter = new ArrayList<QFilter>(16);

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        this.rowQFilter.clear();
        if (!qFilters.isEmpty()) {
            for (QFilter qFilter : qFilters) {
                if (!"accno".equalsIgnoreCase(qFilter.getProperty())) continue;
                this.rowQFilter.add(qFilter);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        List qFilters = ((BillList)args.getSource()).getClientQueryFilterParameter().getQFilters();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String fromId = (String)listShowParameter.getCustomParam("fromId");
        String isInitFilter = this.getPageCache().get("isInitFilter");
        if (StringUtils.isEmpty((String)isInitFilter) && Objects.equals(fromId, "receipt_stats_by_bk_mon")) {
            QFilter qFilter;
            String month = (String)listShowParameter.getCustomParam("month");
            String year = (String)listShowParameter.getCustomParam("year");
            String bankVersionId = (String)listShowParameter.getCustomParam("bankVersionId");
            if (!StringUtil.isNullOrEmpty(year)) {
                qFilter = QFilter.of((String)"defect_year = ?", (Object[])new Object[]{year});
                qFilters.add(qFilter);
                this.rowQFilter.add(qFilter);
            }
            if (!StringUtil.isNullOrEmpty(month)) {
                qFilter = QFilter.of((String)"defect_month = ?", (Object[])new Object[]{month});
                qFilters.add(qFilter);
                this.rowQFilter.add(qFilter);
            }
            if (!StringUtil.isNullOrEmpty(bankVersionId)) {
                Long bankId = Long.parseLong(bankVersionId);
                QFilter qFilter2 = QFilter.of((String)"bank_version.id = ?", (Object[])new Object[]{bankId});
                qFilters.add(qFilter2);
                this.rowQFilter.add(qFilter2);
                this.getView().getPageCache().put("selectedBankId", bankVersionId);
            }
            this.getPageCache().put("isInitFilter", "true");
        }
        String bankVersionIdStr = this.getPageCache().get("selectedBankId");
        String selectedBankLoginIdStr = this.getPageCache().get("selectedBankLoginId");
        String startDateYearTime = "";
        String endDateYearTime = "";
        String startDateMonthTime = "";
        String endDateMonthTime = "";
        Long bankVersionId = null;
        Long bankLoginId = null;
        if (!StringUtils.isEmpty((String)bankVersionIdStr)) {
            bankVersionId = Long.parseLong(bankVersionIdStr);
        }
        if (!StringUtils.isEmpty((String)selectedBankLoginIdStr)) {
            bankLoginId = Long.parseLong(selectedBankLoginIdStr);
        }
        for (QFilter filter : qFilters) {
            if (filter.getProperty().startsWith("defect_year")) {
                startDateYearTime = (String)filter.getValue();
                endDateYearTime = (String)filter.getValue();
                continue;
            }
            if (!filter.getProperty().startsWith("defect_month")) continue;
            startDateMonthTime = (String)filter.getValue();
            endDateMonthTime = (String)filter.getValue();
        }
        if (StringUtils.isEmpty((String)startDateMonthTime) || StringUtils.isEmpty((String)endDateMonthTime)) {
            return;
        }
        if (StringUtils.isBlank((String)startDateYearTime) || StringUtils.isBlank((String)endDateYearTime)) {
            startDateYearTime = LocalDateUtil.formatDate((LocalDate)LocalDate.now(), (String)"YYYY");
            endDateYearTime = LocalDateUtil.formatDate((LocalDate)LocalDate.now(), (String)"YYYY");
        }
        if (StringUtils.isBlank((String)startDateMonthTime) || StringUtils.isBlank((String)endDateMonthTime)) {
            startDateMonthTime = LocalDateUtil.formatDate((LocalDate)LocalDate.now().minusMonths(1L), (String)"MM");
            endDateMonthTime = LocalDateUtil.formatDate((LocalDate)LocalDate.now().minusMonths(1L), (String)"MM");
            if (Objects.equals(startDateMonthTime, "12")) {
                startDateYearTime = LocalDateUtil.formatDate((LocalDate)LocalDate.now().minusYears(1L), (String)"YYYY");
                endDateYearTime = LocalDateUtil.formatDate((LocalDate)LocalDate.now().minusYears(1L), (String)"YYYY");
            }
        }
        final Long finalBankVersionId = bankVersionId;
        final Long finalLoginID = bankLoginId;
        final IPageCache iPageCache = this.getPageCache();
        final Date finalStartDate = DateUtil.string2Date((String)(startDateYearTime + startDateMonthTime + "01"), (String)"yyyyMMdd");
        String endDayStr = ReceiptDefectStatisticsByBankAndBankLoginAndMonthPlugin.getDaysByYearMonth(startDateYearTime, startDateMonthTime) + "";
        if (Integer.parseInt(startDateMonthTime) == LocalDate.now().getMonth().getValue()) {
            endDayStr = LocalDateUtil.formatDate((LocalDate)LocalDate.now(), (String)"dd");
        }
        final Date finalEndDate = DateUtil.string2Date((String)(endDateYearTime + endDateMonthTime + endDayStr), (String)"yyyyMMdd");
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                int currentPage = start / limit;
                int pageSize = limit;
                DynamicObjectCollection dObjectCollection = ReceiptDefectStatisticsByBankAndBankLoginAndMonthPlugin.this.getCollection(finalBankVersionId, finalLoginID, finalStartDate, finalEndDate, currentPage, pageSize);
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(ReceiptDefectStatisticsByBankAndBankLoginAndMonthPlugin.this.dataCount);
                iPageCache.put("dataCount", ReceiptDefectStatisticsByBankAndBankLoginAndMonthPlugin.this.dataCount + "");
                return dObjectCollection;
            }

            public int getRealCount() {
                String dataCountStr = iPageCache.get("dataCount");
                if (!StringUtil.isNullOrEmpty(dataCountStr)) {
                    ReceiptDefectStatisticsByBankAndBankLoginAndMonthPlugin.this.dataCount = Integer.parseInt(dataCountStr);
                }
                return ReceiptDefectStatisticsByBankAndBankLoginAndMonthPlugin.this.dataCount;
            }
        });
    }

    private DynamicObjectCollection getCollection(Long bankVersionID, Long bankLoginId, Date startDate, Date endDate, int pageIndex, int pageSize) {
        Throwable throwable;
        DynamicObjectCollection dCollection = QueryServiceHelper.query((String)ENTITY_KEY, (String)"id,bank_name, bank_login_number, accno,defect_day", null);
        StringBuilder sql = new StringBuilder("select count(1) as defectCount,t.FBANK_VERSION,t.FACC_NO as accNo,t.FBANK_LOGIN  from t_receipt_download_task as t,t_aqap_bank_acnt as b where t.FSTATUS IN ('11','6') and t.fdefect_type!=' ' and t.FACC_NO=b.FID and b.fenable='1'  AND t.ftrans_date >= ? AND t.ftrans_date <= ? AND t.fcustom_id = ? ");
        ArrayList<Object> pramsList = new ArrayList<Object>(16);
        pramsList.add(0, startDate);
        pramsList.add(1, endDate);
        pramsList.add(2, RequestContext.get().getTenantId());
        this.getPageCache().put("startTimeStr", DateUtil.formatDate((Date)startDate, (String)"yyyy-MM-dd"));
        this.getPageCache().put("endTimeStr", DateUtil.formatDate((Date)endDate, (String)"yyyy-MM-dd"));
        if (bankVersionID != null) {
            sql.append(" AND t.FBANK_VERSION = ? ");
            pramsList.add(bankVersionID);
            this.getPageCache().put("selectedBankId", bankVersionID.toString());
        }
        if (bankLoginId != null) {
            sql.append(" AND t.FBANK_LOGIN = ? ");
            pramsList.add(bankLoginId);
            this.getPageCache().put("selectedBankLoginId", bankLoginId.toString());
        }
        if (this.rowQFilter != null) {
            for (QFilter filter : this.rowQFilter) {
                if (!filter.getProperty().startsWith("accno")) continue;
                if (filter.getValue() instanceof QEmptyValue) {
                    sql.append(" AND   b.FNUMBER =''");
                    continue;
                }
                String value = (String)filter.getValue();
                String cp = filter.getCP();
                if (Objects.equals(cp, "is not null")) {
                    sql.append(" AND   b.FNUMBER is not null  AND b.FNUMBER != '' AND b.FNUMBER != ' '");
                    continue;
                }
                sql.append(" AND   b.FNUMBER ").append(cp).append(" '").append(value).append("' ");
            }
        }
        sql.append("group by t.FBANK_VERSION,t.FBANK_LOGIN,t.FACC_NO  order by defectCount desc;");
        Object[] params = pramsList.toArray();
        String bankVersionName = "";
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)ENTITY_KEY_RECEIPT_DOWNLOAD_TASK);
        try {
            throwable = null;
            try (DataSet dataSet = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".query"), (DBRoute)new DBRoute(dataEntityType.getDBRouteKey()), (String)sql.toString(), (Object[])params);){
                int countIndex = 0;
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    ++countIndex;
                }
                this.dataCount = countIndex;
            }
            catch (Throwable countIndex) {
                throwable = countIndex;
                throw countIndex;
            }
        }
        catch (Exception dataSet) {
            // empty catch block
        }
        try {
            throwable = null;
            try (DataSet ds = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".query"), (DBRoute)new DBRoute(dataEntityType.getDBRouteKey()), (String)sql.toString(), (Object[])params).limit(pageIndex * pageSize, pageSize);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    DynamicObject data = dCollection.addNew();
                    String accNoId = row.getString("accNo");
                    DynamicObject dynamicObject = this.bankAcntRepository.findById(Long.valueOf(Long.parseLong(accNoId)));
                    data.set("id", (Object)accNoId);
                    data.set("bank_name", (Object)dynamicObject.getString("group.name"));
                    data.set("bank_login_number", (Object)dynamicObject.getString("bank_login.number"));
                    data.set("accno", (Object)dynamicObject.getString("number"));
                    data.set("defect_day", (Object)row.getString("defectCount"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dCollection;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("search".equals(operateKey)) {
            String year = this.getPageCache().get("defect_year");
            String month = this.getPageCache().get("defect_month");
            if (StringUtils.isEmpty((String)year)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7f3a\u5931\u5e74\u4efd\u3002", (String)"ReceiptDefectStatisticsByBankAndBankLoginAndMonthPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isEmpty((String)month)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7f3a\u5931\u6708\u4efd\u3002", (String)"ReceiptDefectStatisticsByBankAndBankLoginAndMonthPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().invokeOperation("refresh");
        }
        if (Objects.equals(TEST_DEFECT_SETTING_KEY, operateKey)) {
            this.showSettingPage();
        }
        if (Objects.equals(operateKey, "exportlistbyselectfields")) {
            return;
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        boolean isInit = StringUtil.isNullOrEmpty(this.getView().getPageCache().get("initCacheKey"));
        if (isInit) {
            String year = LocalDateUtil.formatDate((LocalDate)LocalDate.now(), (String)"YYYY");
            String monthEndDay = LocalDateUtil.formatDate((LocalDate)LocalDate.now().minusMonths(1L), (String)"MM");
            if (Objects.equals(monthEndDay, "12")) {
                year = LocalDateUtil.formatDate((LocalDate)LocalDate.now().minusYears(1L), (String)"YYYY");
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map paramMap = formShowParameter.getCustomParams();
            String bankVersionName = "";
            if (!CollectionUtils.isEmpty((Map)paramMap)) {
                String bank;
                String yearStr;
                bankVersionName = (String)paramMap.get("bankVersionName");
                String month = (String)paramMap.get("month");
                if (!StringUtil.isNullOrEmpty(month)) {
                    monthEndDay = month;
                }
                if (!StringUtil.isNullOrEmpty(yearStr = (String)paramMap.get("year"))) {
                    year = yearStr;
                }
                if (!StringUtil.isNullOrEmpty(bank = (String)paramMap.get("bankVersionId"))) {
                    bankVersionName = bank;
                    this.getPageCache().put("selectedBankId", bankVersionName);
                }
            }
            this.getPageCache().put("defect_year", year);
            this.getPageCache().put("defect_month", monthEndDay);
            this.getView().getPageCache().put("initCacheKey", "YES");
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if (fieldName.equals("defect_year")) {
                    List<ComboItem> acctItems = this.initDefectYearItemsList();
                    List currencyItems = commonFilterColumn.getComboItems();
                    currencyItems.clear();
                    commonFilterColumn.setComboItems(acctItems);
                    commonFilterColumn.setDefaultValue(year);
                }
                if (fieldName.equals("defect_month")) {
                    commonFilterColumn.setDefaultValue(monthEndDay + "");
                }
                if (!fieldName.equals("bank_version.number") || !kd.ebg.egf.common.utils.string.StringUtils.isNotEmpty((String)bankVersionName)) continue;
                commonFilterColumn.setDefaultValue(bankVersionName);
            }
        } else {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if (!fieldName.equals("defect_year")) continue;
                List<ComboItem> acctItems = this.initDefectYearItemsList();
                List currencyItems = commonFilterColumn.getComboItems();
                currencyItems.clear();
                commonFilterColumn.setComboItems(acctItems);
            }
            super.filterContainerInit(args);
        }
        this.getView().getPageCache().put("initCacheKey", "NO");
    }

    public List<ComboItem> initDefectYearItemsList() {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>(16);
        String nowYear = LocalDateUtil.formatDate((LocalDate)LocalDate.now(), (String)"YYYY");
        int nowYearInt = Integer.parseInt(nowYear);
        for (int i = 2019; i <= nowYearInt; ++i) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"ReceiptDefectStatisticsByBankAndBankLoginAndMonthPlugin_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), i)));
            item.setValue(i + "");
            acctItems.add(item);
        }
        return acctItems;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String result;
        if (closedCallBackEvent.getReturnData() != null && "success".equals(result = (String)closedCallBackEvent.getReturnData())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void showSettingPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("receipt_auto_check_sett");
        StyleCss style = new StyleCss();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(style);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "test"));
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(showParameter);
    }

    public static int getDaysByYearMonth(String year, String month) {
        Calendar a = Calendar.getInstance();
        a.set(1, Integer.parseInt(year));
        a.set(2, Integer.parseInt(month) - 1);
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public void registerListener(EventObject e) {
        BillList entryGrid = (BillList)this.getView().getControl("billlistap");
        if (entryGrid != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
    }

    public void listRowClick(ListRowClickEvent evt) {
        evt.getPageIndex();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)8);
        String startTimeStr = this.getPageCache().get("startTimeStr");
        String endTimeStr = this.getPageCache().get("endTimeStr");
        if (Objects.equals("defect_day", args.getFieldName())) {
            args.setCancel(true);
            BillListHyperLinkClickEvent billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            ListSelectedRow listSelectedRow = billListHyperLinkClickEvent.getCurrentRow();
            Long id = (Long)listSelectedRow.getPrimaryKeyValue();
            customParams.put("startTimeStr", startTimeStr);
            customParams.put("endTimeStr", endTimeStr);
            customParams.put("accNoId", id);
            customParams.put("fromId", "receipt_defect_sta_by_mon");
            ShowPageUtil.showListPage("receipt_task_defect", customParams, this.getView());
        }
    }
}

