/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.statistics;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.front.api.boot.utils.StringUtils;
import kd.ebg.receipt.formplugin.plugin.common.EbgCommonFilterContainerPlugin;
import kd.ebg.receipt.formplugin.util.CosmicDateUtil;
import kd.ebg.receipt.formplugin.util.LocalDateUtils;
import kd.ebg.receipt.formplugin.util.ReceiptStatisticsUtil;
import kd.ebg.receipt.formplugin.util.StringUtil;

public class ReceiptStatisticsByAcntAndMonthPlugin
extends EbgCommonFilterContainerPlugin {
    private static String ENTITY_KEY = "receipt_stats_by_ac_mon";
    private static String ENTITY_KEY_RECEIPT_DOWNLOAD_TASK = "receipt_download_task";
    private int dataCount = 0;
    private EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptStatisticsByAcntAndMonthPlugin.class);
    private BankVersionRepository bankVersionRepository = BankVersionRepository.getInstance();
    private BankVersionService bankVersionService = BankVersionService.getInstance();
    private BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final String customID = RequestContext.get().getTenantId();
        String startDateTime = "";
        String endDateTime = "";
        Long bankVersionId = null;
        Long acntID = null;
        Long bankLoginId = null;
        String bankVersionIdStr = this.getPageCache().get("selectedBankId");
        String selectedBankLoginIdStr = this.getPageCache().get("selectedBankLoginId");
        String selectedAcntIdStr = this.getPageCache().get("selectedAcntId");
        startDateTime = this.getPageCache().get("startDateTime");
        endDateTime = this.getPageCache().get("endDateTime");
        if (!StringUtils.isEmpty((String)bankVersionIdStr)) {
            bankVersionId = Long.parseLong(bankVersionIdStr);
        }
        if (!StringUtils.isEmpty((String)selectedBankLoginIdStr)) {
            bankLoginId = Long.parseLong(selectedBankLoginIdStr);
        }
        if (!StringUtils.isEmpty((String)selectedAcntIdStr)) {
            acntID = Long.parseLong(selectedAcntIdStr);
        }
        if (EBGStringUtils.isEmpty((String)startDateTime) || EBGStringUtils.isEmpty((String)endDateTime)) {
            return;
        }
        if (bankVersionId == null && acntID == null) {
            return;
        }
        LocalDate startDate = LocalDate.parse(startDateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDate endDate = LocalDate.parse(endDateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        if (LocalDate.now().isBefore(startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u90fd\u5927\u4e8e\u4eca\u5929\u3002", (String)"ReceiptStatisticsByAcntAndMonthPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            return;
        }
        if (LocalDate.now().isBefore(endDate)) {
            endDate = LocalDate.now();
            endDateTime = LocalDateUtil.formatDate((LocalDate)endDate, (String)"yyyy-MM-dd");
        }
        final Long finalBankVersionId = bankVersionId;
        final Long finalBankLoginId = bankLoginId;
        final Long finalAcntID = acntID;
        final IPageCache iPageCache = this.getPageCache();
        final Date finalStartDate = DateUtil.string2Date((String)startDateTime, (String)"yyyy-MM-dd");
        final Date finalEndDate = DateUtil.string2Date((String)endDateTime, (String)"yyyy-MM-dd");
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                int currentPage = start / limit;
                int pageSize = limit;
                DynamicObjectCollection dObjectCollection = ReceiptStatisticsByAcntAndMonthPlugin.this.getCollection(finalBankVersionId, finalBankLoginId, finalAcntID, finalStartDate, finalEndDate, customID, currentPage, pageSize);
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(ReceiptStatisticsByAcntAndMonthPlugin.this.dataCount);
                iPageCache.put("dataCount", ReceiptStatisticsByAcntAndMonthPlugin.this.dataCount + "");
                return dObjectCollection;
            }

            public int getRealCount() {
                String dataCountStr = iPageCache.get("dataCount");
                if (!StringUtil.isNullOrEmpty(dataCountStr)) {
                    ReceiptStatisticsByAcntAndMonthPlugin.this.dataCount = Integer.parseInt(dataCountStr);
                }
                return ReceiptStatisticsByAcntAndMonthPlugin.this.dataCount;
            }
        });
    }

    private DynamicObjectCollection getCollection(Long bankVersionID, Long finalBankLoginId, Long acntID, Date startDate, Date endDate, String customID, int pageIndex, int pageSize) {
        DynamicObjectCollection dCollection = QueryServiceHelper.query((String)ENTITY_KEY, (String)"id, bank_version_name, accno, trans_month, receipt_num, detail_num, match_num, upload_num, complete_pc, match_pc, upload_pc,bank_login_name", null);
        String startDateStr = DateUtil.formatDate((Date)startDate, (String)"yyyy-MM-dd");
        String endDateStr = DateUtil.formatDate((Date)endDate, (String)"yyyy-MM-dd");
        List<String> betweenMonths = LocalDateUtils.getMonthBetweenTrans(startDateStr, endDateStr);
        ArrayList<JSONObject> recordList = new ArrayList<JSONObject>(1);
        HashMap accNoMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = betweenMonths.size() - 1; i >= 0; --i) {
            Long acntFilter;
            DynamicObject bankVersion;
            String month = betweenMonths.get(i);
            StringBuilder sql = new StringBuilder("SELECT B.fnumber AS accno,SUM(A.FDETAIL_NUM) AS detail_num, SUM(A.FRECEIPT_NUM) AS receipt_num,SUM(A.FMATCH_NUM) AS match_num, SUM(A.FUPLOAD_NUM) AS upload_num FROM t_receipt_download_task as A ,t_aqap_bank_acnt as B WHERE B.FId=A.facc_no and A.ftrans_date >= {ts'%s 00:00:00'} AND A.ftrans_date <= {ts'%s 00:00:00'} AND A.fcustom_id='%s' ");
            if (acntID == null) {
                bankVersion = this.bankVersionRepository.loadDynamicObjectByID(bankVersionID);
                acntFilter = bankVersionID;
                if (finalBankLoginId != null) {
                    sql.append(" AND A.fbank_login = %s ");
                    acntFilter = finalBankLoginId;
                } else {
                    sql.append(" AND A.fbank_version = %s ");
                }
            } else {
                sql.append(" AND B.fid = %s           ");
                acntFilter = acntID;
                bankVersion = this.bankVersionService.findByAcntId(acntID);
            }
            sql.append("group by B.fnumber");
            String startDateByMonthStr = LocalDateUtils.getStartDateByMonth(month);
            String endDateByMonthStr = LocalDateUtils.getEndDateByMonth(month);
            Date startDateByMonth = DateUtil.string2Date((String)startDateByMonthStr, (String)"yyyyMMdd");
            Date endDateByMonth = DateUtil.string2Date((String)endDateByMonthStr, (String)"yyyyMMdd");
            startDateByMonthStr = DateUtil.formatDate((Date)startDateByMonth, (String)"yyyy-MM-dd");
            endDateByMonthStr = DateUtil.formatDate((Date)endDateByMonth, (String)"yyyy-MM-dd");
            String sqlStr = String.format(sql.toString(), startDateByMonthStr, endDateByMonthStr, RequestContext.get().getTenantId(), acntFilter);
            String bankVersionName = bankVersion.getString("name") + "(" + bankVersion.getString("number") + ")";
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)ENTITY_KEY_RECEIPT_DOWNLOAD_TASK);
            String monthStr = String.format("%s-%s", month.substring(0, 4), month.substring(4));
            try (DataSet dataSet = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".query"), (DBRoute)new DBRoute(dataEntityType.getDBRouteKey()), (String)sqlStr);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    JSONObject jsonObject = new JSONObject();
                    String accNo = row.getString("accno");
                    jsonObject.put("accNo", (Object)accNo);
                    jsonObject.put("receipt_num", (Object)row.getInteger("receipt_num"));
                    jsonObject.put("detail_num", (Object)row.getInteger("detail_num"));
                    jsonObject.put("match_num", (Object)row.getInteger("match_num"));
                    jsonObject.put("upload_num", (Object)row.getInteger("upload_num"));
                    jsonObject.put("bankVersionName", (Object)bankVersionName);
                    jsonObject.put("monthStr", (Object)monthStr);
                    if (accNoMap.containsKey(accNo)) {
                        String bankLoginId = (String)accNoMap.get(accNo);
                        jsonObject.put("bankLoginId", (Object)bankLoginId);
                    } else {
                        DynamicObject dynamicObject = this.bankAcntRepository.findDataByAccNoAndCustomId(row.getString("accno"), RequestContext.get().getTenantId());
                        String bankLoginId = (String)dynamicObject.get("bank_login.number");
                        jsonObject.put("bankLoginId", (Object)bankLoginId);
                        accNoMap.put(accNo, bankLoginId);
                    }
                    recordList.add(jsonObject);
                }
                continue;
            }
            catch (Exception e) {
                this.logger.monitorInfo(e.getMessage());
            }
        }
        this.dataCount = recordList.size();
        List pageRecordList = StringUtil.limitByIndexAndSize(recordList, pageIndex, pageSize);
        for (JSONObject jsonObject : pageRecordList) {
            String bankVersionName = jsonObject.getString("bankVersionName");
            String monthStr = jsonObject.getString("monthStr");
            this.installCollection(dCollection, jsonObject, bankVersionName, monthStr);
        }
        return dCollection;
    }

    public void installCollection(DynamicObjectCollection dCollection, JSONObject jsonObject, String bankVersionName, String monthStr) {
        DynamicObject data = dCollection.addNew();
        data.set("id", (Object)(jsonObject.getString("accNo") + "_" + monthStr));
        data.set("bank_version_name", (Object)bankVersionName);
        data.set("accno", (Object)jsonObject.getString("accNo"));
        data.set("trans_month", (Object)monthStr);
        String bankLoginId = (String)jsonObject.get((Object)"bankLoginId");
        data.set("bank_login_name", (Object)bankLoginId);
        int receiptCount = jsonObject.getInteger("receipt_num");
        int detailCount = jsonObject.getInteger("detail_num");
        int matchCount = jsonObject.getInteger("match_num");
        int uploadCount = jsonObject.getInteger("upload_num");
        ReceiptStatisticsUtil.buildStatisticsResult(receiptCount, detailCount, matchCount, uploadCount, data);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("search".equals(formOperate.getOperateKey())) {
            String selectedBankId = this.getPageCache().get("selectedBankId");
            String selectedBankLoginId = this.getPageCache().get("selectedBankLoginId");
            String selectedAcntId = this.getPageCache().get("selectedAcntId");
            String startDateTime = this.getPageCache().get("startDateTime");
            if (StringUtils.isEmpty((String)selectedBankId) && StringUtils.isEmpty((String)selectedBankLoginId) && StringUtils.isEmpty((String)selectedAcntId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u81f3\u5c11\u9009\u62e9\u94f6\u884c\u7248\u672c/\u524d\u7f6e\u673a\u7f16\u53f7/\u94f6\u884c\u8d26\u53f7\u4e2d\u7684\u4e00\u9879\u3002", (String)"ReceiptStatisticsByAcntAndMonthPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isEmpty((String)startDateTime)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56de\u5355\u65e5\u671f\u3002", (String)"ReceiptStatisticsByAcntAndMonthPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().invokeOperation("refresh");
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        boolean isInit = StringUtil.isNullOrEmpty(this.getView().getPageCache().get("initCacheKey"));
        if (isInit) {
            String startDateTime = CosmicDateUtil.getMonthFirstDay(LocalDate.now().minusMonths(1L));
            String endDateTime = CosmicDateUtil.getMonthEndDay(LocalDate.now().minusMonths(1L));
            this.getPageCache().put("startDateTime", startDateTime);
            this.getPageCache().put("endDateTime", endDateTime);
            this.getView().getPageCache().put("initCacheKey", "YES");
        }
        super.filterContainerInit(args);
        this.getView().getPageCache().put("initCacheKey", "NO");
    }
}

