/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.njb.dc.service.receipt.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.njb.dc.service.receipt.GLBPacker;
import kd.ebg.receipt.banks.njb.dc.service.receipt.TCommon;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.jdom2.Element;

public class SearchBankReceiptImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SearchBankReceiptImpl.class);

    public JSONArray process(BankReceiptRequest request) {
        logger.info("800190\u63a5\u53e3");
        int dot = 999;
        logger.info("\u5357\u4eac\u94f6\u884c--" + ++dot);
        JSONArray jsonArray = new JSONArray();
        this.setCurrentPage("0");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            logger.info("\u5357\u4eac\u94f6\u884c--" + ++dot);
            BankReceiptResponseEB response = this.doBiz(request);
            logger.info("\u5357\u4eac\u94f6\u884c--" + ++dot);
            if (Objects.nonNull(response) && Objects.nonNull(response.getData())) {
                logger.info("\u5357\u4eac\u94f6\u884c--" + ++dot);
                jsonArray.addAll((Collection)((JSONArray)response.getData()));
                logger.info("\u5357\u4eac\u94f6\u884c--" + ++dot);
            }
            int currentPage = Integer.parseInt(this.getCurrentPage());
            this.setCurrentPage(currentPage + 1);
        }
        return jsonArray;
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String bankLoginID = bankReceiptRequest.getHeader().getBankLoginID();
        Element root = GLBPacker.getHeadPackerData("800190", "0", bankLoginID);
        Element body = new Element("body");
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String date = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"start_date", (String)date);
        JDomUtils.addChild((Element)body, (String)"end_date", (String)date);
        JDomUtils.addChild((Element)body, (String)"acno", (String)bankReceiptRequest.getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)bankReceiptRequest.getAcnt().getCurrency());
        int currentPage = Integer.parseInt(this.getCurrentPage());
        if (currentPage == 0) {
            JDomUtils.addChild((Element)body, (String)"origin_num", (String)"0");
        } else {
            JDomUtils.addChild((Element)body, (String)"origin_num", (String)String.valueOf(currentPage * 20 + 1));
        }
        JDomUtils.addChild((Element)root, (Element)body);
        String ret = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return TCommon.createCommonMsg(ret);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        this.setLastPage(true);
        Element root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(s), (String)RequestContextUtils.getCharset());
        Element head = root.getChild("head");
        String retCode = head.getChildText("ret_code");
        String succFlag = head.getChildText("succ_flag");
        if ("0000".equalsIgnoreCase(retCode) && "0".equalsIgnoreCase(succFlag)) {
            Element body = root.getChild("body");
            String ret_nums = body.getChildTextTrim("ret_nums");
            if (ret_nums == null || Integer.parseInt(ret_nums) <= 0) {
                return BankReceiptResponseEB.success();
            }
            List lists = body.getChildren("List");
            this.setLastPage(lists.size() < 20);
            JSONArray retAarry = new JSONArray();
            for (int i = 0; i < lists.size(); ++i) {
                JSONObject jsonObject = new JSONObject();
                Element list = (Element)lists.get(i);
                String transcode = list.getChildTextTrim("transcode");
                String host_serial_no = list.getChildTextTrim("host_serial_no");
                String trans_no = list.getChildTextTrim("trans_no");
                String trans_amt = list.getChildTextTrim("trans_amt");
                String custAcno = list.getChildTextTrim("cust_acno");
                String accname = list.getChildTextTrim("accname");
                String openOrg = list.getChildTextTrim("open_org");
                String trans_date = list.getChildTextTrim("trans_date");
                String trans_time = list.getChildTextTrim("trans_time");
                String crdr_flag = list.getChildTextTrim("crdr_flag");
                jsonObject.put("trans_date", (Object)trans_date);
                jsonObject.put("trans_time", (Object)trans_time);
                jsonObject.put("transcode", (Object)transcode);
                jsonObject.put("host_serial_no", (Object)host_serial_no);
                jsonObject.put("trans_no", (Object)trans_no);
                jsonObject.put("trans_amt", (Object)trans_amt);
                jsonObject.put("cust_acno", (Object)custAcno);
                jsonObject.put("accname", (Object)accname);
                jsonObject.put("open_org", (Object)openOrg);
                jsonObject.put("crdr_flag", (Object)crdr_flag);
                retAarry.add((Object)jsonObject);
            }
            return BankReceiptResponseEB.success((Object)retAarry);
        }
        String ret_info = head.getChildText("ret_info");
        String ext_info = head.getChildText("ext_info");
        String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\uff0c\u9644\u52a0\u5f02\u5e38\u4fe1\u606f%3$s\u3002", (String)"SearchBankReceiptImpl_4", (String)"ebg-receipt-banks-njb-dc", (Object[])new Object[0]), retCode, ret_info, ext_info);
        throw EBExceiptionUtil.serviceException((String)resMsg);
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "800190";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"SearchBankReceiptImpl_3", (String)"ebg-receipt-banks-njb-dc", (Object[])new Object[0]);
    }
}

