/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccb.dc.service.receipt.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailParser {
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailParser.class);

    public static Element parseString2Root(String rspStr) throws EBServiceException {
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        return root;
    }

    public static BankResponse parseResponse(Element root) throws EBServiceException {
        BankResponse rsp = new BankResponse();
        String return_code = DetailParser.checkUnNullableElement(root, "RETURN_CODE");
        String return_msg = root.getChildTextTrim("RETURN_MSG");
        rsp.setResponseCode(return_code);
        rsp.setResponseMessage(return_msg);
        return rsp;
    }

    public static String checkUnNullableElement(Element parent, String childName) {
        String childValue = parent.getChildTextTrim(childName);
        if (StringUtils.isEmpty((String)childValue)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u542b%s\u8282\u70b9", (String)"DetailParser_0", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]), childName));
        }
        return childValue;
    }

    public List<DetailInfo> parseDetail(String rspStr) throws EBServiceException {
        return this.parseNormalDetail(rspStr);
    }

    public static String preTreatXML(String responseStr) {
        StringBuilder sb = new StringBuilder();
        String xml = "";
        int totalLen = responseStr.length();
        int startIndex = 0;
        int endIndex = 0;
        int lastIndex = 0;
        int offset = 0;
        while (startIndex > -1) {
            xml = responseStr.substring(lastIndex, totalLen);
            startIndex = xml.indexOf("<DET>");
            endIndex = xml.indexOf("</DET>");
            if (startIndex > 0 && endIndex > 0) {
                sb.append(responseStr.substring(offset, startIndex += offset));
                String tempString = responseStr.substring(startIndex, endIndex += offset).substring("<DET>".length());
                tempString = tempString.replaceAll("<", "(").replaceAll(">", ")");
                sb.append("<DET>").append(tempString).append("</DET>");
                offset = lastIndex = endIndex + "</DET>".length();
                continue;
            }
            sb.append(xml);
        }
        return sb.toString();
    }

    public List<DetailInfo> parseNormalDetail(String rspStr) throws EBServiceException {
        rspStr = DetailParser.preTreatXML(rspStr);
        Element root = DetailParser.parseString2Root(rspStr);
        BankResponse response = DetailParser.parseResponse(root);
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>(16);
        String rspCode = response.getResponseCode();
        if ("000000".equalsIgnoreCase(rspCode)) {
            Element txInfo = root.getChild("TX_INFO");
            String err_level = root.getChildText("ERR_LEVEL");
            if (!StringUtils.isEmpty((String)err_level)) {
                String err_msg = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u6d88\u606f:%s", (String)"DetailParser_1", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]), root.getChildText("ERR_MSG"));
                this.log.info(err_msg);
                throw EBExceiptionUtil.serviceException((String)err_msg);
            }
            Element DETAILLIST = txInfo.getChild("DETAILLIST");
            List detail = DETAILLIST.getChildren("DETAILINFO");
            if (detail == null || detail.size() == 0) {
                this.log.info("\u8fd4\u56deDETAIL\u8282\u70b9: null == detail || 0 == detail.size()");
                return new ArrayList<DetailInfo>();
            }
            String totalPage = txInfo.getChildTextTrim("TOTAL_PAGE");
            if ("0".equalsIgnoreCase(totalPage)) {
                return list;
            }
            for (Element detailElement : detail) {
                String oppAccNo = detailElement.getChildTextTrim("ACCNO2");
                String oppAccName = detailElement.getChildTextTrim("ACC_NAME1");
                DetailInfo detailInfo = new DetailInfo();
                detailInfo.setOppAccNo(oppAccNo);
                detailInfo.setOppAccName(oppAccName);
                String amountStr = detailElement.getChildTextTrim("AMT");
                String cdFlag = detailElement.getChildTextTrim("FLAG1");
                String tranFlow = JDomUtils.getChildText((Element)detailElement, (String)"TRAN_FLOW");
                detailInfo.setBizRefNo(tranFlow);
                detailInfo.setReversed1(amountStr);
                detailInfo.setReversed2(cdFlag);
                list.add(detailInfo);
            }
            return list;
        }
        throw EBExceiptionUtil.serviceException((String)(rspCode + " " + response.getResponseMessage()));
    }

    public static boolean isNoDetilRspCode(String rspCode) {
        StringBuilder noDetailCode = new StringBuilder();
        noDetailCode.append("200001").append("_");
        noDetailCode.append("990000").append("_");
        noDetailCode.append("310211").append("_");
        noDetailCode.append("1261").append("_");
        noDetailCode.append("8440ZX310211").append("_");
        noDetailCode.append("8212ZXXX1261").append("_");
        noDetailCode.append("8230ZX200000").append("_");
        noDetailCode.append("8310ZX880002");
        return -1 != noDetailCode.toString().indexOf(rspCode);
    }
}

