/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zrc.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.zrc.dc.service.receipt.ZRCDCCommConfig;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import org.jdom2.Element;

public class ReceiptCreateImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptCreateImpl.class);
    private static String encoding = "UTF-8";

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String bankLoginId = EBContext.getContext().getBankLoginID();
        ZRCDCCommConfig zrcdcCommConfig = (ZRCDCCommConfig)EBConfigBuilder.getInstance().buildConfig(ZRCDCCommConfig.class, bankLoginId);
        Element root = new Element("ROOT");
        Element opReq = JDomUtils.addChild((Element)root, (String)"opReq");
        if (Objects.equals(zrcdcCommConfig.getReceipt_download_way(), "BSElecReceiptListCreate")) {
            JDomUtils.addChild((Element)opReq, (String)"opName", (String)"BSElecReceiptListCreate");
        } else {
            JDomUtils.addChild((Element)opReq, (String)"opName", (String)"BSElecReceiptListComCreate");
        }
        Element body = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)body, (String)"userID", (String)RequestContextUtils.getBankParameterValue((String)"userid"));
        JDomUtils.addChild((Element)body, (String)"PackageID", (String)Sequence.gen14Sequence());
        JDomUtils.addChild((Element)body, (String)"Account_num", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"QueryDate", (String)transDateStr);
        JDomUtils.addChild((Element)body, (String)"FilePath", (String)zrcdcCommConfig.getReceiptFilePath());
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        logger.info("\u5f20\u5bb6\u6e2f\u519c\u5546\u884c\u94f6\u884c-\u56de\u5355\u751f\u6210-\u63a5\u53e3\uff1a{}-{}-{}-\u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{this.getBizCode(), accNo, transDateStr, RspMsg});
        return RspMsg;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String rspStr) {
        String accNo = bankReceiptRequest.getAccNo();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        logger.info("\u5f20\u5bb6\u6e2f\u519c\u5546\u884c\u94f6\u884c-\u56de\u5355\u751f\u6210-\u63a5\u53e3\uff1a{}-{}-{}-\u54cd\u5e94\u53c2\u6570\uff1a{}", new Object[]{this.getBizCode(), accNo, transDateStr, rspStr});
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element opRep = JDomUtils.getUnNullChildElement((Element)root, (String)"opRep");
        Element opResult = JDomUtils.getUnNullChildElement((Element)opRep, (String)"opResult");
        String retCode = opResult.getChildText("retCode");
        String errMsg = opResult.getChildText("errMsg");
        if ("1".equals(retCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56de\u5355\u63a5\u53e3\uff1aBSElecReceiptListCreate-\u8c03\u7528\u56de\u5355\u751f\u6210\u5931\u8d25\uff0c\u8fd4\u56de\u7801\u4e3a1\uff0c%s\u3002", (String)"ReceiptCreateImpl_5", (String)"ebg-receipt-banks-zrc-dc", (Object[])new Object[0]), errMsg));
        }
        if (retCode == null || !"0".equals(retCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56de\u5355\u63a5\u53e3\uff1aBSElecReceiptListCreate-\u8c03\u7528\u56de\u5355\u751f\u6210\u5931\u8d25\uff0c\u8fd4\u56de\u7801\u4e3a%\u3002", (String)"ReceiptCreateImpl_6", (String)"ebg-receipt-banks-zrc-dc", (Object[])new Object[0]), retCode));
        }
        String account_num = JDomUtils.getUnNullChildText((Element)opResult, (String)"Account_num");
        String queryDate = JDomUtils.getUnNullChildText((Element)opResult, (String)"QueryDate");
        String filePath = JDomUtils.getUnNullChildText((Element)opResult, (String)"FilePath");
        if (!Objects.equals(accNo, account_num)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"BSElecReceiptListCreate\u63a5\u53e3\u8fd4\u56de\u7684\u8d26\u53f7\u8ddf\u8bf7\u6c42\u8d26\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"ReceiptCreateImpl_3", (String)"ebg-receipt-banks-zrc-dc", (Object[])new Object[0]));
        }
        return BankReceiptResponseEB.success((Object)filePath);
    }

    public String getDeveloper() {
        return "LW";
    }

    public String getBizCode() {
        return "BSElecReceiptListCreate";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u751f\u6210\u8bf7\u6c42\u3002", (String)"ReceiptCreateImpl_4", (String)"ebg-receipt-banks-zrc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        ZRCDCCommConfig zrcdcCommConfig = (ZRCDCCommConfig)EBConfigBuilder.getInstance().buildConfig(ZRCDCCommConfig.class, EBContext.getContext().getBankLoginID());
        StringBuilder uri = new StringBuilder();
        String code = Objects.equals(zrcdcCommConfig.getReceipt_download_way(), "BSElecReceiptListCreate") ? "BSElecReceiptListCreate" : "BSElecReceiptListComCreate";
        uri.append("/eweb/eweb-query.").append(code).append(".do?");
        uri.append("userPassword=").append(RequestContextUtils.getParameter().getBankParameter("user_password")).append("&SIGDATA=1");
        factory.setUri(uri.toString());
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }
}

