/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.opa.service.receipt;

import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.CmbOpaCommConfig;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.api.DcTaskIdRequestImpl;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.DownloadUtils;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.ReponseParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.UploadTaskStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        DownloadTaskService downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        DownloadListTask task = downloadTaskService.findById(taskId);
        String accNo = request.getAccNo();
        String bankLogin = task.getBankLoginId();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        if (downloadListDetails.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]));
        }
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String bakPathParentPath = FileStorageUtil.getFileBakPath((String)bankLogin) + File.separator + transDateStr;
        CmbOpaCommConfig cmbOpaCommConfig = (CmbOpaCommConfig)EBConfigBuilder.getInstance().buildConfig(CmbOpaCommConfig.class, bankLogin);
        RequestContextUtils.setRunningParam((String)"is_unique", (String)cmbOpaCommConfig.getIs_unique());
        for (DownloadListDetail detail : downloadListDetails) {
            String fileLink = detail.getFileLink();
            if (detail.getUploadFlag().intValue() == UploadTaskStatusEnum.UPLOAD_SUCCESS.getId() || detail.getMatchFlag().intValue() == MatchStatusEnum.SUCCESS.getId() || fileLink.contains(".pdf")) continue;
            result.addAll(this.download(detail, task, bakPathParentPath, cmbOpaCommConfig));
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u4e3a\u7a7a\u3002", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> download(DownloadListDetail downloadListDetail, DownloadListTask task, String bakPathParentPath, CmbOpaCommConfig cmbOpaCommConfig) {
        DcTaskIdRequestImpl dcTaskIdRequest = new DcTaskIdRequestImpl();
        String taskId = downloadListDetail.getFileLink();
        String fileName = downloadListDetail.getFileName();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().transDate(downloadListDetail.getTransDate()).accNo(downloadListDetail.getAccNo()).requestStr(taskId).build();
        BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)dcTaskIdRequest.doBiz((BankRequest)bankReceiptRequest);
        String receiptResponse = (String)receiptResponseEB.getData();
        String fileurl = ReponseParser.receiptParse_DCTASKID(receiptResponse);
        fileurl = this.handUrl(fileurl, cmbOpaCommConfig);
        logger.info("\u6587\u4ef6\u4e0b\u8f7dURL: {}-{}", new Object[]{fileName, fileurl});
        String filePath = bakPathParentPath + File.separator + fileName;
        File zipFile = FileCommonUtils.getFileByPath((String)filePath);
        if (!zipFile.exists()) {
            HashMap runningParams = Maps.newHashMapWithExpectedSize((int)16);
            runningParams.put("url", fileurl);
            runningParams.put("fileName", fileName);
            runningParams.put("savePath", bakPathParentPath);
            DownloadUtils.download(fileurl, fileName, bakPathParentPath);
        }
        List result = FileCommonUtils.getDetailList((DownloadListTask)task, (String)fileName);
        for (DownloadListDetail downloadListDetail1 : result) {
            downloadListDetail1.setFileLink(fileurl);
        }
        logger.info("\u56de\u5355\u8bb0\u5f55\u6570\u91cf-{}-{}\uff1a{}", new Object[]{task.getAccNo(), task.getTransDate(), result.size()});
        return result;
    }

    public String handUrl(String fileUrl, CmbOpaCommConfig cmbOpaCommConfig) {
        if (EBGStringUtils.isEmpty((String)cmbOpaCommConfig.getDownload_url()) || EBGStringUtils.isEmpty((String)cmbOpaCommConfig.getDownload_proxy_url())) {
            return fileUrl;
        }
        try {
            String downloadUrl = cmbOpaCommConfig.getDownload_url();
            String downloadProxyUrl = cmbOpaCommConfig.getDownload_proxy_url();
            String formatUrl = fileUrl.replace(downloadUrl, downloadProxyUrl);
            logger.info("\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u539f\u94fe\u63a5\uff1a{}", (Object)fileUrl);
            logger.info("\u8f6c\u6362\u4e4b\u540e\u7684\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u94fe\u63a5\uff1a{}", (Object)formatUrl);
            return formatUrl;
        }
        catch (Throwable throwable) {
            return fileUrl;
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CMB_OPA_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u62db\u884c\u65e0\u524d\u7f6e\u673a\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u3002", (String)"BankReceiptDownloadImpl_2", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]);
    }
}

