/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.opa.service.receipt.api;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.JsonUtil;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.MsgPacker;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.MsgParser;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.PostUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class DcTaskIdRequestImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DcTaskIdRequestImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        String taskId = bankReceiptRequest.getRequestStr();
        String transDate = LocalDateUtil.formatDate((LocalDate)bankReceiptRequest.getTransDate(), (String)"yyyy-MM-dd");
        JSONObject body = new JSONObject();
        body.put("taskid", (Object)taskId);
        body.put("qwenab", (Object)"");
        if (Objects.equals(RequestContextUtils.getRunningParam((String)"is_unique"), "true")) {
            body.put("qwenab", (Object)"false");
        }
        JSONObject head = JsonUtil.getHead("DCTASKID", Sequence.genSequence());
        JSONObject request = JsonUtil.getrequest(head, body);
        logger.info("\u56de\u5355\u5f02\u6b65\u6253\u5370\u7ed3\u679c\u67e5\u8be2-DCTASKID-\u8bf7\u6c42-\u660e\u6587-{}-{}-\uff1a\n{}", new Object[]{accNo, transDate, request.toJSONString()});
        String signMsg = MsgPacker.getSendMsg(request, logger, "DCTASKID");
        return signMsg;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        String accNo = bankReceiptRequest.getAccNo();
        String transDate = LocalDateUtil.formatDate((LocalDate)bankReceiptRequest.getTransDate(), (String)"yyyy-MM-dd");
        String res = MsgParser.getReceMsg(responseStr, logger);
        logger.info("\u56de\u5355\u5f02\u6b65\u6253\u5370\u7ed3\u679c\u67e5\u8be2-\uff08DCTASKID\uff09\u54cd\u5e94-\u89e3\u5bc6-{}-{}\uff1a{}", new Object[]{accNo, transDate, res});
        return BankReceiptResponseEB.success((Object)res);
    }

    public String getDeveloper() {
        return "LW";
    }

    public String getBizCode() {
        return "DCTASKID";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56de\u5355\u5f02\u6b65\u6253\u5370\u7ed3\u679c\u67e5\u8be2-DCTASKID\u3002", (String)"DcTaskIdRequestImpl_0", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public BankReceiptResponseEB doBiz(BankReceiptRequest request) {
        try {
            String rqstStr = this.pack(request);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(request, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }
}

