/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.opa.service.reconciliation.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.JsonUtil;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.MsgPacker;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.MsgParser;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.PostUtil;
import kd.ebg.receipt.business.receipt.atom.reconciliation.AbstractBankReconciliationImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankReconciliation;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;

public class IssueBillOfd
extends AbstractBankReconciliationImpl
implements IBankReconciliation {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(IssueBillOfd.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankReconciliationRequest bankReconciliationRequest) {
        String accNo = bankReconciliationRequest.getAccNo();
        String transDate = LocalDateUtil.formatDate((LocalDate)bankReconciliationRequest.getTransDate(), (String)"yyyyMMdd");
        JSONObject body = new JSONObject();
        JSONArray array = new JSONArray();
        JSONObject content = new JSONObject();
        content.put("accnbr", (Object)accNo);
        content.put("ccynbr", (Object)bankReconciliationRequest.getAcnt().getCurrency());
        content.put("billYear", (Object)transDate.substring(0, 4));
        content.put("billMonth", (Object)transDate.substring(4, 6));
        array.add((Object)content);
        body.put("CprDirectIssueBillOfdX1", (Object)array);
        JSONObject head = JsonUtil.getHead("issueBillOfd", Sequence.genSequence());
        JSONObject request = JsonUtil.getrequest(head, body);
        logger.info("issueBillOfd\u8bf7\u6c42-\u660e\u6587-{}-{}-\uff1a\n{}", new Object[]{accNo, transDate, request.toJSONString()});
        return MsgPacker.getSendMsg(request, logger, "issueBillOfd");
    }

    public BankReconciliationResponseEB parse(BankReconciliationRequest bankReconciliationRequest, String s) {
        String accNo = bankReconciliationRequest.getAccNo();
        String transDate = LocalDateUtil.formatDate((LocalDate)bankReconciliationRequest.getTransDate(), (String)"yyyyMMdd");
        String res = MsgParser.getReceMsg(s, logger);
        logger.info("issueBillOfd\u54cd\u5e94-\u89e3\u5bc6-{}-{}\uff1a{}", new Object[]{accNo, transDate, res});
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject response = request.getJSONObject("response");
        JSONObject head = response.getJSONObject("head");
        String resultcode = head.getString("resultcode");
        String resultmsg = head.getString("resultmsg");
        if (!"SUC0000".equals(resultcode)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff0c\u9519\u8bef\u4ee3\u7801\uff1a%1$s\uff0c\u9519\u8bef\u63cf\u8ff0\uff1a%2$s\u3002", (String)"", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), resultcode, resultmsg));
        }
        JSONObject body = response.getJSONObject("body");
        JSONArray issueBillOfdZ1Arr = body.getJSONArray("CprDirectIssueBillOfdZ1");
        if (!issueBillOfdZ1Arr.isEmpty()) {
            JSONObject issueBillOfdZ1 = issueBillOfdZ1Arr.getJSONObject(0);
            String issueKey = issueBillOfdZ1.getString("issueKey");
            return BankReconciliationResponseEB.success((Object)issueKey);
        }
        return BankReconciliationResponseEB.success();
    }

    public BankReconciliationResponseEB doBiz(BankReconciliationRequest request) {
        try {
            String rqstStr = this.pack(request);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(request, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }
}

