/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.jsb.cmp.service.receipt.api;

import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.jsb.cmp.util.Packer;
import kd.ebg.receipt.banks.jsb.cmp.util.Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import org.jdom2.Element;

public class ReceiptInfoQueryImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptInfoQueryImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        Element root = Packer.buildHead(this.getBizCode(), Sequence.genSequence());
        Element body = JDomUtils.getUnNullChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)bankReceiptRequest.getAccNo());
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(bankReceiptRequest.getAccNo(), EBContext.getContext().getCustomID());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        JDomUtils.addChild((Element)body, (String)"currency", (String)bankCurrency);
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)bankReceiptRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)bankReceiptRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"size", (String)"10");
        JDomUtils.addChild((Element)body, (String)"start", (String)this.getCurrentPage());
        String xml = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return ReceiptInfoQueryImpl.buildCommonMsg(xml);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        Element body;
        List dtoList;
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            this.setLastPage(true);
        }
        if ((dtoList = (body = root.getChild("body")).getChild("dtos").getChildren("dto")).size() == 0) {
            this.setCurrentPage("1");
            this.setLastPage(true);
            return BankReceiptResponseEB.success(new ArrayList(1));
        }
        this.setCurrentPage(String.valueOf(Integer.parseInt(this.getCurrentPage()) + Integer.parseInt("10")));
        int total = Integer.parseInt(body.getChildTextTrim("total"));
        this.setLastPage(total < Integer.parseInt(this.getCurrentPage()));
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(dtoList.size());
        for (int i = 0; i < dtoList.size(); ++i) {
            Element dto = (Element)dtoList.get(i);
            DetailInfo detail = new DetailInfo();
            detail.setOppAccNo(dto.getChildTextTrim("oppAcctNo"));
            detail.setReversed1(dto.getChildTextTrim("amt"));
            String cdFlag = dto.getChildTextTrim("loanSign");
            String extend1 = dto.getChildTextTrim("extend1");
            cdFlag = Objects.equals(cdFlag, PropertiesConstantsUtils.getValue((String)"CD_CREDIT")) ? "D" : "C";
            detail.setReversed2(cdFlag);
            detail.setReversed3(extend1);
            totalList.add(detail);
        }
        return BankReceiptResponseEB.success(totalList);
    }

    public static String buildCommonMsg(String xmlStr) {
        int length = ReceiptInfoQueryImpl.getLength(xmlStr);
        StringBuilder buffer = new StringBuilder();
        buffer.append(ReceiptInfoQueryImpl.formatLen(Integer.toString(length + 2), 10));
        buffer.append("00");
        buffer.append(xmlStr);
        return buffer.toString();
    }

    public static String formatLen(String orgStr, int exptecedLength) {
        try {
            String encoding = RequestContextUtils.getCharset();
            return StringFormater.formatLen((String)orgStr, (int)exptecedLength, (boolean)true, (char)'0', (String)encoding);
        }
        catch (Exception e) {
            logger.info("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u51fa\u9519\uff0c", (Object)e);
            return "";
        }
    }

    public static int getLength(String msg) {
        String encoding = RequestContextUtils.getCharset();
        try {
            int length = msg.getBytes(encoding).length;
            return length;
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u62a5\u6587\u5934+\u62a5\u6587\u4f53\u957f\u5ea6\u662f\u51fa\u9519\uff0c", (Object)e);
            return 0;
        }
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "0000301T038A9025";
    }

    public String getBizDesc() {
        return "";
    }

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }

    public static List<DetailInfo> queryReceiptList(String accNo, LocalDate transDate) {
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(16);
        ReceiptInfoQueryImpl receiptInfoQuery = new ReceiptInfoQueryImpl();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        receiptInfoQuery.setCurrentPage("1");
        boolean lastPage = false;
        receiptInfoQuery.setLastPage(false);
        while (!lastPage) {
            BankReceiptResponseEB response = receiptInfoQuery.doBiz(bankReceiptRequest);
            if (Objects.nonNull(response) && Objects.nonNull(response.getData())) {
                result.addAll((List)response.getData());
            }
            lastPage = receiptInfoQuery.isLastPage();
        }
        return result;
    }
}

