/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.boc.net.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.boc.net.service.receipt.util.SFTPUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptDownLoadException;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    private DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        ChannelSftp sftp = null;
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLoginId = request.getBankLoginId();
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        long taskId = request.getTaskId();
        logger.info("\u4e2d\u56fd\u94f6\u884c\u56de\u5355\u4e0b\u8f7d-taskId\uff1a{},accNo:{}-\u65e5\u671f\uff1a{}", new Object[]{taskId, accNo, transDate});
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        this.downloadAllDetail(request, bankFtpProperties, sftp);
        logger.info("\u4e2d\u56fd\u94f6\u884c\u56de\u5355\u4e0b\u8f7d-\u6279\u91cf\u4e0b\u8f7d\u5b8c\u6210-taskId\uff1a{},accNo:{}-\u65e5\u671f\uff1a{}", new Object[]{taskId, accNo, transDate});
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        logger.info("\u4e2d\u56fd\u94f6\u884c\u56de\u5355\u4e0b\u8f7d-\u4e0b\u8f7d\u7684\u56de\u5355\u6570\u91cf\uff1a" + downloadListDetails.size());
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            DownloadListDetail detail = (DownloadListDetail)downloadListDetails.get(i);
            this.checkLoaclFile(detail);
            String fileName = detail.getFileName();
            if (!fileName.contains(".rar") && !fileName.contains(".zip")) continue;
            String filePath = bakFilePath + File.separator + fileName;
            String outFilePath = filePath.replace(".zip", "").replace(".rar", "");
            File file = FileCommonUtils.getFileByPath((String)filePath);
            if (!file.exists()) {
                logger.info("\u4e2d\u884c-{}-{}-{}-\u672c\u5730\u4e0d\u5b58\u5728\u8be5\u538b\u7f29\u5305", new Object[]{accNo, transDate, fileName});
                continue;
            }
            boolean flag = GZFileUtils.unZipFiles((String)filePath, (String)outFilePath);
            if (flag) {
                File unZipDir = FileCommonUtils.getFileByPath((String)outFilePath);
                if (!unZipDir.isDirectory()) continue;
                File[] files = unZipDir.listFiles();
                int deleteCount = 0;
                for (File receiptFile : files) {
                    DownloadListDetail downloadListDetail = new DownloadListDetail();
                    downloadListDetail.setFileName(receiptFile.getName());
                    downloadListDetail.setFileLink(receiptFile.getName());
                    result.add(downloadListDetail);
                    boolean isMove = FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)receiptFile.getName());
                    if (!isMove) continue;
                    boolean isDelete = receiptFile.delete();
                    logger.info("\u6587\u4ef6\u662f\u5426\u88ab\u5220\u9664-{}\uff1a{}", new Object[]{receiptFile.getName(), isDelete});
                    ++deleteCount;
                }
                if (deleteCount != files.length) continue;
                boolean isDelete = unZipDir.delete();
                logger.info("\u6587\u4ef6\u662f\u5426\u88ab\u5220\u9664-{}\uff1a{}", new Object[]{unZipDir.getName(), isDelete});
                FileCommonUtils.deleteFile((String)filePath);
                continue;
            }
            boolean isDelete = file.delete();
            logger.info("\u4e2d\u56fd\u94f6\u884c\u56de\u5355\u6587\u4ef6\u89e3\u538b\u7f29\u5931\u8d25-\u6587\u4ef6\u540d\uff1a{}-{}", new Object[]{fileName, isDelete});
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u4e3a\u7a7a\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean isExistsLoaclFile(DownloadListDetail detail) {
        boolean flag = false;
        if (detail.getStatus().equals(TaskStatus.FAILED.getId())) {
            return false;
        }
        String filePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)detail.getBankVersionId(), (String)detail.getAccNo(), (String)LocalDateUtil.formatDate((LocalDate)detail.getTransDate())) + File.separator + detail.getFileName();
        File file = FileCommonUtils.getFileByPath((String)filePath);
        flag = file.exists();
        logger.info("\u56de\u5355\u6587\u4ef6\uff1a{} \u662f\u5426\u5b58\u5728\uff1a{}", new Object[]{filePath, flag});
        return flag;
    }

    public boolean downFileByFileName(DownloadListDetail detail, boolean isLastFile, BankFtpProperties bankFtpProperties, ChannelSftp sftp) {
        String fileName = detail.getFileName();
        String bankVersionId = detail.getBankVersionId();
        String bankLoginId = detail.getBankLoginId();
        String accNo = detail.getAccNo();
        LocalDate transDate = detail.getTransDate();
        String filePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate)) + File.separator + fileName;
        boolean flag = false;
        String ftpPath = "";
        try {
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                if (SFTPUtils.getInstance().isAbort(sftp)) {
                    sftp = SFTPUtils.getInstance().getSftp(bankLoginId);
                    ftpPath = bankFtpProperties.getFtpPath();
                    ftpPath = EBGStringUtils.isEmpty((String)ftpPath) ? "/" : ftpPath;
                }
                flag = SFTPUtils.getInstance().downloadSingleFile(ftpPath, detail.getFileName(), filePath, sftp);
            }
            if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                flag = bankReceiptApiUtil.downloadReceiptFile(detail.getFileName());
            }
            if (flag) {
                logger.info("\u5f53\u524d\u56de\u5355\u6587\u4ef6[" + fileName + "]\u4e0b\u8f7d\u6210\u529f");
            } else {
                logger.info("\u5f53\u524d\u56de\u5355\u6587\u4ef6[" + fileName + "]\u4e0b\u8f7d\u5931\u8d25");
            }
        }
        catch (Throwable e) {
            if (e.getCause() != null && sftp != null) {
                boolean bl = false;
                return bl;
            }
            SFTPUtils.getInstance().close(sftp);
            throw new ReceiptException(e);
        }
        finally {
            if (isLastFile) {
                logger.info("\u5173\u95edsftp\u8fde\u63a5");
                SFTPUtils.getInstance().close(sftp);
            }
        }
        return false;
    }

    public void checkLoaclFile(DownloadListDetail detail) {
        String bankVersionId = detail.getBankVersionId();
        String accNo = detail.getAccNo();
        LocalDate transDate = detail.getTransDate();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        long oldSize = 0L;
        String fileName = detail.getFileName();
        String filePath = bakFilePath + File.separator + fileName;
        File file = FileCommonUtils.getFileByPath((String)filePath);
        if (file.exists()) {
            oldSize = file.length();
            logger.info("\u6587\u4ef6\uff1a" + detail.getFileName() + "\u6587\u4ef6\u5927\u5c0f\u4e3a" + oldSize / 1000L + "KB");
            if (oldSize == 0L) {
                detail.setStatus(Integer.valueOf(TaskStatus.FAILED.getId()));
                detail.setExpmsg(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\uff1a%s\u6587\u4ef6\u5927\u5c0f\u4e3a0\u3002", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]), detail.getFileName()));
                throw new ReceiptDownLoadException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u63a8\u9001\u7684\u538b\u7f29\u5305[%s]\u4e2d\u4e0d\u5b58\u5728\u7535\u5b50\u56de\u5355\u6587\u4ef6\u3002", (String)"BankReceiptDownloadImpl_2", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]), detail.getFileName()));
            }
            if (oldSize > 19000L && oldSize < 21000L) {
                logger.info("\u6587\u4ef6[" + detail.getFileName() + "]\u7684\u5927\u5c0f\u4e3a" + oldSize / 1000L + "KB\uff0c\u8be5\u538b\u7f29\u5305\u5185\u6ca1\u6709\u56de\u5355\u6587\u4ef6");
                detail.setStatus(Integer.valueOf(TaskStatus.FAILED.getId()));
                detail.setExpmsg(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u63a8\u9001\u7684\u538b\u7f29\u5305[%s]\u4e2d\u4e0d\u5b58\u5728\u7535\u5b50\u56de\u5355\u6587\u4ef6\u3002", (String)"BankReceiptDownloadImpl_2", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]), detail.getFileName()));
                throw new ReceiptDownLoadException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u63a8\u9001\u7684\u538b\u7f29\u5305[%s]\u4e2d\u4e0d\u5b58\u5728\u7535\u5b50\u56de\u5355\u6587\u4ef6\u3002", (String)"BankReceiptDownloadImpl_2", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]), detail.getFileName()));
            }
        }
    }

    public void downloadAllDetail(BankReceiptHandleRequest request, BankFtpProperties bankFtpProperties, ChannelSftp sftp) {
        String cacheName = "BOC_NET_DOWNLOAD_LOCK";
        DLock lock = DLock.create((String)cacheName, (String)ResManager.loadKDString((String)"\u4e2d\u884csftp\u56de\u5355\u4e0b\u8f7d\u5206\u5e03\u5f0f\u9501\u3002", (String)"BankReceiptDownloadImpl_3", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]));
        try {
            if (lock.tryLock()) {
                ArrayList<Integer> status = new ArrayList<Integer>(16);
                status.add(TaskStatus.DOWNLOADING.getId());
                String customId = EBContext.getContext().getCustomID();
                List taskList = this.downloadTaskService.findByCoustomIdAndStatusListAndBankVersion(customId, status, request.getBankVersionId());
                logger.info("\u4e2d\u56fd\u94f6\u884c\u56de\u5355\u4e0b\u8f7d-\u9700\u8981\u4e0b\u8f7d\u7684\u56de\u5355\u4efb\u52a1\u6570\u91cf\uff1a" + taskList.size());
                List refids = taskList.stream().map(o -> o.getId()).collect(Collectors.toList());
                logger.info("\u4e2d\u56fd\u94f6\u884c\u56de\u5355\u4e0b\u8f7d-\u9700\u8981\u4e0b\u8f7d\u7684\u56de\u5355\u6587\u4ef6\u6570\u91cf\uff1a" + refids.size());
                List detailList = this.downloadListDetailService.findByRefids(refids);
                for (int i = 0; i < detailList.size(); ++i) {
                    DownloadListDetail detail = (DownloadListDetail)detailList.get(i);
                    logger.info("\u4e2d\u56fd\u94f6\u884c\u56de\u5355\u4e0b\u8f7d-\u9700\u8981\u4e0b\u8f7d\u7684\u56de\u5355\u6587\u4ef6\u540d\uff1a" + detail.getFileName());
                    if (!detail.getFileName().contains(".zip") && !detail.getFileName().contains(".rar") || this.isExistsLoaclFile(detail)) continue;
                    boolean isLast = i == detailList.size() - 1;
                    this.downFileByFileName(detail, isLast, bankFtpProperties, sftp);
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u83b7\u53d6\u4e2d\u884csftp\u56de\u5355\u4e0b\u8f7d\u5206\u5e03\u5f0f\u9501\u51fa\u73b0\u5f02\u5e38,%s", e.getMessage()));
            throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
        finally {
            logger.info("\u4e2d\u884csftp\u56de\u5355\u4e0b\u8f7d\u5206\u5e03\u5f0f\u9501\u91ca\u653e");
            lock.unlock();
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "BOC_NET_DC_DOWNLOAD";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e2d\u56fd\u94f6\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_4", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]);
    }
}

