/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.boc.net.service.reconciliation.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.boc.net.service.receipt.BOCNETCommConfig;
import kd.ebg.receipt.banks.boc.net.service.receipt.message.Parser;
import kd.ebg.receipt.business.receipt.bank.task.balanceReconciliation.BalanceReconciliationRequestEB;
import kd.ebg.receipt.business.receipt.bank.task.balanceReconciliation.BalanceReconciliationResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import org.jdom2.Element;

public class ReconciliationParse {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReconciliationParse.class);

    public List<String> parseB2e0358(String responseStr, BOCNETCommConfig bocnetCommConfig) {
        Element root = Objects.requireNonNull(JDomUtils.str2Doc((String)responseStr, (String)IOUtils.getCharsetName())).getRootElement();
        try {
            Parser.parserB2eError(root);
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0358-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        if (EBGStringUtils.isNotEmpty((String)rspmsg) && rspmsg.contains(PropertiesConstantsUtils.getValue((String)"CONNECT_ERROR"))) {
            throw new ReceiptException(rspmsg);
        }
        if (!"B001".equals(rspcod)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef:%s\u3002", (String)"ReconciliationParse_1", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]), responseStr));
        }
        String total = trn.getChildTextTrim("totalnum");
        String backnum = trn.getChildTextTrim("backnum");
        String currentPage = RequestContextUtils.getRunningParam((String)"pageKey");
        int startIndex = Integer.parseInt(currentPage) * 35;
        if (Integer.parseInt(total) <= startIndex) {
            RequestContextUtils.setRunningParam((String)"lastPageKey", (String)String.valueOf(true));
        }
        List elementList = trn.getChildren("b2e0358-rs");
        ArrayList<String> result = new ArrayList<String>(16);
        if (elementList != null) {
            for (Element element : elementList) {
                JSONObject jsonObject = new JSONObject();
                String cif = element.getChildTextTrim("cif");
                String reconciliationNo = element.getChildTextTrim("stmtnum");
                String protocolNo = element.getChildTextTrim("conagrno");
                String checkMonth = element.getChildTextTrim("checkmonth");
                String overdueFlag = element.getChildTextTrim("overdueflag");
                jsonObject.put("cif", (Object)cif);
                jsonObject.put("reconciliationNo", (Object)reconciliationNo);
                jsonObject.put("protocolNo", (Object)protocolNo);
                jsonObject.put("overdueFlag", (Object)overdueFlag);
                jsonObject.put("yearMonth", (Object)checkMonth);
                if (Objects.equals(bocnetCommConfig.getIsDownloadOverdueReconciliation(), "false")) {
                    if (!Objects.equals(overdueFlag, "1")) continue;
                    result.add(jsonObject.toJSONString());
                    continue;
                }
                result.add(jsonObject.toJSONString());
            }
        }
        return result;
    }

    public String parseB2e0359(String responseStr) {
        Element root = Objects.requireNonNull(JDomUtils.str2Doc((String)responseStr, (String)IOUtils.getCharsetName())).getRootElement();
        try {
            Parser.parserB2eError(root);
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0359-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        if (EBGStringUtils.isNotEmpty((String)rspmsg) && rspmsg.contains(PropertiesConstantsUtils.getValue((String)"CONNECT_ERROR"))) {
            throw new ReceiptException(rspmsg);
        }
        if (!"B001".equals(rspcod)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef:%s\u3002", (String)"ReconciliationParse_1", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]), responseStr));
        }
        Element rs = JDomUtils.getUnNullChildElement((Element)trn, (String)"b2e0359-rs");
        String fileName = JDomUtils.getUnNullChildText((Element)rs, (String)"filename");
        if (StringUtils.isEmpty((String)fileName)) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672a\u8fd4\u56de\u5bf9\u8d26\u5355\u6587\u4ef6\u540d\u3002", (String)"ReconciliationParse_2", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]));
        }
        return fileName;
    }

    public BalanceReconciliationResponseEB parseB2e0360(BalanceReconciliationRequestEB request, String responseStr) {
        Element root = Objects.requireNonNull(JDomUtils.str2Doc((String)responseStr, (String)IOUtils.getCharsetName())).getRootElement();
        try {
            Parser.parserB2eError(root);
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0360-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        String reconciliationNo = request.getReconciliationNo();
        String reconciliationYearMonth = request.getReconciliationYearMonth();
        if (EBGStringUtils.isNotEmpty((String)rspmsg) && rspmsg.contains(PropertiesConstantsUtils.getValue((String)"CONNECT_ERROR")) || !"B001".equals(rspcod)) {
            return BalanceReconciliationResponseEB.fail((String)reconciliationNo, (String)reconciliationYearMonth, (String)rspcod, (String)rspmsg);
        }
        Element rs = JDomUtils.getUnNullChildElement((Element)trn, (String)"b2e0360-rs");
        Element rs_status = rs.getChild("status");
        String rs_rspcod = rs_status.getChildTextTrim("rspcod");
        String rs_rspmsg = rs_status.getChildTextTrim("rspmsg");
        if (EBGStringUtils.isNotEmpty((String)rs_rspmsg) && rs_rspmsg.contains(PropertiesConstantsUtils.getValue((String)"CONNECT_ERROR")) || !"B001".equals(rs_rspcod)) {
            return BalanceReconciliationResponseEB.fail((String)reconciliationNo, (String)reconciliationYearMonth, (String)rs_rspcod, (String)rs_rspmsg);
        }
        return BalanceReconciliationResponseEB.success((String)reconciliationNo, (String)reconciliationYearMonth, (String)rs_rspcod, (String)rs_rspmsg);
    }
}

