/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.services.receipt;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.login.BankLoginKey;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.common.constant.DetailDownloadStatusEnum;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.constant.UploadTaskStatusEnum;
import kd.ebg.receipt.common.constant.defect.ReceiptDefectTypeEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoService;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.model.receipt.EBCReceiptInfo;
import kd.ebg.receipt.common.model.repository.receipt.ReceiptDownloadTaskRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

@Service
public class DownloadTaskService {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DownloadTaskService.class);
    private final ReceiptDownloadTaskRepository receiptDownloadTaskRepository;

    public DownloadTaskService(ReceiptDownloadTaskRepository receiptDownloadTaskRepository) {
        this.receiptDownloadTaskRepository = receiptDownloadTaskRepository;
    }

    public List<DownloadListTask> findByAccNoAndBankVersionIDAndTransDateBetween(String accNo, String bankVersionID, LocalDate startDate, LocalDate endDate) {
        ArrayList<DownloadListTask> detailInfos = new ArrayList<DownloadListTask>(16);
        DynamicObject[] dynamicObjects = this.receiptDownloadTaskRepository.findByAccNoAndBankVersionIDAndTransDateBetween(accNo, bankVersionID, startDate, endDate);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public List<DownloadListTask> findBybankVersionAndCustomNoAndQueryDateBetweenOrderByFileNumDesc(String bankVersionID, String customId, LocalDate startDate, LocalDate endDate) {
        ArrayList<DownloadListTask> detailInfos = new ArrayList<DownloadListTask>(16);
        DynamicObject[] dynamicObjects = this.receiptDownloadTaskRepository.findBybankVersionAndCustomNoAndQueryDateBetweenOrderByFileNumDesc(bankVersionID, customId, startDate, endDate);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public DownloadListTask findById(long id) {
        DynamicObject dynamicObject = this.receiptDownloadTaskRepository.findById(id);
        DownloadListTask task = this.toReceiptDownloadTaskInfo(dynamicObject);
        return task;
    }

    public List<DownloadListTask> findByBankVersionIDAndTransDateAndCustomId(String bankVersionID, LocalDate startDate, String customId) {
        ArrayList<DownloadListTask> detailInfos = new ArrayList<DownloadListTask>(16);
        DynamicObject[] dynamicObjects = this.receiptDownloadTaskRepository.findByBankVersionIDAndTransDateAndCustomId(bankVersionID, startDate, customId);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public List<DownloadListTask> findByAccNoAndCoustomIdAndStatusList(String accNo, String customId, List<Integer> statusArray) {
        ArrayList<DownloadListTask> detailInfos = new ArrayList<DownloadListTask>(16);
        DynamicObject[] dynamicObjects = this.receiptDownloadTaskRepository.findByAccNoAndCoustomIdAndStatusList(accNo, customId, statusArray);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public List<DownloadListTask> findByCoustomIdAndStatusListAndBankVersionAndTransDate(String customId, List<Integer> statusArray, String bankVersionId, LocalDate transDate) {
        ArrayList<DownloadListTask> detailInfos = new ArrayList<DownloadListTask>(16);
        DynamicObject[] dynamicObjects = this.receiptDownloadTaskRepository.findTodayByCoustomIdAndStatusListAndBankVersionAndTransDate(customId, statusArray, bankVersionId, transDate);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public List<DownloadListTask> findByCustomIdAndStatusListAndBankVersion(String customId, List<Integer> statusArray, String bankVersionId) {
        ArrayList<DownloadListTask> detailInfos = new ArrayList<DownloadListTask>(16);
        DynamicObject[] dynamicObjects = this.receiptDownloadTaskRepository.findByCustomIdAndStatusListAndBankVersion(customId, statusArray, bankVersionId);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public List<DownloadListTask> findByCoustomIdAndStatusListAndBankVersion(String customId, List<Integer> statusArray, String bankVersionId) {
        ArrayList<DownloadListTask> detailInfos = new ArrayList<DownloadListTask>();
        DynamicObject[] dynamicObjects = this.receiptDownloadTaskRepository.findByCoustomIdAndStatusListAndBankVersion(customId, statusArray, bankVersionId);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public List<DownloadListTask> findTodayByCoustomIdAndStatusListAndBankVersionAndTransDateAndBankLogin(String customId, List<Integer> statusArray, String bankVersionId, LocalDate transDate, String bankLogin) {
        ArrayList<DownloadListTask> detailInfos = new ArrayList<DownloadListTask>(16);
        DynamicObject[] dynamicObjects = this.receiptDownloadTaskRepository.findTodayByCoustomIdAndStatusListAndBankVersionAndTransDateAndBankLogin(customId, statusArray, bankVersionId, transDate, bankLogin);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public List<DownloadListTask> findByStatus(Integer status) {
        ArrayList<DownloadListTask> detailInfos = new ArrayList<DownloadListTask>(16);
        DynamicObject[] dynamicObjects = this.receiptDownloadTaskRepository.findByStatus(status);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public List<DownloadListTask> findUnUploadCompleteTaskByBankAndCustomId(String customId, String bankVersion, LocalDate startDate, LocalDate endDate) {
        ArrayList<DownloadListTask> detailInfos = new ArrayList<DownloadListTask>(16);
        DynamicObject[] dynamicObjects = this.receiptDownloadTaskRepository.findUnUploadCompleteTaskByBankAndCustomId(customId, bankVersion, startDate, endDate);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public String getUniqueBatchNoByBankAndDateAndCustomId(String bankVersion, LocalDate transDate, String customId) {
        EBCReceiptInfoService ebcReceiptInfoService = SpringContextUtil.getBean(EBCReceiptInfoService.class);
        EBCReceiptInfo ebcReceiptInfo = ebcReceiptInfoService.findByCustomIdAndTransDateAndBankVersionId(customId, transDate, bankVersion);
        if (ebcReceiptInfo == null) {
            String requestSeqID = Sequence.genSequence();
            return requestSeqID;
        }
        return ebcReceiptInfo.getBatchNo();
    }

    public void save(DownloadListTask receiptDownloadTaskEntity) {
        DynamicObject dynamicObject = this.packDetailInfo(null, receiptDownloadTaskEntity);
        this.receiptDownloadTaskRepository.save(dynamicObject);
    }

    public void update(DownloadListTask receiptDownloadTaskEntity) {
        DynamicObject dynamicObject = this.receiptDownloadTaskRepository.findById(receiptDownloadTaskEntity.getId());
        dynamicObject = this.packDetailInfo(dynamicObject, receiptDownloadTaskEntity);
        this.receiptDownloadTaskRepository.update(dynamicObject);
    }

    private DownloadListTask toReceiptDownloadTaskInfo(DynamicObject dynamicObject) {
        String suggestion;
        String defect_type;
        String todaysFlag;
        if (dynamicObject == null) {
            return null;
        }
        DownloadListTask receiptDownloadTask = new DownloadListTask();
        receiptDownloadTask.setId(dynamicObject.getLong("id"));
        receiptDownloadTask.setAccNo(dynamicObject.getString("acc_no.number"));
        receiptDownloadTask.setBankLoginId(dynamicObject.getString("bank_login.number"));
        receiptDownloadTask.setBankVersionId(dynamicObject.getString("bank_version.number"));
        receiptDownloadTask.setBatchNo(dynamicObject.getString("batch_no"));
        receiptDownloadTask.setTransDate(LocalDateUtil.date2LocalDate((Date)dynamicObject.getDate("trans_date")));
        receiptDownloadTask.setStatus(Integer.parseInt(dynamicObject.getString("status")));
        receiptDownloadTask.setModifytime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("modifytime")));
        receiptDownloadTask.setCreatetime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("createtime")));
        receiptDownloadTask.setDetailFlag(dynamicObject.getInt("detail_flag"));
        Date completeTime = dynamicObject.getDate("complete_time");
        if (completeTime != null) {
            receiptDownloadTask.setCompleteTime(LocalDateUtil.date2LocalDateTime((Date)completeTime));
        }
        receiptDownloadTask.setExpmsg(dynamicObject.getString("exp_msg"));
        int redo = dynamicObject.getInt("redo");
        receiptDownloadTask.setRedo(redo);
        int receiptNum = dynamicObject.getInt("receipt_num");
        receiptDownloadTask.setReceiptNum(receiptNum);
        int matchNum = dynamicObject.getInt("match_num");
        receiptDownloadTask.setMatchNum(matchNum);
        int detailNum = dynamicObject.getInt("detail_num");
        receiptDownloadTask.setTxDetailNum(detailNum);
        int uploadNum = dynamicObject.getInt("upload_num");
        receiptDownloadTask.setUploadNum(uploadNum);
        String uploadFlag = dynamicObject.getString("upload_flag");
        if (!EBGStringUtils.isEmpty(uploadFlag)) {
            receiptDownloadTask.setUploadFlag(Integer.parseInt(uploadFlag));
        }
        if (!EBGStringUtils.isEmpty(todaysFlag = dynamicObject.getString("todays_flag"))) {
            receiptDownloadTask.setTodaysFlag(Integer.parseInt(todaysFlag));
        }
        if (!EBGStringUtils.isEmpty(defect_type = dynamicObject.getString("defect_type"))) {
            receiptDownloadTask.setDefectType(defect_type);
        }
        if (!EBGStringUtils.isEmpty(suggestion = dynamicObject.getString("suggestion"))) {
            receiptDownloadTask.setSuggest(suggestion);
        }
        receiptDownloadTask.setCustomNo(dynamicObject.getString("custom_id"));
        String zipNames = dynamicObject.getString("zip_names_tag");
        receiptDownloadTask.setZipNames(zipNames);
        int file_num = dynamicObject.getInt("file_num");
        receiptDownloadTask.setFileNum(file_num);
        int sort = dynamicObject.getInt("sort");
        receiptDownloadTask.setSort(sort);
        return receiptDownloadTask;
    }

    private DynamicObject packDetailInfo(DynamicObject dynamicObject, DownloadListTask info) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"receipt_download_task");
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("sort", (Object)0);
        } else {
            dynamicObject.set("id", (Object)info.getId());
        }
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("complete_time", (Object)LocalDateUtil.localDateTime2Date((LocalDateTime)info.getCompleteTime()));
        dynamicObject.set("exp_msg", (Object)info.getExpmsg());
        dynamicObject.set("detail_num", (Object)Long.parseLong(info.getTxDetailNum().toString()));
        dynamicObject.set("match_num", (Object)Long.parseLong(info.getMatchNum().toString()));
        dynamicObject.set("upload_num", (Object)Long.parseLong(info.getUploadNum().toString()));
        dynamicObject.set("upload_flag", (Object)info.getUploadFlag());
        dynamicObject.set("detail_flag", (Object)info.getDetailFlag());
        BankLoginRepository bankLoginRepository = BankLoginRepository.getInstance();
        BankLoginKey bankLoginKey = new BankLoginKey();
        bankLoginKey.setBankLoginId(info.getBankLoginId());
        bankLoginKey.setCustomId(info.getCustomNo());
        DynamicObject bankLogin = bankLoginRepository.findDynamicByIdAndCustomId(bankLoginKey);
        dynamicObject.set("bank_login", (Object)bankLogin);
        BankVersionRepository bankVersionRepository = BankVersionRepository.getInstance();
        DynamicObject bankVersion = bankVersionRepository.loadDynamicObjectByBankVersionID(info.getBankVersionId());
        dynamicObject.set("bank_version", (Object)bankVersion);
        BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();
        DynamicObject bankAcct = bankAcntRepository.findDataByAccNoAndCustomId(info.getAccNo(), info.getCustomNo());
        dynamicObject.set("acc_no", (Object)bankAcct);
        dynamicObject.set("batch_no", (Object)info.getBatchNo());
        Date transDate = LocalDateUtil.localDate2Date((LocalDate)info.getTransDate());
        dynamicObject.set("trans_date", (Object)transDate);
        dynamicObject.set("status", (Object)info.getStatus());
        dynamicObject.set("redo", (Object)info.getRedo().toString());
        dynamicObject.set("receipt_num", (Object)Long.parseLong(info.getReceiptNum().toString()));
        dynamicObject.set("custom_id", (Object)info.getCustomNo());
        dynamicObject.set("todays_flag", (Object)Integer.toString(info.getTodaysFlag()));
        String defectType = info.getDefectType();
        if (!EBGStringUtils.isEmpty(defectType)) {
            if (Objects.equals(defectType, ReceiptDefectTypeEnum.NULL.getCode())) {
                defectType = "";
                if (Objects.equals(info.getStatus(), TaskStatusEnum.FAILED.getId())) {
                    defectType = ReceiptDefectTypeEnum.OTHER.getCode();
                }
            }
            if (Objects.equals(defectType, ReceiptDefectTypeEnum.FINISH.getCode())) {
                defectType = "";
            }
            dynamicObject.set("defect_type", (Object)defectType);
            dynamicObject.set("suggestion", (Object)defectType);
        } else {
            dynamicObject.set("defect_type", (Object)"");
            dynamicObject.set("suggestion", (Object)"");
        }
        if (EBGStringUtils.isNotEmpty(info.getZipNames())) {
            dynamicObject.set("zip_names_tag", (Object)info.getZipNames());
            dynamicObject.set("file_num", (Object)info.getFileNum());
        }
        if (info.getStatus().intValue() == TaskStatusEnum.DOWNLOADED.getId() || info.getStatus().intValue() == TaskStatusEnum.FINISH.getId() || info.getStatus().intValue() == TaskStatusEnum.FAILED.getId()) {
            dynamicObject.set("sort", (Object)"0");
        } else {
            dynamicObject.set("sort", (Object)info.getSort());
        }
        return dynamicObject;
    }

    public void buildReceiptTaskDynamicObjects(List<DownloadListTask> downloadListTasks, String accNo, List<DynamicObject> newTaskList, String bankVersion, LocalDate startDate, LocalDate endDate, DynamicObject accnoDynamicObject, String customID) {
        this.buildReceiptTaskDynamicObjects(downloadListTasks, accNo, newTaskList, bankVersion, startDate, endDate, accnoDynamicObject, customID, null);
    }

    public void buildReceiptTaskDynamicObjects(List<DownloadListTask> downloadListTasks, String accNo, List<DynamicObject> newTaskList, String bankVersion, LocalDate startDate, LocalDate endDate, DynamicObject accnoDynamicObject, String customID, Map<LocalDate, String> needUpdReceiptInfoMap) {
        List existTask = downloadListTasks.stream().filter(o -> o.getAccNo().equals(accNo)).collect(Collectors.toList());
        ArrayList existTransDates = new ArrayList(16);
        existTask.stream().forEach(t -> {
            Date date = LocalDateUtil.localDate2Date((LocalDate)t.getTransDate());
            if (!existTransDates.contains(date)) {
                existTransDates.add(date);
            }
        });
        long days = endDate.toEpochDay() - startDate.toEpochDay();
        int i = 0;
        while ((long)i <= days) {
            LocalDate date = LocalDateUtil.getDayAfter((LocalDate)startDate, (int)i);
            Date transDate = LocalDateUtil.localDate2Date((LocalDate)date);
            if (!existTransDates.contains(transDate)) {
                long startTime = System.currentTimeMillis();
                if (needUpdReceiptInfoMap == null) {
                    needUpdReceiptInfoMap = Maps.newHashMapWithExpectedSize((int)1);
                }
                String batchNo = needUpdReceiptInfoMap != null && needUpdReceiptInfoMap.containsKey(date) ? (String)needUpdReceiptInfoMap.get(date) : this.getUniqueBatchNoByBankAndDateAndCustomId(bankVersion, date, customID);
                DynamicObject newTask = this.buildReceiptTaskDynamicObject((DynamicObject)accnoDynamicObject.get("group"), (DynamicObject)accnoDynamicObject.get("bank_login"), accnoDynamicObject, batchNo, transDate, LocalDate.now().isEqual(date) ? 1 : 0);
                if (needUpdReceiptInfoMap != null) {
                    needUpdReceiptInfoMap.put(date, batchNo);
                }
                newTaskList.add(newTask);
                long endTime = System.currentTimeMillis();
                this.logger.monitorInfo("buildReceiptTaskDynamicObjects-do\uff1a{} ms", new Object[]{endTime - startTime});
            }
            ++i;
        }
    }

    DynamicObject buildReceiptTaskDynamicObject(DynamicObject bankVersion, DynamicObject bankLogin, DynamicObject accNo, String batchNo, Date transDate, int todaysFlag) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)"receipt_download_task");
        dataEntity.set("bank_version", (Object)bankVersion);
        dataEntity.set("bank_login", (Object)bankLogin);
        dataEntity.set("acc_no", (Object)accNo);
        dataEntity.set("batch_no", (Object)batchNo);
        dataEntity.set("trans_date", (Object)transDate);
        Date date = new Date();
        dataEntity.set("createtime", (Object)date);
        dataEntity.set("modifytime", (Object)date);
        dataEntity.set("todays_flag", (Object)todaysFlag);
        dataEntity.set("status", (Object)TaskStatusEnum.CREATE.getId());
        dataEntity.set("upload_flag", (Object)UploadTaskStatusEnum.UN_UPLOAD.getId());
        dataEntity.set("detail_flag", (Object)DetailDownloadStatusEnum.UN_DOWNLOAD.getId());
        dataEntity.set("custom_id", (Object)RequestContext.get().getTenantId());
        return dataEntity;
    }

    public int countTaskNumByBankVersionIDAndTransDateAndCustomId(String bankVersionId, LocalDate transDate, String customId) {
        return this.receiptDownloadTaskRepository.countTaskNumByBankVersionIDAndTransDateAndCustomId(bankVersionId, transDate, customId);
    }

    public int countFinishTaskNumByBankVersionIDAndTransDateAndCustomId(String bankVersionId, LocalDate transDate, String customId) {
        return this.receiptDownloadTaskRepository.countFinishTaskNumByBankVersionIDAndTransDateAndCustomId(bankVersionId, transDate, customId);
    }

    public void batchUpdate(List<DownloadListTask> downloadListTasks) {
        List<Long> ids = downloadListTasks.stream().map(o -> o.getId()).collect(Collectors.toList());
        Map<Long, DownloadListTask> listMap = downloadListTasks.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        DynamicObject[] dynamicObjects = this.receiptDownloadTaskRepository.batchFindById(ids);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            Long id = dynamicObject.getLong("id");
            if (!listMap.containsKey(id)) continue;
            DownloadListTask downloadListTask = listMap.get(id);
            dynamicObjects[i] = dynamicObject = this.packDetailInfo(dynamicObject, downloadListTask);
        }
        this.receiptDownloadTaskRepository.batchUpdate(dynamicObjects);
    }

    public List<DownloadListTask> findByCustomIdAndBankLoginAndTransDateAndStatus(String customId, String bankLoginId, LocalDate startDate, LocalDate endDate, int status) {
        ArrayList<DownloadListTask> detailInfos = new ArrayList<DownloadListTask>(16);
        DynamicObject[] dynamicObjects = this.receiptDownloadTaskRepository.findByCustomIdAndBankLoginAndTransDateAndStatus(customId, bankLoginId, startDate, endDate, status);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }
}

