/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.model.repository;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.receipt.common.model.DetailSyncRecord;

@Component
public class DetailSyncRecordRepository {
    static final String DETAIL_SYNC_RECORD_ENTITY = "aqap_detail_sync_record";
    static final String SELECT_PROPERTIES = "id,createtime,modifytime,acc_no,custom_id,detail_count,sync_date";

    public List<DetailSyncRecord> findByCustomIDAndAccNoAndSyncDateBetween(String customID, String accNo, LocalDate syncDateStart, LocalDate syncDateEnd) {
        ArrayList<DetailSyncRecord> detailSyncRecordList = new ArrayList<DetailSyncRecord>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and acc_no=? and sync_date>=? and sync_date<=?", (Object[])new Object[]{customID, accNo, syncDateStart, syncDateEnd});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)DETAIL_SYNC_RECORD_ENTITY, (String)SELECT_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailSyncRecordList.add(this.transDetailSyncRecord(dynamicObjects[i]));
            }
        }
        return detailSyncRecordList;
    }

    private DetailSyncRecord transDetailSyncRecord(DynamicObject dynamicObject) {
        DetailSyncRecord detailSyncRecord = new DetailSyncRecord();
        detailSyncRecord.setId(dynamicObject.getString("id"));
        detailSyncRecord.setAccNo(dynamicObject.getString("acc_no"));
        detailSyncRecord.setCustomID(dynamicObject.getString("custom_id"));
        LocalDateTime insertTime = DTFactoryUtil.parseDateTime((String)dynamicObject.getString("createtime"));
        detailSyncRecord.setInsertTime(insertTime);
        LocalDateTime updateTime = DTFactoryUtil.parseDateTime((String)dynamicObject.getString("modifytime"));
        detailSyncRecord.setUpdateTime(updateTime);
        LocalDate syncDate = DTFactoryUtil.parseDate((String)dynamicObject.getString("sync_date"));
        detailSyncRecord.setSyncDate(syncDate);
        detailSyncRecord.setDetailCount(dynamicObject.getInt("detail_count"));
        return detailSyncRecord;
    }
}

