/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.model.repository.receipt;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.receipt.common.model.receipt.GlobalObjectParamConfig;

@Component
public class GlobalConfigRepository {
    private static final String DETAILINFO_ENTITY = "aqap_object_properties";
    private static final String SELECT_ALL_PROPERTIES = "id,attr_key,attr_value,attr_desc,object_id,object_name,custom_id";

    public List<GlobalObjectParamConfig> findGlobalReceiptConfigByCustomID(String customId) {
        DynamicObject[] dynamicObjects;
        ArrayList<GlobalObjectParamConfig> globalObjectParamConfigs = new ArrayList<GlobalObjectParamConfig>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and object_name=?", (Object[])new Object[]{customId, "receipt"});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            GlobalObjectParamConfig ebConfig = this.parse(dynamicObject);
            globalObjectParamConfigs.add(ebConfig);
        }
        return globalObjectParamConfigs;
    }

    public List<GlobalObjectParamConfig> findBusinessConfigByCustomIDAndFromId(String customId, String fromId) {
        DynamicObject[] dynamicObjects;
        ArrayList<GlobalObjectParamConfig> globalObjectParamConfigs = new ArrayList<GlobalObjectParamConfig>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and object_name=? and object_id=?", (Object[])new Object[]{customId, "BANK_BUSINESS", fromId});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            GlobalObjectParamConfig ebConfig = this.parse(dynamicObject);
            globalObjectParamConfigs.add(ebConfig);
        }
        return globalObjectParamConfigs;
    }

    public List<GlobalObjectParamConfig> findBusinessConfigByCustomIDAndId(String customId, String fromId) {
        DynamicObject[] dynamicObjects;
        ArrayList<GlobalObjectParamConfig> globalObjectParamConfigs = new ArrayList<GlobalObjectParamConfig>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and attr_key=?", (Object[])new Object[]{customId, fromId});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            GlobalObjectParamConfig ebConfig = this.parse(dynamicObject);
            globalObjectParamConfigs.add(ebConfig);
        }
        return globalObjectParamConfigs;
    }

    public List<GlobalObjectParamConfig> findGlobalEBGConfigByCustomID(String customId) {
        DynamicObject[] dynamicObjects;
        ArrayList<GlobalObjectParamConfig> globalObjectParamConfigs = new ArrayList<GlobalObjectParamConfig>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and object_name=?", (Object[])new Object[]{customId, "ebg"});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            GlobalObjectParamConfig ebConfig = this.parse(dynamicObject);
            globalObjectParamConfigs.add(ebConfig);
        }
        return globalObjectParamConfigs;
    }

    private GlobalObjectParamConfig parse(DynamicObject dynamicObject) {
        GlobalObjectParamConfig info = new GlobalObjectParamConfig();
        info.setId(dynamicObject.getLong("id"));
        info.setAttrDesc(dynamicObject.getString("attr_desc"));
        info.setAttrKey(dynamicObject.getString("attr_key"));
        info.setAttrValue(dynamicObject.getString("attr_value"));
        info.setCustomId(dynamicObject.getString("custom_id"));
        info.setObjectId(dynamicObject.getString("object_id"));
        info.setObjectName(dynamicObject.getString("object_name"));
        return info;
    }
}

