/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.model.repository.receipt;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.EBCReceiptInfo;
import kd.ebg.receipt.common.model.receipt.ReceiptInfo;

@Component
public class ReceiptInfoRepository {
    private final String DETAILINFO_ENTITY = "receipt_info";
    private final String SELECT_ALL_PROPERTIES = "bank_version.number,id,receipt_acnt_num,trans_date,task_num,file_num,batch_no,custom_id,compeleted_flag,modifytime,createtime";

    public List<ReceiptInfo> findBybankVersionAndCustomNoAndQueryDateBetweenOrderByFileNumDesc(String bankVersion, String customNo, LocalDate startDate, LocalDate endDate) {
        return null;
    }

    public void save(EBCReceiptInfo receiptInfo) {
        DynamicObject dynamicObject = this.packDetailInfo(null, receiptInfo);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void update(EBCReceiptInfo info) {
        DynamicObject dynamicObject = this.findOneById(info.getId());
        dynamicObject = this.packDetailInfo(dynamicObject, info);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void deleteById(Long id) {
        if (id != null) {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)"receipt_info", (QFilter[])filter.toArray());
        }
    }

    public void delete(DownloadListDetail downloadListDetail) {
        long id = downloadListDetail.getId();
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DeleteServiceHelper.delete((String)"receipt_info", (QFilter[])filter.toArray());
    }

    public EBCReceiptInfo findById(long id) {
        DynamicObject dynamicObject = this.findOneById(id);
        if (dynamicObject != null) {
            EBCReceiptInfo receiptInfo = this.toEBCReceiptInfo(dynamicObject);
            return receiptInfo;
        }
        return null;
    }

    public DynamicObject findOneById(long id) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"receipt_info", (String)"bank_version.number,id,receipt_acnt_num,trans_date,task_num,file_num,batch_no,custom_id,compeleted_flag,modifytime,createtime", (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public EBCReceiptInfo findByCustomIdAndTransDateAndBankVersionId(String customId, LocalDate transDate, String bankVersionId) {
        QFilter filter;
        DynamicObject dynamicObject;
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<Object> paramsList = new ArrayList<Object>(16);
        if (!EBGStringUtils.isEmpty(customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (!EBGStringUtils.isEmpty(bankVersionId)) {
            expression.append("and bank_version.number=?").append(' ');
            paramsList.add(bankVersionId);
        }
        if (transDate != null) {
            expression.append("and trans_date>=?").append(' ');
            paramsList.add(transDate);
        }
        if (transDate != null) {
            expression.append("and trans_date<=?").append(' ');
            paramsList.add(transDate);
        }
        if (!EBGStringUtils.isEmpty(expressionStr = expression.toString())) {
            expressionStr = expression.toString().substring(3);
        }
        if ((dynamicObject = BusinessDataServiceHelper.loadSingle((String)"receipt_info", (String)"bank_version.number,id,receipt_acnt_num,trans_date,task_num,file_num,batch_no,custom_id,compeleted_flag,modifytime,createtime", (QFilter[])(filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray())).toArray())) == null) {
            return null;
        }
        EBCReceiptInfo receiptInfo = this.toEBCReceiptInfo(dynamicObject);
        return receiptInfo;
    }

    public EBCReceiptInfo findByCustomIdAndTransDateAndBankVersionIdAndBatchNo(String customId, LocalDate transDate, String bankVersionId, String batchNo) {
        QFilter filter;
        DynamicObject dynamicObject;
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<Object> paramsList = new ArrayList<Object>(16);
        if (!EBGStringUtils.isEmpty(customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (!EBGStringUtils.isEmpty(bankVersionId)) {
            expression.append("and bank_version.number=?").append(' ');
            paramsList.add(bankVersionId);
        }
        if (transDate != null) {
            expression.append("and trans_date>=?").append(' ');
            paramsList.add(transDate);
        }
        if (transDate != null) {
            expression.append("and trans_date<=?").append(' ');
            paramsList.add(transDate);
        }
        if (transDate != null) {
            expression.append("and batch_no=?").append(' ');
            paramsList.add(batchNo);
        }
        if (!EBGStringUtils.isEmpty(expressionStr = expression.toString())) {
            expressionStr = expression.toString().substring(3);
        }
        if ((dynamicObject = BusinessDataServiceHelper.loadSingle((String)"receipt_info", (String)"bank_version.number,id,receipt_acnt_num,trans_date,task_num,file_num,batch_no,custom_id,compeleted_flag,modifytime,createtime", (QFilter[])(filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray())).toArray())) == null) {
            return null;
        }
        EBCReceiptInfo receiptInfo = this.toEBCReceiptInfo(dynamicObject);
        return receiptInfo;
    }

    private EBCReceiptInfo toEBCReceiptInfo(DynamicObject dynamicObject) {
        EBCReceiptInfo info = new EBCReceiptInfo();
        info.setId(dynamicObject.getLong("id"));
        info.setBankVersionId(dynamicObject.getString("bank_version.number"));
        info.setBatchNo(dynamicObject.getString("batch_no"));
        String compeletedFlag = dynamicObject.getString("compeleted_flag");
        if (!EBGStringUtils.isEmpty(compeletedFlag)) {
            info.setCompeletedFlag(Integer.parseInt(compeletedFlag));
        }
        info.setModifytime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("modifytime")));
        info.setEbcTransDate(LocalDateUtil.date2LocalDate((Date)dynamicObject.getDate("trans_date")));
        info.setCustomNo(dynamicObject.getString("custom_id"));
        info.setFileNum(dynamicObject.getInt("file_num"));
        info.setReceiptAcntNum(dynamicObject.getInt("receipt_acnt_num"));
        info.setTaskNum(dynamicObject.getInt("task_num"));
        return info;
    }

    private DynamicObject packDetailInfo(DynamicObject dynamicObject, EBCReceiptInfo info) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"receipt_info");
        } else {
            dynamicObject.set("id", (Object)info.getId());
        }
        Date transDate = LocalDateUtil.localDate2Date((LocalDate)info.getEbcTransDate());
        dynamicObject.set("trans_date", (Object)transDate);
        dynamicObject.set("receipt_acnt_num", (Object)info.getReceiptAcntNum());
        dynamicObject.set("task_num", (Object)info.getTaskNum());
        dynamicObject.set("file_num", (Object)info.getFileNum());
        dynamicObject.set("batch_no", (Object)info.getBatchNo());
        dynamicObject.set("custom_id", (Object)info.getCustomNo());
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("compeleted_flag", (Object)info.getCompeletedFlag().toString());
        BankVersionRepository bankVersionRepository = BankVersionRepository.getInstance();
        DynamicObject bankVersion = bankVersionRepository.loadDynamicObjectByBankVersionID(info.getBankVersionId());
        dynamicObject.set("bank_version", (Object)bankVersion);
        return dynamicObject;
    }
}

