/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.framework.receipt.parse.FileParserRegister;
import kd.ebg.receipt.common.framework.receipt.parse.api.IFileInfo;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptMatchUtils {
    EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptMatchUtils.class);
    public static Map<String, Map<String, String>> bankVersionCommonParams = Maps.newHashMapWithExpectedSize((int)16);
    private static ReceiptMatchUtils instance;

    public static synchronized ReceiptMatchUtils getInstance() {
        if (instance == null) {
            instance = new ReceiptMatchUtils();
        }
        return instance;
    }

    public String isDefectByMatchNo(String jsonStr, Map<String, String> receiptParamsMap) {
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            StringBuilder defectMsg = new StringBuilder();
            for (Map.Entry<String, String> entry : receiptParamsMap.entrySet()) {
                String key = entry.getKey();
                if (Objects.equals(entry.getValue(), "e") || Objects.equals(entry.getValue(), CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[0]) || Objects.equals(entry.getValue(), CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[2]) || jsonObject.containsKey((Object)key) && !StringUtils.isEmpty((String)jsonObject.getString(key)) && !Objects.equals("e", jsonObject.getString(key))) continue;
                defectMsg.append(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u7684\u503c\u7f3a\u5931\u3002", (String)"ReceiptMatchUtils_1", (String)"ebg-receipt-common", (Object[])new Object[0]), key));
            }
            if (defectMsg.length() > 0) {
                return defectMsg.toString();
            }
        }
        catch (Throwable e) {
            this.logger.error("isDefectByMatchNo#error:" + e.getMessage(), e);
        }
        return null;
    }

    public Map<String, String> filterMustCommonByParserRegister(String bankVersion) {
        String value;
        String key = String.format("%s-%s-common", RequestContext.get().getAccountId(), bankVersion);
        if (bankVersionCommonParams.containsKey(key) && bankVersionCommonParams.get(key) != null) {
            return bankVersionCommonParams.get(key);
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)6);
        FileParserRegister fileParserRegister = SpringContextUtil.getBean(FileParserRegister.class);
        IFileInfo iFileInfo = fileParserRegister.getFileInfo(bankVersion, "xxx.pfd");
        if (iFileInfo == null) {
            return result;
        }
        result.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[5], CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[5]);
        try {
            value = iFileInfo.getAmount();
            if (!Objects.equals(value, "e")) {
                result.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[3], CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[3]);
            }
        }
        catch (Exception e) {
            result.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[3], CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[3]);
        }
        try {
            value = iFileInfo.getCdFlag();
            if (!Objects.equals(value, "e")) {
                result.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[4], CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[4]);
            }
        }
        catch (Exception e) {
            result.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[4], CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[4]);
        }
        try {
            value = iFileInfo.getOppAccNo();
            if (!Objects.equals(value, "e")) {
                result.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[1], CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[1]);
            }
        }
        catch (Exception e) {
            result.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[1], CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[1]);
        }
        bankVersionCommonParams.put(key, result);
        return result;
    }

    public Map<String, String> selectMustFiledByBankVersion(String bankVersion) {
        Map<String, String> matchRule = MatchRule.getInstance().getReceiptMatchRule(bankVersion);
        matchRule.remove("baseMatchRule");
        FileParserRegister fileParserRegister = SpringContextUtil.getBean(FileParserRegister.class);
        IFileInfo iFileInfo = fileParserRegister.getFileInfo(bankVersion, "xxx.pfd");
        if (iFileInfo != null) {
            for (String key : CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY) {
                matchRule.remove(key);
            }
        }
        Map<String, String> commonByParserRegister = this.filterMustCommonByParserRegister(bankVersion);
        matchRule.putAll(commonByParserRegister);
        matchRule.remove(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[0]);
        matchRule.remove(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[2]);
        return matchRule;
    }
}

